/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.model.statistical.*;

import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDContiguousRepresentation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteRepresentation;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRangeRepresentation;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSampleDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.SDTextRepresentation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalPackage;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.model.statistical.StatisticalPackage
 * @generated
 */
public class StatisticalSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static StatisticalPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatisticalSwitch()
	{
		if (modelPackage == null) {
			modelPackage = StatisticalPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject)
	{
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case StatisticalPackage.SD_DESCRIPTOR: {
					SDDescriptor sdDescriptor = (SDDescriptor)theEObject;
					Object result = caseSDDescriptor(sdDescriptor);
					if (result == null) result = caseAbstractTRCDescription(sdDescriptor);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_GAUGE_REPRESENTATION: {
					SDGaugeRepresentation sdGaugeRepresentation = (SDGaugeRepresentation)theEObject;
					Object result = caseSDGaugeRepresentation(sdGaugeRepresentation);
					if (result == null) result = caseSDRangeRepresentation(sdGaugeRepresentation);
					if (result == null) result = caseSDDiscreteRepresentation(sdGaugeRepresentation);
					if (result == null) result = caseSDRepresentation(sdGaugeRepresentation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_SAMPLE_DESCRIPTOR: {
					SDSampleDescriptor sdSampleDescriptor = (SDSampleDescriptor)theEObject;
					Object result = caseSDSampleDescriptor(sdSampleDescriptor);
					if (result == null) result = caseSDMemberDescriptor(sdSampleDescriptor);
					if (result == null) result = caseSDDescriptor(sdSampleDescriptor);
					if (result == null) result = caseAbstractTRCDescription(sdSampleDescriptor);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_VIEW: {
					SDView sdView = (SDView)theEObject;
					Object result = caseSDView(sdView);
					if (result == null) result = caseAbstractTRCView(sdView);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_SAMPLE_WINDOW: {
					SDSampleWindow sdSampleWindow = (SDSampleWindow)theEObject;
					Object result = caseSDSampleWindow(sdSampleWindow);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_DISCRETE_OBSERVATION: {
					SDDiscreteObservation sdDiscreteObservation = (SDDiscreteObservation)theEObject;
					Object result = caseSDDiscreteObservation(sdDiscreteObservation);
					if (result == null) result = caseSDSnapshotObservation(sdDiscreteObservation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_CONTIGUOUS_OBSERVATION: {
					SDContiguousObservation sdContiguousObservation = (SDContiguousObservation)theEObject;
					Object result = caseSDContiguousObservation(sdContiguousObservation);
					if (result == null) result = caseSDSnapshotObservation(sdContiguousObservation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_TEXT_OBSERVATION: {
					SDTextObservation sdTextObservation = (SDTextObservation)theEObject;
					Object result = caseSDTextObservation(sdTextObservation);
					if (result == null) result = caseSDSnapshotObservation(sdTextObservation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_RANGE_REPRESENTATION: {
					SDRangeRepresentation sdRangeRepresentation = (SDRangeRepresentation)theEObject;
					Object result = caseSDRangeRepresentation(sdRangeRepresentation);
					if (result == null) result = caseSDDiscreteRepresentation(sdRangeRepresentation);
					if (result == null) result = caseSDRepresentation(sdRangeRepresentation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_COUNTER_DESCRIPTOR: {
					SDCounterDescriptor sdCounterDescriptor = (SDCounterDescriptor)theEObject;
					Object result = caseSDCounterDescriptor(sdCounterDescriptor);
					if (result == null) result = caseSDMemberDescriptor(sdCounterDescriptor);
					if (result == null) result = caseSDDescriptor(sdCounterDescriptor);
					if (result == null) result = caseAbstractTRCDescription(sdCounterDescriptor);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_TEXT_REPRESENTATION: {
					SDTextRepresentation sdTextRepresentation = (SDTextRepresentation)theEObject;
					Object result = caseSDTextRepresentation(sdTextRepresentation);
					if (result == null) result = caseSDRepresentation(sdTextRepresentation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_DISCRETE_REPRESENTATION: {
					SDDiscreteRepresentation sdDiscreteRepresentation = (SDDiscreteRepresentation)theEObject;
					Object result = caseSDDiscreteRepresentation(sdDiscreteRepresentation);
					if (result == null) result = caseSDRepresentation(sdDiscreteRepresentation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case StatisticalPackage.SD_CONTIGUOUS_REPRESENTATION: {
					SDContiguousRepresentation sdContiguousRepresentation = (SDContiguousRepresentation)theEObject;
					Object result = caseSDContiguousRepresentation(sdContiguousRepresentation);
					if (result == null) result = caseSDRepresentation(sdContiguousRepresentation);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDDescriptor(SDDescriptor object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Member Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Member Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDMemberDescriptor(SDMemberDescriptor object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Gauge Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Gauge Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDGaugeRepresentation(SDGaugeRepresentation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Sample Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Sample Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDSampleDescriptor(SDSampleDescriptor object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDView(SDView object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Sample Window</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Sample Window</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDSampleWindow(SDSampleWindow object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Snapshot Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Snapshot Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDSnapshotObservation(SDSnapshotObservation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Discrete Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Discrete Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDDiscreteObservation(SDDiscreteObservation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Contiguous Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Contiguous Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDContiguousObservation(SDContiguousObservation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Text Observation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Text Observation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDTextObservation(SDTextObservation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Range Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Range Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDRangeRepresentation(SDRangeRepresentation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Counter Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Counter Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDCounterDescriptor(SDCounterDescriptor object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDRepresentation(SDRepresentation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Text Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Text Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDTextRepresentation(SDTextRepresentation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Discrete Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Discrete Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDDiscreteRepresentation(SDDiscreteRepresentation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>SD Contiguous Representation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>SD Contiguous Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSDContiguousRepresentation(SDContiguousRepresentation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCDescription(AbstractTRCDescription object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCView(AbstractTRCView object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object)
	{
		return null;
	}

} //StatisticalSwitch
