/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.internal.sdb.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBFactory;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBPackage;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SDBFactoryImpl extends EFactoryImpl implements SDBFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case SDBPackage.SDB_RUNTIME: return createSDBRuntime();
			case SDBPackage.SDB_SYMPTOM: return createSDBSymptom();
			case SDBPackage.SDB_MATCH_PATTERN: return createSDBMatchPattern();
			case SDBPackage.SDB_SOLUTION: return createSDBSolution();
			case SDBPackage.SDB_DIRECTIVE: return createSDBDirective();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBRuntime createSDBRuntime() {
		SDBRuntimeImpl sdbRuntime = new SDBRuntimeImpl();
		return sdbRuntime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBSymptom createSDBSymptom() {
		SDBSymptomImpl sdbSymptom = new SDBSymptomImpl();
		return sdbSymptom;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBMatchPattern createSDBMatchPattern() {
		SDBMatchPatternImpl sdbMatchPattern = new SDBMatchPatternImpl();
		return sdbMatchPattern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBSolution createSDBSolution() {
		SDBSolutionImpl sdbSolution = new SDBSolutionImpl();
		return sdbSolution;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBDirective createSDBDirective() {
		SDBDirectiveImpl sdbDirective = new SDBDirectiveImpl();
		return sdbDirective;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDBPackage getSDBPackage() {
		return (SDBPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SDBPackage getPackage() {
		return SDBPackage.eINSTANCE;
	}

} //SDBFactoryImpl
