/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

/**
 * Methods that can be remotely invoked should declare this exception
 * in the <code>throws</code> clause.
 */
public class RemoteInvocationException extends RuntimeException {
	
	protected Throwable cause;

	/**
	 * @param message a description of the condition that caused this exception
	 *        to be thrown
	 */
	public RemoteInvocationException(String message) {
		super(message);
	}
	
	/**
	 * @param message a description of the condition that caused this exception
	 *        to be thrown
	 * @param cause a <code>Throwable</code> that represents the underlying cause
	 *        of this exception having been thrown
	 */
	public RemoteInvocationException(String message, Throwable cause) {
		super(message);
		this.cause = cause;
	}
	
	/**
	 * @param cause a <code>Throwable</code> that represents the underlying cause
	 *        of this exception having been thrown
	 */
	public RemoteInvocationException(Throwable cause) {
		this.cause = cause;
	}

	/**
	 * @return a <code>Throwable</code> that represents the underlying cause of
	 *         this exception having been thrown
	 */	
	public Throwable getCause() {
		return cause;
	}

}
