/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;


/** @author slavescu
 *
 */
public final class XMLobjFreeLoader extends TraceXMLFragmentLoader {
    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        super.addAttribute(name, value);
    }

    public void addYourselfInContext() {
        if (!loadToModel) {
            TraceUtils.removeVirtualObject(context, objIdRef);

            return;
        }

        theProcess = getProcess();

        dispatchProcessMode(ProcessSteps.ALL);
        TraceUtils.removeVirtualObject(context, objIdRef);
    }

    public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();
        super.initialize(context, name);
    }

    /**
     *
     */
    protected void processEF(int step) {
        super.processEF(step);

		if(theObject!=null)
		{
            theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
	
	        if ((theObject == null) || (((TRCFullTraceObject) theObject).getCollectTime() != 0.0)) {
	            return;
	        }
	
	        ((TRCFullTraceObject) theObject).setCollectTime(createDeltaTime());
		}
		else
		{
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
	
			if ((theObject == null) || (((TRCFullTraceObject) theObject).getCollectTime() != 0.0)) {
				return;
			}
	
			((TRCFullTraceObject) theObject).setCollectTime(createDeltaTime());
			
			theClass = theObject.getIsA();

			updateClassStatistics(theObject.getSize());

		}
    }

    /**
     *
     */
    protected void processES(int step) {
        super.processES(step);

        if (virtualObject == null && theObject==null) {
            useVirtualObject();
        }
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(step);
        
        if(theObject!=null)
        {
			return;
        }
			
        theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, TRCHeapObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));

        if (theObject == null) {
            return;
        }
		theClass = theObject.getIsA();
	
		updateClassStatistics(theObject.getSize());

    }

    /**
     *
     */
    protected void processHS(int step) {
        super.processHS(step);

        if (virtualObject == null && theObject==null) {
            useVirtualObject();
        }
    }

    private void updateClassStatistics(int s) {
        theClass.setCollectedInstances(theClass.getCollectedInstances() + 1);
        theClass.setCollectedSize(theClass.getCollectedSize() + s);

        TRCPackage thePackage = theClass.getPackage();

        thePackage.setCollectedInstances(thePackage.getCollectedInstances() + 1);
        thePackage.setCollectedSize(thePackage.getCollectedSize() + s);
        theProcess.setCollectedInstances(theProcess.getCollectedInstances() + 1);
        theProcess.setCollectedSize(theProcess.getCollectedSize() + s);

        //		updateSuperPackagesStatistics(thePackage,size);
    }

    private void useVirtualObject() {
        virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));

        if (virtualObject != null) {
            theClass = virtualObject.myClass;

            if (theClass != null) {
                updateClassStatistics(virtualObject.size);
            }

            TraceUtils.removeVirtualObject(context, objIdRef);
        }
    }
}
