/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

public class ProfileBasePreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private ProfPreferencePage _filters;
	private TraceOptionsPreferencePage _options;
	private TraceCollectionPreferencePage _collections;
	
	/**
	 * Constructor for ProfileBasePreferencePage.
	 */
	public ProfileBasePreferencePage() {
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
	}
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		TraceUIPlugin.getPluginId()+".pbpp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		TabFolder folder = new TabFolder(composite, SWT.NONE);
		data = GridUtil.createFill();
		data.heightHint = 380;
		data.widthHint = 500;
		folder.setLayoutData(data);

		TabItem item;

		item = new TabItem(folder, SWT.NONE);
		item.setText(UIPlugin.getResourceString("STR_PREF_PROFILE_TAB_FILTERS"));
		item.setImage(PDPluginImages.getImage(PDPluginImages.IMG_FILTER));
		_filters = new ProfPreferencePage(getPreferenceStore());
		item.setControl(_filters.createContents(folder));

		item = new TabItem(folder, SWT.NONE);
		item.setText(UIPlugin.getResourceString("STR_PREF_PROFILE_TAB_OPTIONS"));
		item.setImage(PDPluginImages.getImage(PDPluginImages.IMG_OPTIONS));
		_options = new TraceOptionsPreferencePage(getPreferenceStore(),this);
		item.setControl(_options.createContents(folder));

		item = new TabItem(folder, SWT.NONE);
		item.setText(UIPlugin.getResourceString("STR_PREF_PROFILE_TAB_COLLECTIONS"));
		item.setImage(PDPluginImages.getImage(PDPluginImages.IMG_OPTIONS));
		_collections = new TraceCollectionPreferencePage(getPreferenceStore(),this);
		item.setControl(_collections.createContents(folder));

		return composite;
	}
	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		_filters.performDefaults();
		_options.performDefaults();
		_collections.performDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		_filters.performOk();
		_options.performOk();
		_collections.performOk();
		return true;
	}
}
