/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCaseUniqueNameAdapter;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestCasesForm
extends EditorForm implements ISelectionChangedListener, IITestSuiteProvider
{
	protected static final int HELP_NAMED_ELEMENT_CONTROL = 1;
	protected static final int HELP_TEST_CASES_SECTION_CONTROL = 2;
	protected static final int HELP_TEST_CASES_SECTION_TREE_CONTROL = 3;
	protected static final int HELP_DETAIL_SECTION_CONTROL = 4;

	private EObjectTreeSection testCasesSection;
	private NamedElementSection namedElementSection;
	private DetailSection detailSection;
	private boolean firstActivation = true;
	
	/**
	 * Constructor for CommonTestCasesForm
	 * @param testSuiteEditorExtension
	 * @param widgetFactory
	 */
	public TestCasesForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		testCasesSection.getTreeViewer().removeSelectionChangedListener(this);
		testCasesSection.dispose();
		namedElementSection.dispose();
		if(detailSection != null)
			detailSection.dispose();
		
		super.dispose();
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider#getTestSuite()
	 */
	public ITestSuite getTestSuite()
	{
		return ((IITestSuiteProvider)getBaseEditorExtension()).getTestSuite();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		createLeftColumn(leftColumn);
		createRightColumn(rightColumn);
	}
	
	protected void createLeftColumn(Composite parent)
	{
		createTestCaseSection(parent);
	}

	protected void createRightColumn(Composite parent)
	{
		createNamedElementSection(parent);
		createDetailSection(parent);
	}
	
	protected void createTestCaseSection(Composite parent)
	{
		testCasesSection = createTestCasesSection();
		registerSection(testCasesSection);
		testCasesSection.setHeaderText(getTestCasesSectionHeaderText());
		testCasesSection.setCollapsable(true);
		Control control = testCasesSection.createControl(parent, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));
		registerHelp(HELP_TEST_CASES_SECTION_CONTROL, control);
		registerHelp(HELP_TEST_CASES_SECTION_TREE_CONTROL, testCasesSection.getTreeViewer().getControl());
	}
	
	protected EObjectTreeSection createTestCasesSection()
	{
		return new EObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), getAddTestCaseAction());
	}

	protected void createNamedElementSection(Composite parent)
	{
		namedElementSection = new NamedElementSection(this);
		namedElementSection.setHeaderText(TestCommonPlugin.getString("EDT_GENERAL_INFO"));
		registerSection(namedElementSection);		
		Control control = namedElementSection.createControl(parent, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		registerHelp(HELP_NAMED_ELEMENT_CONTROL, control);	
	}
	
	protected void createDetailSection(Composite parent)
	{
		DetailSection aDetailSection = new DetailSection(this);
		addDetails(aDetailSection);	
		if(!aDetailSection.isEmpty())
		{
			detailSection = aDetailSection;
			detailSection.setHeaderText(TestCommonPlugin.getString("TTL_DTL_PROPS"));
			registerSection(detailSection);
			Control control = detailSection.createControl(parent, getWidgetFactory());
			control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
			registerHelp(HELP_DETAIL_SECTION_CONTROL, control);
		}
	}
	
	protected IAction getAddTestCaseAction()
	{
		return null;
	}
	
	protected String getTestCasesSectionHeaderText()
	{
		return TestCommonPlugin.getString("W_TST_CASES");
	}
		
	protected void registerHelp(int flag, Object object)
	{
	}

	protected void addDetails(DetailSection detailSection)
	{
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		EMFUtil.addAdapter(getTestSuite().getITestCases().iterator(), new TestCaseUniqueNameAdapter());
		
		testCasesSection.getTreeViewer().removeSelectionChangedListener(this);
		testCasesSection.setInput(getTestSuite());
		testCasesSection.getTreeViewer().addSelectionChangedListener(this);
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		testCasesSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == testCasesSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			namedElementSection.setInput(structuredSelection);
			if(detailSection != null)
				detailSection.setInput(structuredSelection);
		}
	}
	
	public ISelection getSelection()
	{
		return testCasesSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			testCasesSection.setFocus();
		}
		
		return super.activated();
	}
}
