/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.ui.*;

public class PDPerspective implements IPerspectiveFactory
{
   public static final String ID_TRACE_PERSPECTIVE = "org.eclipse.hyades.trace.internal.ui.tracePerspective";
   public static final String ID_PD_NAVIGATOR_VIEW   = "org.eclipse.hyades.trace.internal.ui.PDProjectExplorer";
   public static final String ID_CONSOLE_VIEW= "org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView";
   public static final String ID_LOG_NAVIGATOR_VIEW = "org.eclipse.hyades.log.ui.internal.navigator.LogNavigator";

	public void createInitialLayout(IPageLayout layout)
	{	
		//Top right
		IFolderLayout topRight = layout.createFolder("topRight", IPageLayout.TOP, (float)0.70,
			layout.getEditorArea());
		
		// Top left.
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, (float)0.30,
			"topRight");
		topLeft.addView(ID_PD_NAVIGATOR_VIEW);		
		topLeft.addView(IPageLayout.ID_RES_NAV);		
		topRight.addPlaceholder(ID_CONSOLE_VIEW);
		
		IFolderLayout bottomRight = layout.createFolder("bottomRight", IPageLayout.BOTTOM, (float)0.80,
				"topLeft");
		bottomRight.addView(IPageLayout.ID_PROP_SHEET);
		
		layout.addShowViewShortcut(ID_PD_NAVIGATOR_VIEW);												
		layout.addShowViewShortcut(ID_CONSOLE_VIEW);
		layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);	
		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);											
					
		//new actions
		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");

		layout.setEditorAreaVisible(false);
				
	}
}
