/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import java.util.Iterator;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceNavigatorActionGroup;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachTraceAction;
import org.eclipse.hyades.trace.ui.internal.launcher.LaunchTraceAction;
import org.eclipse.hyades.trace.ui.internal.util.UnresolvedResourceHelper;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PDProjectExplorer extends Navigator  implements IProfileEventListener
												  , IPropertyListener
{	

	private final String TRACE_SECTION = "TraceNavigator";
	
	protected TraceNavigatorActionGroup actionGroup;

	//private PDProjectViewer structuredViewer;
	//private IDialogSettings settings;	
	//private boolean linkingEnabled;	
	
    class RefreshUI extends Thread {
	  public RefreshUI() {
		  super("Profile_Refresh");
	  }

	  public void run() {

          while(getViewer() != null)
          {
          	try {
          		
				IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
				int refreshType = store.getInt(TraceConstants.REFRESH_TYPE);
				Display display = Display.getDefault();
				
				if(refreshType == 1
				    && display != null && !display.isDisposed())//automatic refresh
				{
					display.asyncExec(new Runnable() {
							public void run() {
								
								TreeItem item = ((PDProjectViewer)getViewer()).getTreeSelection();	   
								if(item != null && (item.getData() instanceof EObject))
								{
									EObject data = (EObject)item.getData();
									
									if(isModified(data))
									{
										ProfileEvent event = UIPlugin.getDefault().getUpdateModelEvent(data);
										UIPlugin.getDefault().notifyProfileEventListener(event); 										
									}
								}	  	  	 
							}
						});
					
				}
				 				
				sleep(store.getInt(TraceConstants.REFRESH_INTERVAL)*1000);				
			  }          		
		      catch (InterruptedException exc) {
		      } 
          }          
 	  }
 	  
	  private boolean isModified(Object selObject)
	  {
		  if(selObject != null)
		  {
			  if(selObject instanceof TRCAgentProxy)
			  {
				  return isAgentModified((TRCAgentProxy)selObject);
			  }
			
			  if(selObject instanceof TRCProcessProxy)
			  {
				  Object[] agents = ((TRCProcessProxy)selObject).getAgentProxies().toArray();
				  for(int idx=0; idx<agents.length; idx++)
				  {
				  	  boolean isModified = isAgentModified((TRCAgentProxy)agents[idx]);
				  	  if(isModified)
				  	    return true;	
				  }							
				  return false;
			  }
			
			  if(selObject instanceof TRCNode)
			  {
				  Object[] processes = ((TRCNode)selObject).getProcessProxies().toArray();
				  for(int idx=0; idx<processes.length; idx++)
				  {
					  Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
					  for(int i=0; i<agents.length; i++)
					  {
						  boolean isModified = isAgentModified((TRCAgentProxy) agents[i]);
						  if(isModified)
						    return true;						
					  }					
				  }
				  return false;								
			  }
			
			  if(selObject instanceof TRCMonitor)
			  {
				  Object[] nodes = ((TRCMonitor)selObject).getNodes().toArray();
				
				  for(int k=0; k<nodes.length; k++)
				  {
					  Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
					  for(int idx=0; idx<processes.length; idx++)
					  {
						  Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
						  for(int i=0; i<agents.length; i++)
						  {
							boolean isModified = isAgentModified((TRCAgentProxy) agents[i]);
							if(isModified)
							  return true;						
						  }						  						
					  }
				  }
				  return false;								
			  }
		  }
		  
		  return false;
    	
	  }
    
	  private boolean isAgentModified(TRCAgentProxy agent)
	  {
	  	 if(agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE))
	  	 {
	  	 	if(agent.isCollectionData()) 
				return true;
				
			if(agent.getAgent() != null && agent.getAgent().eResource() != null &&
				agent.getAgent().eResource().isModified())
			{
				agent.getAgent().eResource().setModified(false);
				return true;
			}

	  	 	  
	  	 	return false;  
	  	 }
	  	 else
	  	 {
	  	 	if(agent.getAgent() != null && agent.getAgent().eResource() != null &&
	  	 	   agent.getAgent().eResource().isModified())
	  	 	   {
				   agent.getAgent().eResource().setModified(false);
				   return true;				   
	  	 	   }
	  	 	
	  	 	return false;
	  	 }
	  	 
	  }	
  }

	
	public PDProjectExplorer() {
		super();
		
		/* set project explorer to resource helper such that it can be notified dirty for save */
		Object ue = HierarchyResourceSetImpl.getInstance().getUnresolvedException();
		if ((ue != null) && (ue instanceof UnresolvedResourceHelper))
			 ((UnresolvedResourceHelper) ue).setPDProjectExplorer(this);
	}
	/**
	 * Creates the SWT controls for a part.  
	 *
	 * TIP : This method must call hookFocus() on some control (most likely
	 * the top-level control), within the view.  This translates OS-level
	 * focus to part focus within the desktop.
	 */
	public void createPartControl(Composite parent) {
	
		TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener(this);
	    super.createPartControl(parent);
	  
		initListeners();
		// register this viewer as the debug UI selection provider
		UIPlugin.getDefault().addSelectionProvider(getViewer(), this);		
		UIPlugin.getDefault().addProfileEventListener(this);
		
		(new RefreshUI()).start();
	}

	/**
	 * Updates the action bar actions.
	 * 
	 * @param selection the current selection
	 * @since 2.0
	 */
	protected void updateActionBars(IStructuredSelection selection) {
		TraceNavigatorActionGroup group = (TraceNavigatorActionGroup)getActionGroup(false);
		if (group != null) {
			group.setContext(new ActionContext(selection));
			group.updateActionBars();
		}
	}
	
	/**
	 * Updates the action bar actions.
	 * 
	 * @param selection the current selection
	 * @since 2.0
	 */
	public void updateActionBars() {
		TraceNavigatorActionGroup group = (TraceNavigatorActionGroup)getActionGroup(false);
		if (group != null) {
			group.updateActionBars();
		}
	}
	

	/**
	 * @see IWorkbenchPart
	 */
	public void dispose() {

		
		TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener(this);
		
		if (getActionGroup(true) != null) {
			getActionGroup(true).dispose();
			actionGroup = null;
		}
		
		UIPlugin.getDefault().removeProfileEventListener(this);		
		
		if (getViewer() != null)
			UIPlugin.getDefault().removeSelectionProvider(getViewer(), this);

			
		HyadesUtil.cleanupResources(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		super.dispose();
	}
	
	public final boolean hasFilter(int filter){
		return ((PDProjectViewer)getViewer()).hasFilter(filter);		
	}

	public Control getControl(){
		return getViewer().getControl();
	}
	
	public void refresh(){
		getViewer().refresh();
		
		
	}	

	/**
	 * Initializes and registers the context menu.
	 * 
	 */
	protected void initContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				PDProjectExplorer.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(((PDProjectViewer)getViewer()).getTree());
		((PDProjectViewer)getViewer()).getTree().setMenu(menu);
		getSite().registerContextMenu(menuMgr, getViewer());
	}

	/**
	 * Adds the listeners to the viewer.
	 * 
	 */
	protected void initListeners() {
		
		getViewer().addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				handleDoubleClick(event);
			}
		});
	}

    /**
     * Initialize and register context menu
     * @param menu
     */
	public void fillContextMenu(IMenuManager menu) {
		
		IStructuredSelection selection =
			(IStructuredSelection) getViewer().getSelection();
		getActionGroup(false).setContext(new ActionContext(selection));
		getActionGroup(false).fillContextMenu(menu);
	}

	/**
	 * Returns the trace explorer part of the active perspective. If 
	 * there isn't any trace explorer part <code>null</code> is returned.
	 */
	public static PDProjectExplorer getFromActivePerspective() {
		
		IViewPart view = 
			//ALEX!!! UIPlugin.getActivePage().showView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
			UIPlugin.getActivePage().findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		
		if (view instanceof PDProjectExplorer)
			return (PDProjectExplorer) view;
		
		return null;
	}

	/**
	 * Returns the tool tip text for the view.
	 */
	protected String getToolTipText() {
		return UIPlugin.getResourceString("PDPROEXPTOOLTIP");
	}
	
	/**
	 * Returns the action group.
	 * 
	 * @return the action group
	 */
	protected NavigatorActionGroup getActionGroup() {
		return actionGroup;
	}
	
	protected NavigatorActionGroup getActionGroup(boolean dispose)
	{
		if (!dispose)
		{
			if (actionGroup == null) createActions();
		}
		return getActionGroup();
	}

	/**
	 * Sets the action group.
	 * 
	 * @param actionGroup the action group
	 */
	protected void setActionGroup(TraceNavigatorActionGroup actionGroup) {
		this.actionGroup = actionGroup;
	}

	/**
	 * Handles double clicks in viewer.
	 * Opens editor if file double-clicked.
	 */
	protected void handleDoubleClick(DoubleClickEvent event) {
		
		((TraceNavigatorActionGroup)getActionGroup(false)).handleDoubleClick(event);
	}
	
	

	/**
	 * Insert the method's description here.
	 * Creation date: (10/05/2000 1:19:46 PM)
	 */
	public void refreshView(Object selection) {
		getViewer().refresh();

		((PDProjectViewer)getViewer()).selectObject(selection);

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (09/26/2000 12:35:46 PM)
	 * @param obj java.lang.Object
	 */
	public void selectObject(Object item) {
		((PDProjectViewer)getViewer()).selectObject(item);
	}
	/**
	 * Asks the part to take focus within the desktop.
	 */
	public void setFocus() {
		if (getViewer() != null)
		((PDProjectViewer)getViewer()).getTree().setFocus();
	}

	private void addLaunchOptions(IMenuManager menu)
	{
		menu.add(new LaunchTraceAction());		
		menu.add(new AttachTraceAction());
	}

    /**
     * 
     */
	public void handleProfileEvent(ProfileEvent event) {
			
		switch(event.getType())
		{
			case ProfileEvent.START_MONITOR:
			
			((PDProjectViewer)getViewer()).selectObject(event.getSource());
			   
			break;
			
			case ProfileEvent.ATTACH:
			
			((PDProjectViewer)getViewer()).selectObject(event.getSource());
			   
			break;
			
			case ProfileEvent.CLEAN_UP :
			break;
			
			case ProfileEvent.REFRESH_LOG_NAVIGATOR:
			break;
			
			default:	
			((PDProjectViewer)getViewer()).refresh(event.getSource());
			
			
		}	
	}

	/**
	 * Indicates that a property has changed.
	 * @see IPropertyListener
	 */
	public void propertyChanged(Object source, int propId)
	{
		//reset trace view actions
		((TraceNavigatorActionGroup)getActionGroup(false)).propertyChanged(source, propId);
	}
  

    /**
     * 
     * @param enabled
     */  
	public void setLinkingEnabled(boolean enabled)
	{

		super.setLinkingEnabled(enabled);		
		// if turning linking on, update the selection to correspond to the selection
		if(enabled)
		{
			if(getViewer() != null)
				getViewer().setSelection(getViewer().getSelection());
		}
	}

	public AbstractUIPlugin getPlugin() {

		return UIPlugin.getDefault();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#getStoreSection()
	 */
	public String getStoreSection() {

		return TRACE_SECTION;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#createActions()
	 */
	protected void createActions() {
		
		setActionGroup(new TraceNavigatorActionGroup(this));
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#createViewerInput()
	 */
	protected Object createViewerInput() {

		return ResourcesPlugin.getWorkspace().getRoot();
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#createViewer(org.eclipse.swt.widgets.Composite)
	 */
	protected StructuredViewer createViewer(Composite parent) {

		StructuredViewer viewer = new PDProjectViewer(parent);
		viewer.setContentProvider(new PDContentProvider(this));
		viewer.setLabelProvider(new PDLabelProvider());
		
		return viewer;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#editorActivated(org.eclipse.ui.IEditorPart)
	 */
	protected boolean editorActivated(IEditorPart editor) {
		// TODO Auto-generated method stub
		return false;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.Navigator#linkToEditor(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected void linkToEditor(IStructuredSelection selection) {
		// TODO Auto-generated method stub
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.INavigator#isShowingFolders()
	 */
	public boolean isShowingFolders() {
		// TODO Auto-generated method stub
		return false;
	}
	/**
	 * 
	 */
	public Shell getShell() {
		return getViewSite().getShell();
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
	}
	
	public void clear()
	{
		
	Iterator docs = HierarchyResourceSetImpl.getInstance().getResources().iterator();
		int counter = 0;
		while(docs.hasNext())
		{
			counter++;
			docs.next();
		}
		if (counter < 2) 
		{
			if (getActionGroup(true) != null) {
					getActionGroup(true).dispose();
					actionGroup = null;
				}
			
				ProfileEvent event = new ProfileEvent();
				event.setSource(null);
				event.setType(ProfileEvent.CLEAN_UP);
				UIPlugin.getDefault().notifyProfileEventListener(event);
	
		}
		refresh();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IPartListener#partActivated(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partActivated(IWorkbenchPart part) {		
		super.partActivated(part);
		if(part==this){
			getViewer().setSelection(((Navigator)part).getStructuredSelection());
		}		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IPartListener#partBroughtToTop(org.eclipse.ui.IWorkbenchPart)
	 */
	public void partBroughtToTop(IWorkbenchPart part) {
		super.partBroughtToTop(part);
		if(part==this){
			getViewer().setSelection(((Navigator)part).getStructuredSelection());
		}
	}

}

