/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.util.ArrayList;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

public class EnvironmentDialog extends Dialog implements SelectionListener {
	private Table _table;
	private TableViewer _tableViewer;
	private Button _editBtn;
	private Button _addBtn;
	private Button _deleteBtn;
	private ArrayList _data = new ArrayList();
	private EnvList _envList;
	private boolean _buttonEnable;

	private java.lang.String _title;

	class EnvList implements IBasicPropertyConstants {

		ArrayList _values = new ArrayList();
		EnvContentProvider _listener;

		public EnvList(EnvContentProvider listener) {
			_listener = listener;
		}
		public void add(EnvTableElement element) {
			add(element, -1);
		}
		public void add(EnvTableElement element, int index) {
			if (index < 0)
				_values.add(element);
			else
				_values.add(index, element);
		}
		/**
		 * 
		 */
		public void fireElementChanged(
			EnvTableElement changedElement,
			String changedProperty) {
			// forward change to content providers.
			_listener.elementChanged(changedElement, changedProperty);
		}
		public Object getElementAt(int index) {
			return _values.get(index);
		}
		public ArrayList getValues() {
			return _values;
		}
		public int getSize() {
			return _values.size();
		}
		/**
		 * Insert the method's description here.
		 * Creation date: (08/22/2000 4:53:57 PM)
		 */
		public void removeAll() {
			_values.clear();
		}
		/**
		 * Insert the method's description here.
		 * Creation date: (08/22/2000 3:48:34 PM)
		 * @param idx int
		 */
		public Object removeElementAt(int idx) {
			Object element = _values.get(idx);

			if (element == null)
				return null;

			_values.remove(element);

			return element;
		}
	}


	class EnvContentProvider implements IStructuredContentProvider {

		private TableViewer _viewer;
		protected EnvTableElement fChangedElement;

		/**
		 * The constructor.
		 */
		public EnvContentProvider(TableViewer tableViewer) {
			_viewer = tableViewer;
		}
		/**
		 * The visual part that is using this content provider is about
		 * to be disposed. Deallocate all allocated SWT resources.
		 */
		public void dispose() {
		}
		/**
		 * 
		 */
		public void elementChanged(
			EnvTableElement changedElement,
			String changedProperty) {
			fChangedElement = changedElement;
			_viewer.getControl().getDisplay().asyncExec(new Runnable() {
				public void run() {

					_viewer.refresh(fChangedElement);
				}
			});

		}
		/**
		 * Returns all the markers that should be shown for
		 * the current settings.
		 */

		public Object[] getElements(Object parent) {
			return ((EnvList) parent).getValues().toArray();
		}
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		/**
		 */
		public boolean isDeleted(Object element) {
			return false;
		}
	}

	class EnvLabelProvider extends LabelProvider implements ITableLabelProvider {
		public EnvLabelProvider() {
			super();
		}
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}
		public Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
			return null;
		}
		public String getColumnText(Object element, int columnIndex) {
			if (columnIndex == 0)
				return ((EnvTableElement) element).name();
			if (columnIndex == 1)
				return ((EnvTableElement) element).value();

			return "";
		}
		public String getColumnText(Viewer viewer, Object element, int columnIndex) {
			if (columnIndex == 0)
				return ((EnvTableElement) element).name();
			if (columnIndex == 1)
				return ((EnvTableElement) element).value();

			return "";
		}
	}

	class EditDialog extends Dialog implements ModifyListener{
		private String _name;
		private String _value;
		private Text _nameText;
		private Text _valueText;

		public EditDialog(Shell shell, String name, String value) {
			super(shell);

			_name = name;
			_value = value;
		}

		protected void configureShell(Shell shell) {
			super.configureShell(shell);
			shell.setText(UIPlugin.getResourceString("ENV_VARIABLE"));
		}

		public void name(String name) {
			_name = name;
		}

		public String name() {
			return _name;
		}

		public void value(String value) {
			_value = value;
		}

		public String value() {
			return _value;
		}

		protected Control createDialogArea(Composite parent) {
			Composite result = (Composite) super.createDialogArea(parent);

			GridLayout layout;
			GridData data;
			Label label;

			layout = new GridLayout();
			layout.numColumns = 2;
			result.setLayout(layout);
			data = GridUtil.createFill();
			data.heightHint = 50;
			data.widthHint = 400;
			result.setLayoutData(data);

			label = new Label(result, SWT.NULL);
			label.setText(UIPlugin.getResourceString("VAR_NAME"));
			_nameText = new Text(result, SWT.BORDER);
			_nameText.setLayoutData(GridUtil.createHorizontalFill());

			label = new Label(result, SWT.NULL);
			label.setText(UIPlugin.getResourceString("VAR_VALUE"));
			_valueText = new Text(result, SWT.BORDER);
			_valueText.setLayoutData(GridUtil.createHorizontalFill());

			_nameText.addModifyListener(this);
			_valueText.addModifyListener(this);
			
			if (_name != null)
				_nameText.setText(_name);
			if (_value != null)
				_valueText.setText(_value);

			return result;
		}
		
		public void modifyText(ModifyEvent e)
		{
			if (e.widget == _nameText || e.widget == _valueText)
			{
				if (getButton(IDialogConstants.OK_ID)!=null)
					getButton(IDialogConstants.OK_ID).setEnabled(_nameText.getText().trim()!="");
			}	
		}
		
		protected void okPressed() {
			
			_name = _nameText.getText().trim();
			_value = _valueText.getText().trim(); 
			super.okPressed();
		}
		

	}
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public EnvironmentDialog(Shell shell, String windowTitle, ArrayList data, boolean enable) {
		super(shell);
		_title = windowTitle;
		_buttonEnable = enable;

		if (data != null) {
			_data.addAll(data);
		}
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 200;
		data.widthHint = 400;
		result.setLayoutData(data);

		Label description = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		description.setLayoutData(data);

		description.setText(UIPlugin.getResourceString("ENV_VAR_DESC"));

		initializeTable(result);

		Composite btnGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 3;
		btnGroup.setLayout(layout);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		btnGroup.setLayoutData(data);

		_addBtn = new Button(btnGroup, SWT.NULL);
		data = new GridData();
		data.horizontalAlignment = GridData.HORIZONTAL_ALIGN_END;
		_addBtn.setLayoutData(data);
		_addBtn.setText(UIPlugin.getResourceString("ADD_BUTTON"));

		_editBtn = new Button(btnGroup, SWT.NULL);
		data = new GridData();
		data.horizontalAlignment = GridData.HORIZONTAL_ALIGN_END;
		_editBtn.setLayoutData(data);
		_editBtn.setText(UIPlugin.getResourceString("EDIT_BUTTON"));

		_deleteBtn = new Button(btnGroup, SWT.NULL);
		data = new GridData();
		data.horizontalAlignment = GridData.HORIZONTAL_ALIGN_END;
		_deleteBtn.setLayoutData(data);
		_deleteBtn.setText(UIPlugin.getResourceString("DELETE_TEXT"));

		_table.addSelectionListener(this);
		_addBtn.addSelectionListener(this);
		_editBtn.addSelectionListener(this);
		_deleteBtn.addSelectionListener(this);
		
		_addBtn.setEnabled(_buttonEnable);
		_deleteBtn.setEnabled(false);
		_editBtn.setEnabled(false);

		return result;
	}

	private void createColumns() {
		TableLayout layout = new TableLayout();
		_table.setLayout(layout);
		_table.setHeaderVisible(true);
		String headers[] = { UIPlugin.getResourceString("VARIABLE_TEXT"), UIPlugin.getResourceString("VALUE_TEXT") };
		ColumnLayoutData layouts[] =
			{ new ColumnPixelData(120, true), new ColumnPixelData(280, true)};

		final TableColumn columns[] = new TableColumn[headers.length];
		int ncolumns = 0;

		for (int i = 0; i < headers.length; i++) {
			layout.addColumnData(layouts[i]);
			TableColumn tc = new TableColumn(_table, SWT.NONE, i);
			tc.setResizable(layouts[i].resizable);
			tc.setText(headers[i]);
			columns[i] = tc;
		}
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:12:31 PM)
	 */
	protected void initializeTable(Composite parent) {
		_table =
			new Table(
				parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.SINGLE | SWT.FULL_SELECTION);
		_table.setLinesVisible(false);
		_table.setLayoutData(GridUtil.createFill());

		_tableViewer = new TableViewer(_table);
		createColumns();

        EnvContentProvider provider = new EnvContentProvider(_tableViewer);
		_tableViewer.setContentProvider(new EnvContentProvider(_tableViewer));
		_tableViewer.setLabelProvider(new EnvLabelProvider());

		_envList = new EnvList(provider);
		
		populateTable();
		_tableViewer.setInput(_envList);
				
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 4:13:01 PM)
	 * @return java.util.ArrayList
	 */
	public ArrayList getData() {
		return _data;
	}
	
	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	protected void okPressed() {
		
		_data.clear();
		for (int idx = 0; idx < _envList.getSize(); idx++) {			
			_data.add(_envList.getElementAt(idx));
		}
		
		super.okPressed();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:05:18 PM)
	 */
	private void populateTable() {
		
		for (int idx = 0; idx < _data.size(); idx++) {			
			_envList.add((EnvTableElement)_data.get(idx));
		}
	}
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		if (e.widget == _addBtn) {
			EditDialog dialog = new EditDialog(getShell(), null, null);
			dialog.open();

			if (dialog.getReturnCode() == Window.OK) {
				EnvTableElement elem = new EnvTableElement(dialog.name(), dialog.value());
				if (elem.name()!="")
					_envList.add(elem); 
			
				_tableViewer.refresh();
			}

		} else if (e.widget == _editBtn) {
			
			int idx = _table.getSelectionIndex();
			if(idx != -1)
			{
				EnvTableElement elem = (EnvTableElement)_envList.getElementAt(idx);
				EditDialog dialog = new EditDialog(getShell(), elem.name(), elem.value());
				dialog.open();
	
				if (dialog.getReturnCode() == Window.OK) {
					elem.value(dialog.value());
					elem.name(dialog.name());
					_tableViewer.refresh();

				}
				
			}

		} else if (e.widget == _deleteBtn) {
			
			int idx = _table.getSelectionIndex();
			if(idx != -1)
			{
				_envList.removeElementAt(idx);
				_tableViewer.refresh();
			}			
		}

		int idx = _table.getSelectionIndex();
		_editBtn.setEnabled(idx != -1 && _buttonEnable);
		_deleteBtn.setEnabled(idx != -1 && _buttonEnable);
	}
}
