/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.hyades.trace.ui.internal.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.ui.*;

/*
* CONTEXT_ID rlnc0000 for relaunch process action
*/

public class RelaunchTraceAction extends org.eclipse.jface.action.Action
{
    private PDProjectExplorer fViewer;  	
	private TraceArguments    _trace;
	
/**
 * LaunchTraceAction constructor comment.
 */
  public RelaunchTraceAction(PDProjectExplorer viewer)
  {
	super(UIPlugin.getResourceString("RLNCHTRCACTN_RELAUNCH_TRACE"));
	setToolTipText(UIPlugin.getResourceString("RLNCHTRCACTN_RELAUNCH_TRACE"));
	
	fViewer = viewer;
  }

public RelaunchTraceAction(TraceArguments trace)
{
	super(trace.toString());
	setToolTipText(UIPlugin.getResourceString("RLNCHTRCACTN_RELAUNCH_TRACE"));
	_trace = trace;
}
/**
 * Implementation of method defined on <code>IAction</code>.
 */
public void run()
{
    Object selection = null;
	if(_trace != null && _trace.getType() != null)
	{
		selection = _trace.getType();
	}
	else
	{		
		TRCProcessProxy process = null;
		TRCAgentProxy agent = null;
		
		if(fViewer == null)
		{
			agent = _trace.getAgent(); 
			process = _trace.getProcess();			
		}
		else
		{
		
			IStructuredSelection sel = (IStructuredSelection) fViewer.getViewer().getSelection();
			if (sel == null || sel.isEmpty())
				return;
		
			Object o = sel.iterator().next();
			if (o instanceof TRCProcessProxy) {
				process = (TRCProcessProxy) o;
			}
			else if (o instanceof TRCAgentProxy) {
				agent = (TRCAgentProxy) o;
			}
		}
		
		if(process != null && agent == null)
		{
		   selection = process;
		}
		else if(agent != null)
		{
			selection = agent;
		}
	}

	final IWorkbenchWindow window= UIPlugin.getActiveWorkbenchWindow();	
	RelaunchWizard wizard = new RelaunchWizard(selection);	
	WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
	dialog.open();
	
}
}
