/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.wizard.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.ui.*;

public class TraceAction extends Action implements IWorkbenchWindowActionDelegate
{
	public TraceAction()
	{
		super("Trace");
		PDPluginImages.setImageDescriptors(this,PDPluginImages.T_TOOL,PDPluginImages.IMG_ACT_TRACE);
	}
	public void dispose() {
		// do nothing.
	}
	public void init(IWorkbenchWindow window) {
		// do nothing.
	}
/**
 * Insert the method's description here.
 * Creation date: (5/7/2001 11:57:31 AM)
 */
protected void launchTraceWizard()
{
	org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
		public void run() {
				final IWorkbenchWindow window= UIPlugin.getActiveWorkbenchWindow();		
				LaunchLocalWizard wizard = new LaunchLocalWizard();
				WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
				dialog.open();
		}
	});	
}
	public void run()
	{
		launchTraceWizard();

	}
	//---- IWorkbenchWindowActionDelegate ------------------------------------------------

	public void run(IAction action) {
		run();
	}
	public void selectionChanged(IAction action, ISelection selection) {
		// do nothing. Action doesn't depend on selection.
	}
}
