/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ColorManager;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
* CONTEXT_ID tcpp0000 for Console preference page
*/

/**
 * A page to set the preferences for the console
 */
public class TraceConsolePreferencePage extends FieldEditorPreferencePage
										implements IWorkbenchPreferencePage
{
		
	private static final String PREFIX= "console_preferences.";
	private static final String DESCRIPTION= PREFIX + "description";
	private static final String OUT= PREFIX + "out";
	private static final String ERR= PREFIX + "err";
	private static final String IN= PREFIX + "in";
	private static final String FONT=PREFIX + "font";

	/**
	 * Create the console page.
	 */
	public TraceConsolePreferencePage() {
		super(GRID);
		setDescription(UIPlugin.getResourceString("STR_COSOLE_PREF_DESCRIPTION"));
		
		IPreferenceStore store= UIPlugin.getDefault().getPreferenceStore();
		setPreferenceStore(store);
	}
	
	protected Control createContents(Composite parent)
	{
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".tcpp0000");
		
		return super.createContents(parent);
	}
	
	/**
	 * Create all field editors for this page
	 */
	public void createFieldEditors() {

		// Note: first String value is the key for the preference bundle and second the
		// second String value is the label displayed in front of the editor.
		ColorFieldEditor sysout= new ColorFieldEditor(TraceConstants.CONSOLE_SYS_OUT_RGB, UIPlugin.getResourceString(OUT), getFieldEditorParent());
		ColorFieldEditor syserr= new ColorFieldEditor(TraceConstants.CONSOLE_SYS_ERR_RGB, UIPlugin.getResourceString(ERR), getFieldEditorParent());
		ColorFieldEditor sysin= new ColorFieldEditor(TraceConstants.CONSOLE_SYS_IN_RGB, UIPlugin.getResourceString(IN), getFieldEditorParent());

		FontFieldEditor font= new FontFieldEditor(TraceConstants.CONSOLE_FONT, UIPlugin.getResourceString(FONT), getFieldEditorParent());
		addField(sysout);
		addField(syserr);
		addField(sysin);
		addField(font);
		
	}
	/**
	 * Returns the font data that describes the font to use for the console
	 */
	public static FontData getConsoleFontData() {
		IPreferenceStore pstore=UIPlugin.getDefault().getPreferenceStore(); 
		FontData fontData= PreferenceConverter.getFontData(pstore, TraceConstants.CONSOLE_FONT);
		return fontData;
	}
	/**
	 * Returns the a color based on the type.
	 */
	public static Color getPreferenceColor(String type) {
		IPreferenceStore pstore= UIPlugin.getDefault().getPreferenceStore();
		RGB outRGB= PreferenceConverter.getColor(pstore, type);
		ColorManager colorManager= UIPlugin.getDefault().getColorManager();
		return colorManager.getColor(outRGB);
	}
	/**
	 * @see IWorkbenchPreferencePage#init
	 */
	public void init(IWorkbench workbench) {
	}
}
