/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Vector;
import java.util.Collections;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

public class CList
{
  protected Label _label;
  protected List _list;  
  protected Button     _order;
  protected Composite groupWidget;
  private ArrayList listeners = new ArrayList();

  public CList(Composite parent, String text)
  {
	this(parent, text, (java.util.List) null );
  }  
  public CList(Composite parent, String text, java.util.List items)
  {
	// Create the grid.
	groupWidget = new Composite (parent, SWT.NULL);

	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	groupWidget.setLayout(layout);  
	groupWidget.setLayoutData(GridUtil.createFill());

	if(text != null && !text.equals(""))
	{
		_label = new Label(groupWidget, SWT.NULL);
		_label.setText(text);
	}
	
	_list = new List (groupWidget, SWT.MULTI|SWT.BORDER| SWT.H_SCROLL | SWT.V_SCROLL);  
	_list.setLayoutData(GridUtil.createFill());
	
	_order = new Button(groupWidget, SWT.PUSH);
	_order.setText(UIPlugin.getResourceString("SORT_BUTTON"));

	if ( items != null )
	{
	  for(int i =0; i<items.size();i++ )
		_list.add(items.get(i).toString(), i);
	}
	
	_order.addSelectionListener(new SelectionListener()
	{
	  public void widgetSelected(SelectionEvent e)
	  {
		sortList();
		CList.this.fireSelectionNotification(e);
		
	  }
	  
	  public void widgetDefaultSelected(SelectionEvent e)
	  {
	  }      
	  
	}
	);
  }  
  public void add(Object item)
  {
  //  System.out.println("CList.add "+ item);
	 _list.add(item.toString());

  }  
  public void add(Object item, int position)
  {
  //  System.out.println("CList.add "+ item+ "at position "+position);
	 _list.add(item.toString(), position);

  }  
  public  void clearSelection() {
	_list.deselectAll();
  }  
  public boolean contains(Object item)
  {
	 return (_list.indexOf(item.toString()) != -1);
  }  
  public void deselect(int index)
  {
	 _list.deselect(index);
  }  
  public void disableCList() {
	   _order.setEnabled(false);
  }  
/**
 * Insert the method's description here.
 * Creation date: (10/31/2000 3:12:14 PM)
 * @param enable boolean
 */
public void enable(boolean enable)
{
	_list.setEnabled(enable);
	_order.setEnabled(enable);

	if(_label != null)
		_label.setEnabled(enable);      
}
  public Object getItem(int position)
  {
//    System.out.println("CList.getItem:"+ position);
	return _list.getItem(position);
  }  
/**
 * Insert the method's description here.
 * Creation date: (11/07/2000 11:16:50 AM)
 * @return int
 */
public int getItemCount() {
	return _list.getItemCount();
}
  public List getList() {
	  return _list;
  }  
  public int getSelectedIndex() {

   return _list.getSelectionIndex();
  }  
  public int[] getSelectedIndices() {

   return _list.getSelectionIndices();
  }  
  public  Object getSelectedItem()
  {
	String[] sel = _list.getSelection();

	if(sel.length > 0)      
		return sel[0];

	return null;    
  }  
  public String[] getSelectedItems()
  {
	  return _list.getSelection();
  }  
  public Composite getWidget()
  {
	  return groupWidget;
  }  
  public boolean isSelectedIndex(int index) {

   return _list.isSelected(index);
  }  
  /**
  *
  */
  public void refreshList(Vector list)
  {  
	_list.removeAll();    
	for(int idx=0; idx< list.size(); idx++)
	  add(list.elementAt(idx));
  }  
  public void remove(int index)
  {
	 _list.remove(index);
  }  
  public void remove(Object item)
  {

   // System.out.println("CList.remove "+ item);
	 _list.remove(item.toString());

  }  
  public void select(Object item)
  {
	  int index = _list.indexOf(item.toString());
	  if(index != -1)
		_list.select(index);      
  }  
  public void selectAll(int[] indexlist)
  {
 //  System.out.println("CList.selectAll");
	 _list.select(indexlist);

  }  
   public void setFocus()
   {
	   _list.setFocus();
   }   
  public void setSelectedIndex(int index) {

	_list.setSelection(index);
  }  
 public void setSelectionInterval(int anchor, int lead) {
	_list.setSelection(anchor,lead);
  }  
   public void setToolTipText(String text)
   {
//     _toolTip.setText(text);
   }   
  public void setVisible(boolean b)
  {
	groupWidget.setVisible(b);    
  }  
  public synchronized void sortList()
  {   
  	
	String[] items = _list.getItems();	//the items in the receiver
		String[] selected = _list.getSelection();	//the selected items in the receiver
	

		//don't bother to sort if there is none or one element
		if(items.length < 2) return;

		//copies the elements to a vector
		Vector v = new Vector(items.length);	
		for(int idx=0; idx< items.length; idx++)
		  v.addElement(items[idx]);
	  
		//sorts the vector
		Collections.sort(v);		
	
		//refreshes the list to make it sorted
		refreshList(v);

		//gets the new indices of the items selected
		Vector indexList = new Vector();
		for(int idx=0; idx<_list.getItemCount(); idx++)
		{
		  boolean contains = false;
		  int i=0;
		  while(!contains && i<selected.length)
		  {
			if(selected[i].equals(getItem(idx)))
			{
			  contains = true;
			  indexList.addElement(String.valueOf(idx));          
			}
			else i++;
		  }
		}
	
		//sets the selection to the new indices
		int[] idxList = new int[indexList.size()];
		for(int i=0; i<indexList.size(); i++)
		  idxList[i] = Integer.parseInt(indexList.elementAt(i).toString());
	  
		 _list.setSelection(idxList);

	
  }
  
  public void addSelectionListener(SelectionListener listener){
	
	if(!listeners.contains(listener)){
		listeners.add(listener);
		_list.addSelectionListener(listener);
	}  
  }
  
  public void removeSelectionListener(SelectionListener listener){
	listeners.remove(listener);
	_list.removeSelectionListener(listener);
  }
  
  public void fireSelectionNotification(SelectionEvent e){

	for (int i = 0; i < listeners.size(); i++) {
		((SelectionListener)listeners.get(i)).widgetSelected(e);
	}
  	
  }
    
}
