/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.configuration.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ContextInstanceTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
		
	public final static String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_DESCR");
	public final static String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_ID");
	public final static String MAXIMUM_IDLE = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_TIME");
	public final static String PAUSE_INTERVAL = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_PAUSEI");
	public final static String CONTINUOUS_OP = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_CONT");

	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextInstanceTypeItemProvider(AdapterFactory adapterFactory)
	{
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object)
	{
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addContinuousOperationPropertyDescriptor(object);
			addDescriptionPropertyDescriptor(object);
			addMaximumIdleTimePropertyDescriptor(object);
			addPauseIntervalPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Continuous Operation feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addContinuousOperationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_CONT"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_CONT", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_ContinuousOperation(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_DESCR", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Maximum Idle Time feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addMaximumIdleTimePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_TIME"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_TIME", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_MaximumIdleTime(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Pause Interval feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addPauseIntervalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_PAUSEI"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_PAUSEI", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_PauseInterval(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUniqueIDPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_ID", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object)
	{
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Parser());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter());
		}
		return childrenReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EReference getChildReference(Object object, Object child)
	{
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildReference(object, child);
	}


	/**
	 * This returns ContextInstanceType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		
		if(object instanceof SensorConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_SENSOR);
		else if(object instanceof ExtractorType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_EXTRACTOR);	   
		else if(object instanceof FormatterType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_FORMATTER);
		else if(object instanceof ProcessUnitType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PROCESS_UNIT);
		else if(object instanceof OutputterConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_OUTPUTTER);
		else if(object instanceof ParserConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PARSER);
		   		   
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_CONTEXT_INSTANCE);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object)
	{
		ContextInstanceType contextInstanceType = (ContextInstanceType)object;
		
		String label = contextInstanceType.getUniqueID();
		return label == null || label.length() == 0 ?
			"Context Instance" :
			"Context Instance [" + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification)
	{
		switch (notification.getFeatureID(ContextInstanceType.class)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object)
	{
		super.collectNewChildDescriptors(newChildDescriptors, object);

		SensorConfigType sensor = SensorFactory.eINSTANCE.createSensorConfigType();
		PropertyType property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("directory");
		sensor.getProperty().add(property);
		property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("fileName");
		sensor.getProperty().add(property);
		sensor.setDescription("A single file sensor");
		sensor.setMaximumBlocking("5");
		sensor.setType(SensorType.SINGLE_FILE_SENSOR_LITERAL);
		
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor(),
				 sensor));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor(),
				 ExtractorFactory.eINSTANCE.createExtractorType()));

//		newChildDescriptors.add
//			(createChildParameter
//				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor(),
//				 ExtractorFactory.eINSTANCE.createExtractor()));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Parser(),
				 ParserFactory.eINSTANCE.createParserConfigType()));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit(),
				 UnitFactory.eINSTANCE.createProcessUnitType()));

//		newChildDescriptors.add
//			(createChildParameter
//				(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit(),
//				 UnitFactory.eINSTANCE.createProcessUnit()));
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit(),
//				 SensorFactory.eINSTANCE.createSensorConfigType()));
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit(),
//				 OutputterFactory.eINSTANCE.createOutputterConfigType()));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter(),
				 FormatterFactory.eINSTANCE.createFormatterType()));

//		newChildDescriptors.add
//			(createChildParameter
//				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter(),
//				 FormatterFactory.eINSTANCE.createFormatter()));

		OutputterConfigType outputterConfigType = OutputterFactory.eINSTANCE.createOutputterConfigType();
		property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("agentName");
		property.setPropertyValue("Default Logging Agent");
		outputterConfigType.getProperty().add(property);
		outputterConfigType.setDescription("Logging Agent Outputter");
		outputterConfigType.setType(OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL);

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter(),
				 outputterConfigType));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getCreateChildText(Object owner, Object feature, Object child, Collection selection)
	{
		boolean qualify = false;
//			feature == ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor() ||
//			feature == ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit() ||
//			feature == ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter();
		return getString(
			qualify ? "_UI_CreateChild_text2" : "_UI_CreateChild_text",
			new Object[] { getTypeText(child), getFeatureText(feature), getTypeText(owner) });
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator()
	{
		return AcadEditorPlugin.INSTANCE;
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
}
