/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.provider;


import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttribute;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElement;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;
import org.eclipse.xsd.XSDElementDeclaration;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ParserConfigTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public final static String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESCR");
	public final static String SEPARATOR = AcadEditorPlugin.getPlugin().getString("STR_PARSER_SEPTOKEN");
	public final static String DESIGNATION = AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESTOKEN");
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParserConfigTypeItemProvider(AdapterFactory adapterFactory)
	{
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object)
	{
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDescriptionPropertyDescriptor(object);
			addDesignationTokenPropertyDescriptor(object);
			addSeparatorTokenPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addDescriptionPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_PARSER_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_PARSER_DESCR", "_UI_ParserConfigType_type"),
				 ParserPackage.eINSTANCE.getParserConfigType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Designation Token feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addDesignationTokenPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_PARSER_DESTOKEN"),
				 getString("_UI_PropertyDescriptor_description", "STR_PARSER_DESTOKEN", "_UI_ParserConfigType_type"),
				 ParserPackage.eINSTANCE.getParserConfigType_DesignationToken(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Separator Token feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addSeparatorTokenPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_PARSER_SEPTOKEN"),
				 getString("_UI_PropertyDescriptor_description", "STR_PARSER_SEPTOKEN", "_UI_ParserConfigType_type"),
				 ParserPackage.eINSTANCE.getParserConfigType_SeparatorToken(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUniqueIDPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_PARSER_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_PARSER_ID", "_UI_ParserConfigType_type"),
				 ParserPackage.eINSTANCE.getParserConfigType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object)
	{
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ParserPackage.eINSTANCE.getParserConfigType_RuleElement());
		}
		return childrenReferences;
	}


	/**
	 * This returns ParserConfigType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		if(object instanceof RuleElement)
		{
			if(AcadEditorPlugin.INSTANCE.getCBEElements().get(((RuleElement)object).getName()) == null)
				return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_NESTING);					
			else
				return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ELEMENT);			
		}
		else if(object instanceof RuleAttribute)	
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ATTRIBUTE);
		
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PARSER);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		String label = ((ParserConfigType)object).getUniqueID();
		return label == null || label.length() == 0 ?
			getString("_UI_ParserConfigType_type") :
			getString("_UI_ParserConfigType_type") + " [" + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification)
	{
		switch (notification.getFeatureID(ParserConfigType.class)) {
			case ParserPackage.PARSER_CONFIG_TYPE__DESCRIPTION:
			case ParserPackage.PARSER_CONFIG_TYPE__DESIGNATION_TOKEN:
			case ParserPackage.PARSER_CONFIG_TYPE__SEPARATOR_TOKEN:
			case ParserPackage.PARSER_CONFIG_TYPE__UNIQUE_ID:
			case ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		Iterator elems = AcadEditorPlugin.INSTANCE.getCBEElements().values().iterator();
		while(elems.hasNext())
		{
			XSDElementDeclaration elemDecl = (XSDElementDeclaration)elems.next();
		    
			if(elemDecl.getName().equals(AcadEditorPlugin.cbeName))
			{
				RuleElement element = ParserFactory.eINSTANCE.createRuleElement();		
				element.setName(elemDecl.getName());
				newChildDescriptors.add
					(createChildParameter
						(ParserPackage.eINSTANCE.getParserConfigType_RuleElement(),
						 element));
						 
				AcadEditorPlugin.INSTANCE.createRequiredAttributes(element, elemDecl.getType());		 

			}			
		}
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator()
	{
		return AcadEditorPlugin.INSTANCE;
	}
}
