/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SubstitutionRuleTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public final static String POSITIONS = AcadEditorPlugin.getPlugin().getString("STR_SUBST_POS");
	public final static String MATCH = AcadEditorPlugin.getPlugin().getString("STR_SUBST_MATCH");
	public final static String SUBSTITUTE = AcadEditorPlugin.getPlugin().getString("STR_SUBST_SUBST");
	public static final Object SUBSTITUTION_EXTENSION_CLASS = AcadEditorPlugin.getPlugin().getString("STR_SubstitutionExtensionClass");
	public static final Object TIME_FORMAT = AcadEditorPlugin.getPlugin().getString("STR_TimeFormat");
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SubstitutionRuleTypeItemProvider(AdapterFactory adapterFactory)
	{
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object)
	{
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addMatchPropertyDescriptor(object);
			addPositionsPropertyDescriptor(object);
			addSubstitutePropertyDescriptor(object);
			addSubstitutionExtensionClassPropertyDescriptor(object);
			addTimeFormatPropertyDescriptor(object);
			addUseBuiltInFunctionPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Match feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addMatchPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_SUBST_MATCH"),
				 getString("_UI_PropertyDescriptor_description", "STR_SUBST_MATCH", "_UI_SubstitutionRuleType_type"),
				 ParserPackage.eINSTANCE.getSubstitutionRuleType_Match(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Positions feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addPositionsPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_SUBST_POS"),
				 getString("_UI_PropertyDescriptor_description", "STR_SUBST_POS", "_UI_SubstitutionRuleType_type"),
				 ParserPackage.eINSTANCE.getSubstitutionRuleType_Positions(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Substitute feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addSubstitutePropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_SUBST_SUBST"),
				 getString("_UI_PropertyDescriptor_description", "STR_SUBST_SUBST", "_UI_SubstitutionRuleType_type"),
				 ParserPackage.eINSTANCE.getSubstitutionRuleType_Substitute(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Substitution Extension Class feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSubstitutionExtensionClassPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_SubstitutionRuleType_substitutionExtensionClass_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SubstitutionRuleType_substitutionExtensionClass_feature", "_UI_SubstitutionRuleType_type"),
				 ParserPackage.eINSTANCE.getSubstitutionRuleType_SubstitutionExtensionClass(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Time Format feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTimeFormatPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_SubstitutionRuleType_timeFormat_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SubstitutionRuleType_timeFormat_feature", "_UI_SubstitutionRuleType_type"),
				 ParserPackage.eINSTANCE.getSubstitutionRuleType_TimeFormat(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Use Built In Function feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUseBuiltInFunctionPropertyDescriptor(Object object)
	{
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_SUBST_USE_BUILT_FCT"),
				 getString("_UI_PropertyDescriptor_description", "_SUBST_USE_BUILT_FCT", "_UI_SubstitutionRuleType_type"),
				 ParserPackage.eINSTANCE.getSubstitutionRuleType_UseBuiltInFunction(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}


	/**
	 * This returns SubstitutionRuleType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_RULE);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		String label = ((SubstitutionRuleType)object).getSubstitute();
		return label == null || label.length() == 0 ?
			getString("_UI_SubstitutionRuleType_type") :
			getString("_UI_SubstitutionRuleType_type") + " " + label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification)
	{
		switch (notification.getFeatureID(SubstitutionRuleType.class)) {
			case ParserPackage.SUBSTITUTION_RULE_TYPE__MATCH:
			case ParserPackage.SUBSTITUTION_RULE_TYPE__POSITIONS:
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTE:
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTION_EXTENSION_CLASS:
			case ParserPackage.SUBSTITUTION_RULE_TYPE__TIME_FORMAT:
			case ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object)
	{
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator()
	{
		return AcadEditorPlugin.INSTANCE;
	}
}
