/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AcadEditorPluginImages
{
  private static URL fgIconBaseURL= null;

	static {
		String pathSuffix= "icons/full/"; //$NON-NLS-1$
		try {
			URL installURL = AcadEditorPlugin.getPlugin().getBaseURL();
			fgIconBaseURL = new URL(installURL, pathSuffix);
		} catch (MalformedURLException e) {
		}
	}  
	
	/*
	 * Set of predefined Image Descriptors.
	 * there following String are all $NON-NLS-1$
	 */
	public static final String T_LCL	= "lcl16"; //$NON-NLS-1$
	public static final String T_TOOL	= "tool16"; //$NON-NLS-1$
	public static final String T_VIEW	= "view16"; //$NON-NLS-1$
	public static final String T_OBJ	= "obj16"; //$NON-NLS-1$
	public static final String T_WIZBAN	= "wizban"; //$NON-NLS-1$
	
	
  // there following String are all $NON-NLS-1$
  public static final String IMG_UI_CREATE_RULE    		= "create_rule_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_FIRST_EVENT    		= "first_event_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_GUESS_RULE    		= "guess_rule_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_LAST_EVENT    		= "last_event_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_NEXT_EVET    		= "next_event_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_PREVIOUS_EVENT 		= "previous_event_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_REAPPLY 	   		= "reapply_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_RUN_PARSER    		= "run_parser_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_SHOW_LOG    		= "show_log_exec.gif";//$NON-NLS-1$
  public static final String IMG_UI_SETSTART 	   		= "runtoline.gif";//$NON-NLS-1$  

  public static final String IMG_UI_ADAPTOR	    		= "adaptor_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_ATTRIBUTE    		= "attribute_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_COMPONENT    		= "component_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_CONFIGURATION  		= "configuration_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_CONTEXTS    		= "contexts_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_CONTEXT_INSTANCE	= "context_instance_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_CONTEXT	    		= "context_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_ELEMENT	    		= "element_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_EXTRACTOR    		= "extractor_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_FORMATTER    		= "formatter_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_NESTING	    		= "nesting_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_OUTPUTTER    		= "outputter_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_PARSER		   		= "parser_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_PROCESS_UNIT   		= "process_unit_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_SENSOR	    		= "sensor_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_STREAM	    		= "stream_obj.gif";//$NON-NLS-1$
  public static final String IMG_UI_RULE	    		= "rule_obj.gif";//$NON-NLS-1$

  public static final String IMG_DB_EDITOR_BAN = "page_banner.gif";//$NON-NLS-1$
  public static final ImageDescriptor DESC_IMG_DB_EDITOR_BAN = createManaged(T_WIZBAN,IMG_DB_EDITOR_BAN);//$NON-NLS-1$   


  /*
   * Available cached Images.
   */		
  public static final ImageDescriptor DESC_IMG_UI_ADAPTOR   		= createManaged(T_OBJ,IMG_UI_ADAPTOR);
  public static final ImageDescriptor DESC_IMG_UI_ATTRIBUTE   		= createManaged(T_OBJ,IMG_UI_ATTRIBUTE);
  public static final ImageDescriptor DESC_IMG_UI_COMPONENT   		= createManaged(T_OBJ,IMG_UI_COMPONENT);
  public static final ImageDescriptor DESC_IMG_UI_CONFIGURATION		= createManaged(T_OBJ,IMG_UI_CONFIGURATION);
  public static final ImageDescriptor DESC_IMG_UI_CONTEXTS   		= createManaged(T_OBJ,IMG_UI_CONTEXTS);
  public static final ImageDescriptor DESC_IMG_UI_CONTEXT_INSTANCE  = createManaged(T_OBJ,IMG_UI_CONTEXT_INSTANCE);
  public static final ImageDescriptor DESC_IMG_UI_CONTEXT   		= createManaged(T_OBJ,IMG_UI_CONTEXT);
  public static final ImageDescriptor DESC_IMG_UI_ELEMENT   		= createManaged(T_OBJ,IMG_UI_ELEMENT);
  public static final ImageDescriptor DESC_IMG_UI_EXTRACTOR   		= createManaged(T_OBJ,IMG_UI_EXTRACTOR);
  public static final ImageDescriptor DESC_IMG_UI_FORMATTER   		= createManaged(T_OBJ,IMG_UI_FORMATTER);
  public static final ImageDescriptor DESC_IMG_UI_NESTING   		= createManaged(T_OBJ,IMG_UI_NESTING);
  public static final ImageDescriptor DESC_IMG_UI_OUTPUTTER   		= createManaged(T_OBJ,IMG_UI_OUTPUTTER);
  public static final ImageDescriptor DESC_IMG_UI_PARSER   			= createManaged(T_OBJ,IMG_UI_PARSER);
  public static final ImageDescriptor DESC_IMG_UI_PROCESS_UNIT   	= createManaged(T_OBJ,IMG_UI_PROCESS_UNIT);
  public static final ImageDescriptor DESC_IMG_UI_SENSOR   			= createManaged(T_OBJ,IMG_UI_SENSOR);
  public static final ImageDescriptor DESC_IMG_UI_STREAM   			= createManaged(T_OBJ,IMG_UI_STREAM);
  public static final ImageDescriptor DESC_IMG_UI_RULE   			= createManaged(T_OBJ,IMG_UI_RULE);
     
  protected static Hashtable _images;
  protected static Hashtable _imageDescriptors; 

public static Image getImage(String name)
{
	return (Image)_images.get(name);
}

public static ImageDescriptor getImageDescriptor(String name)
{
	return (ImageDescriptor) _imageDescriptors.get(name);
}

private static ImageDescriptor createManaged(String prefix, String name) {
	try {
		ImageDescriptor result= ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
	
		if(_images == null || _imageDescriptors == null)
		{
			_images = new Hashtable();
			_imageDescriptors = new Hashtable();		
		}
			
		_imageDescriptors.put(name, result);
	    _images.put(name, result.createImage());
		return result;
			
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor();
	}
}

public static void setImageDescriptors(IAction action, String type, String relPath) {
	try {
		ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath)); //$NON-NLS-1$
		if (id != null)
		{
			action.setDisabledImageDescriptor(id);
		}
	} catch (MalformedURLException e) {}
	
	try {
		ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath)); //$NON-NLS-1$
		if (id != null)
		{	
			action.setHoverImageDescriptor(id);
		}
	} catch (MalformedURLException e) {}
	
	action.setImageDescriptor(create("e" + type, relPath)); //$NON-NLS-1$
}

private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
	if (fgIconBaseURL == null)
		throw new MalformedURLException();

	StringBuffer buffer;
    if (prefix!=null) 
    {
		buffer= new StringBuffer(prefix);
		buffer.append('/');
		buffer.append(name);
    }
    else 
    {
    	buffer= new StringBuffer(name);
    }
	return new URL(fgIconBaseURL, buffer.toString());
}

private static ImageDescriptor create(String prefix, String name) {
	try {
		return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
	} catch (MalformedURLException e) {
		return ImageDescriptor.getMissingImageDescriptor();
	}
}

public static void shutdown()
{
	if(_images == null)
	  return;
	
	for (Iterator e = _images.values().iterator(); e.hasNext();) {
		Object next = e.next();
		if (next instanceof Image && !((Image)next).isDisposed())
		{
			((Image)next).dispose();
		}
	}

	_images.clear();
	_images = null;
	_imageDescriptors.clear();
	_imageDescriptors = null;
}

}
