/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;


import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.logging.adapter.extractors.RegularExpressionExtractor;
import org.eclipse.hyades.logging.adapter.formatters.CBEFormatter;
import org.eclipse.hyades.logging.adapter.impl.BasicContext;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.Configuration;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.Context;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextsType;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.Formatter;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttribute;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElement;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.outputters.CBELogOutputter;
import org.eclipse.hyades.logging.adapter.parsers.Parser;
import org.eclipse.hyades.logging.adapter.sensors.SingleOSFileSensor;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;


/**
 * This is a simple wizard for creating a new model file.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AdaptorModelWizard extends Wizard implements INewWizard {
	
	private ConfigLogTemplatePage logPage;
	
	/**
	 * This caches an instance of the model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdapterPackage adaptorPackage = AdapterPackage.eINSTANCE;

	/**
	 * This caches an instance of the model factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdapterFactory adaptorFactory = adaptorPackage.getAdapterFactory();

	/**
	 * This is the file creation page.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdaptorModelWizardNewFileCreationPage newFileCreationPage;

	/**
	 * Remember the selection during initialization for populating the default container.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStructuredSelection selection;

	/**
	 * Remember the workbench during initialization.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IWorkbench workbench;

	/**
	 * This just records the information.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;
		setWindowTitle(AcadEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
		setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(AcadEditorPlugin.INSTANCE.getImage("full/wizban/NewAdaptor")));
	}

	/**
	 * Create a new model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EObject createInitialModel(String templateFile) {
		Adapter adaptor = adaptorFactory.createAdapter();
		
		ContextsType ctype = ContextFactory.eINSTANCE.createContexts();
		adaptor.setContexts(ctype);
		
		//create default configuration
		Configuration config = ConfigurationFactory.eINSTANCE.createConfiguration();
		config.setDescription("The component level configurations for this Adaptor");
		adaptor.setConfiguration(config);
				
		//create context instance
		ContextInstanceType context = ConfigurationFactory.eINSTANCE.createContextInstanceType();
		context.setContinuousOperation(true);
		context.setMaximumIdleTime("20000");
		context.setPauseInterval("10");
		context.setDescription("Context Instance for the current component");
		config.getContextInstance().add(context);
		
		Context mcontext = createContext(context);
		ctype.getContext().add(mcontext);
		
		IPath path = new Path(templateFile);
		
		//create single file sensor type
		SensorConfigType sensor = SensorFactory.eINSTANCE.createSensorConfigType();
		PropertyType property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("directory");
		property.setPropertyValue(path.removeLastSegments(1).toOSString());
		sensor.getProperty().add(property);
		property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("fileName");
		property.setPropertyValue(path.lastSegment());
		sensor.getProperty().add(property);

		sensor.setDescription("A single file sensor");
		sensor.setMaximumBlocking("5");
		context.setSensor(sensor);
		sensor.setType(SensorType.SINGLE_FILE_SENSOR_LITERAL);
		
		mcontext.getComponent().add(createComponentFileSensor(sensor));
		
		//create extractor 
		ExtractorType extractor = ExtractorFactory.eINSTANCE.createExtractor();
		extractor.setDescription("This extractor uses regular expression  patterns to identify record delimiters");
		extractor.setContainsLineBreaks(true);
		extractor.setIncludeEndPattern(true);
		extractor.setIncludeStartPattern(true);
		extractor.setReplaceLineBreaks(true);
		extractor.setReplaceLineBreaks(false);
		extractor.setStartPattern("^");
		extractor.setEndPattern("$");
		context.setExtractor(extractor);
		
		mcontext.getComponent().add(createComponentExtractor(extractor));
		
		//create parser
		ParserConfigType parser = ParserFactory.eINSTANCE.createParserConfigType();
		//create element
		RuleElement element = ParserFactory.eINSTANCE.createRuleElement();
		element.setName(AcadEditorPlugin.cbeName);
		parser.getRuleElement().add(element);				
		context.setParser(parser);
		//create one attribute
		Object cbeObject = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(element);
		if(cbeObject != null && cbeObject instanceof XSDElementDeclaration)
		{
			XSDElementDeclaration elem = (XSDElementDeclaration)cbeObject;
		
			XSDTypeDefinition type = elem.getTypeDefinition();
				
			if(type instanceof XSDComplexTypeDefinition)
			{
				XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
				
				EList attrs = complexType.getAttributeUses();
				for(int idx=0; idx<attrs.size(); idx++)
				{
					XSDAttributeUse attr = (XSDAttributeUse) attrs.get(idx);
					
					if(!attr.isRequired())
					  continue;
					
					RuleAttribute ruleAtribute = ParserFactory.eINSTANCE.createRuleAttribute();
					ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
					ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
					ruleAtribute.setName(attr.getAttributeDeclaration().getName());
					
					element.getRuleAttribute().add(ruleAtribute);
					
					//add substitution rule
					SubstitutionRuleType subs = ParserFactory.eINSTANCE.createSubstitutionRuleType();
					subs.setMatch("^(.*)");
					subs.setSubstitute("replace with our message text");
					subs.setUseBuiltInFunction(true);
					subs.setUseBuiltInFunction(false);
					ruleAtribute.getSubstitutionRule().add(subs);
					
				}
			}
			
		}
		
		mcontext.getComponent().add(createComponentParser(parser));
		
		//create formatter
		Formatter formatter = FormatterFactory.eINSTANCE.createFormatter();
		formatter.setDescription("CBE Formatter");
		context.getFormatter().add(formatter);
		
		mcontext.getComponent().add(createComponentFormatter(formatter));
		
		//create outputter
		OutputterConfigType outputter = OutputterFactory.eINSTANCE.createOutputterConfigType();
		property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("agentName");
		property.setPropertyValue("Default Logging Agent");

		outputter.getProperty().add(property);
		
		outputter.setDescription("Logging Agent Outputter");
		outputter.setType(OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL);

		context.getOutputter().add(outputter);
		
		mcontext.getComponent().add(createComponentOutputter(outputter));		
				
		return adaptor;
	}
	
	/**
	 * 
	 * @param context
	 * @return
	 */
	protected Context createContext(ContextInstanceType context)
	{
		String date = (new Date()).toString();
		Context mcontext = ContextFactory.eINSTANCE.createContext();
		mcontext.setDescription(context.getDescription());
		mcontext.setUniqueID(context.getUniqueID());
		mcontext.setExecutableClass(BasicContext.class.getName());
		mcontext.setImplementationCreationDate(date);
		mcontext.setLoggingLevel("60");
		mcontext.setRole(RoleNames.CONTEXT_LITERAL);
		mcontext.setRoleCreationDate(date);
		mcontext.setName("Basic Context Implementation");
				
		return mcontext;
	}

	/**
	 * 
	 * @param context
	 * @return
	 */
	protected Component createComponentFormatter(FormatterType formatter)
	{
		String date = (new Date()).toString();
		Component mcontext = ContextFactory.eINSTANCE.createComponent();
		mcontext.setDescription(formatter.getDescription());
		mcontext.setUniqueID(formatter.getUniqueID());
		mcontext.setExecutableClass(CBEFormatter.class.getName());
		mcontext.setImplementationCreationDate(date);
		mcontext.setLoggingLevel("99");
		mcontext.setRole(RoleNames.FORMATTER_LITERAL);
		mcontext.setRoleCreationDate(date);
		mcontext.setName(mcontext.getDescription());
				
		return mcontext;
	}
	
	
	/**
	 * 
	 * @param context
	 * @return
	 */
	protected Component createComponentFileSensor(SensorConfigType sensor)
	{
		String date = (new Date()).toString();
		Component mcontext = ContextFactory.eINSTANCE.createComponent();
		mcontext.setUniqueID(sensor.getUniqueID());
		mcontext.setExecutableClass(SingleOSFileSensor.class.getName());
		mcontext.setImplementationCreationDate(date);
		mcontext.setLoggingLevel("0");
		mcontext.setRole(RoleNames.CONTEXT_LITERAL);
		mcontext.setRole(RoleNames.SENSOR_LITERAL);		
		mcontext.setRoleCreationDate(date);
		mcontext.setName("OS File Sensor");
		mcontext.setDescription("Operating System file sensor");
				
		return mcontext;
	}
	
	/**
	 * 
	 * @param context
	 * @return
	 */
	protected Component createComponentExtractor(ExtractorType extractor)
	{
		String date = (new Date()).toString();
		Component mcontext = ContextFactory.eINSTANCE.createComponent();
		mcontext.setDescription(extractor.getDescription());
		mcontext.setUniqueID(extractor.getUniqueID());
		mcontext.setExecutableClass(RegularExpressionExtractor.class.getName());
		mcontext.setImplementationCreationDate(date);
		mcontext.setLoggingLevel("99");
		mcontext.setRole(RoleNames.MESSAGE_EXTRACTOR_LITERAL);
		mcontext.setRoleCreationDate(date);
		mcontext.setName("Regular Expression Extractor");
				
		return mcontext;
	}
	
	/**
	 * 
	 * @param context
	 * @return
	 */
	protected Component createComponentOutputter(OutputterConfigType outputter)
	{
		String date = (new Date()).toString();
		Component mcontext = ContextFactory.eINSTANCE.createComponent();
		mcontext.setDescription(outputter.getDescription());
		mcontext.setUniqueID(outputter.getUniqueID());
		mcontext.setExecutableClass(CBELogOutputter.class.getName());
		mcontext.setImplementationCreationDate(date);
		mcontext.setLoggingLevel("99");
		mcontext.setRole(RoleNames.OUTPUTTER_LITERAL);
		mcontext.setRoleCreationDate(date);
		mcontext.setName("Hyades Logging Agent Outputter");
				
		return mcontext;
	}
	
	/**
	 * 
	 * @param context
	 * @return
	 */
	protected Component createComponentParser(ParserConfigType parser)
	{
		String date = (new Date()).toString();
		Component mcontext = ContextFactory.eINSTANCE.createComponent();
		mcontext.setDescription("Regular expression parser");
		mcontext.setUniqueID(parser.getUniqueID());
		mcontext.setExecutableClass(Parser.class.getName());
		mcontext.setImplementationCreationDate(date);
		mcontext.setLoggingLevel("99");
		mcontext.setRole(RoleNames.PARSER_LITERAL);
		mcontext.setRoleCreationDate(date);
		mcontext.setName("Generic Parser");
				
		return mcontext;
	}

	/**
	 * Do the work after everything is specified.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean performFinish() {
		try {
			// Remember the file.
			//
			final IFile modelFile = getModelFile();
			logPage.performFinish();
			final String templateFile = logPage.getTemplateLogName();

			// Do the work within an operation.
			//
			WorkspaceModifyOperation operation =
				new WorkspaceModifyOperation() {
					protected void execute(IProgressMonitor progressMonitor) {
						try {
							// Create a resource set
							//
							ResourceSet resourceSet = new ResourceSetImpl();

							// Get the URI of the model file.
							//
							URI fileURI = URI.createPlatformResourceURI(modelFile.getFullPath().toString());

							// Create a resource for this file.
							//
							Resource resource = resourceSet.createResource(fileURI);

							// Add the initial model object to the contents.
							//
							EObject rootObject = createInitialModel(templateFile);
							if (rootObject != null) {
								resource.getContents().add(rootObject);
							}

							// Save the contents of the resource to the file system.
							//
							Map options = new HashMap();
							options.put(XMLResource.OPTION_ENCODING, newFileCreationPage.getEncoding());

							try {
								MigrationUtil.migrateSave((Adapter)resource.getContents().get(0));
							} catch (Exception e) {
								// ignore when is null or not Adapter
							}
							
							resource.save(options);
						}
						catch (Exception exception) {
							AcadEditorPlugin.INSTANCE.log(exception);
						}
						finally {
							progressMonitor.done();
						}
					}
				};

			getContainer().run(false, false, operation);

			// Select the new file resource in the current view.
			//
			IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
			IWorkbenchPage page = workbenchWindow.getActivePage();
			final IWorkbenchPart activePart = page.getActivePart();
			if (activePart instanceof ISetSelectionTarget) {
				final ISelection targetSelection = new StructuredSelection(modelFile);
				getShell().getDisplay().asyncExec
					(new Runnable() {
						 public void run() {
							 ((ISetSelectionTarget)activePart).selectReveal(targetSelection);
						 }
					 });
			}

			// Open an editor on the new file.
			//
			try {
				page.openEditor(modelFile);
			}
			catch (PartInitException exception) {
				MessageDialog.openError(workbenchWindow.getShell(), AcadEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), exception.getMessage());
				return false;
			}

			return true;
		}
		catch (Exception exception) {
			exception.printStackTrace();
			AcadEditorPlugin.INSTANCE.log(exception);
			return false;
		}
	}

	/**
	 * This is the one page of the wizard.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public class AdaptorModelWizardNewFileCreationPage extends WizardNewFileCreationPage {
		/**
		 * Remember the model file.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected IFile modelFile;
		
		/**
		 * @generated
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 */
		protected String encoding;

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected CCombo encodingField;
		

		/**
		 * Pass in the selection.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public AdaptorModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
			super(pageId, selection);
		}
		
		protected void createAdvancedControls(Composite parent) {
			
			super.createAdvancedControls(parent);
			
			Composite encoding = new Composite(parent,SWT.NULL);
			GridLayout layout = new GridLayout();
			layout.numColumns = 2;
			encoding.setLayout(layout);
			GridData gd= new GridData();
			gd.horizontalAlignment= GridData.FILL;
			gd.grabExcessHorizontalSpace= true;
			encoding.setLayoutData(gd);			
			
			Label encodingLabel = new Label(encoding, SWT.LEFT); {
				encodingLabel.setText(AcadEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
		
				GridData data = new GridData();
				data.horizontalAlignment = GridData.FILL;
				encodingLabel.setLayoutData(data);
			}
			encodingField = new CCombo(encoding, SWT.BORDER); {
				GridData data = new GridData();
				data.horizontalAlignment = GridData.FILL;
				data.grabExcessHorizontalSpace = true;
				encodingField.setLayoutData(data);
			}
		
			for (StringTokenizer stringTokenizer = new StringTokenizer(AcadEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices")); stringTokenizer.hasMoreTokens(); ) {
				encodingField.add(stringTokenizer.nextToken());
			}
			encodingField.select(0);
			
		}

		public String getEncoding() {
			return
				encoding == null ?
					encodingField.getText() :
					encoding;
		}
		

		/**
		 * The framework calls this to see if the file is correct.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected boolean validatePage() {
			if (super.validatePage()) {
				// Make sure the file ends in ".adaptor".
				//
				String requiredExt = AcadEditorPlugin.INSTANCE.getString("_UI_AdapterEditorFilenameExtension");
				String enteredExt = new Path(getFileName()).getFileExtension();
				if (enteredExt == null || !enteredExt.equals(requiredExt)) {
					setErrorMessage(AcadEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object [] { requiredExt }));
					return false;
				}
				else {
					return true;
				}
			}
			else {
				return false;
			}
		}

		/**
		 * Store the dialog field settings upon completion.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public boolean performFinish() {
			modelFile = getModelFile();
			encoding = getEncoding();
			
			return true;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public IFile getModelFile() {
			return
				modelFile == null ?
					ResourcesPlugin.getWorkspace().getRoot().getFile(getContainerFullPath().append(getFileName())) :
					modelFile;
		}
	}

	/**
	 * This is the page where the log template is selected.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public class ConfigLogTemplatePage extends WizardPage
									   implements SelectionListener
												  , ModifyListener
	{
		

	   String templateLogName;
	   Button browseBtn;
     
		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected Text templateLog;


		/**
		 * Pass in the selection.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ConfigLogTemplatePage(String pageId) {
			super(pageId);
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public void createControl(Composite parent) {
			Composite composite = new Composite(parent, SWT.NONE); {
				GridLayout layout = new GridLayout();
				layout.numColumns = 2;
				layout.verticalSpacing = 12;
				composite.setLayout(layout);
		
				GridData data = new GridData();
				data.verticalAlignment = GridData.FILL;
				data.grabExcessVerticalSpace = true;
				data.horizontalAlignment = GridData.FILL;
				composite.setLayoutData(data);
			}
		
			Label containerLabel = new Label(composite, SWT.LEFT); {
				containerLabel.setText(AcadEditorPlugin.getDefault().getString("LOG_NAME_LABEL"));
		
				GridData data = new GridData();
				data.horizontalAlignment = GridData.FILL;
				data.horizontalSpan = 2;
				containerLabel.setLayoutData(data);
			}
		
			templateLog = new Text(composite, SWT.BORDER); {
				GridData data = new GridData();
				data.horizontalAlignment = GridData.FILL;
				data.grabExcessHorizontalSpace = true;
				templateLog.setLayoutData(data);
			}
		
			browseBtn = new Button(composite, SWT.PUSH);
			browseBtn.setText(AcadEditorPlugin.getDefault().getString("BROWSE"));
		
		  browseBtn.addSelectionListener(this);
		  templateLog.addModifyListener(this);
		     
		
			setControl(composite);
		
			setPageComplete(isPageComplete());
			
			WorkbenchHelp.setHelp(parent, ContextIds.ACAD_EDITOR_WIZARDPAGE_LOG_FILE);
					
		}

		/**
		 * The framework calls this to see if the file is correct.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public boolean isPageComplete() {
		  	
				String name = getTemplateLogName();
				if(name == null || name.length() == 0)
				   return false;
		  	     
				return true;
		}

		/**
		 * Store the dialog field settings upon completion.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public boolean performFinish() {
			templateLogName = getTemplateLogName();
			return true;
		}
	  
	  public void widgetSelected(SelectionEvent e)
	  {
		  IContainer input = ResourcesPlugin.getWorkspace().getRoot();

			FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
			dialog.setFileName(templateLog.getText().concat(File.separator).concat("*"));
					
			String selectedFile = dialog.open();
			if (selectedFile != null)
			{
				templateLog.setText(selectedFile);
				setPageComplete(isPageComplete());
			}
	  }

	  public void widgetDefaultSelected(SelectionEvent e)
	  {
	  }
	 
	  public void modifyText(ModifyEvent e)
	  {
		  templateLogName = templateLog.getText();
		  setPageComplete(isPageComplete());
	  }


		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public String getTemplateLogName() {
			return
				templateLogName == null ?
					templateLog.getText() :
					templateLogName;
		}

		/**
		 * @return
		 */
		public Text getTemplateLog() {
			return templateLog;
		}

		/**
		 * @param text
		 */
		public void setTemplateLog(Text text) {
			templateLog = text;
		}

	}


	/**
	 * The framework calls this to create the contents of the wizard.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addPages() {
		// Create a page, set the title, and the initial model file name.
		//
		newFileCreationPage = new AdaptorModelWizardNewFileCreationPage("Whatever", selection);
		newFileCreationPage.setTitle(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorModelWizard_label"));
		newFileCreationPage.setDescription(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorModelWizard_description"));
		newFileCreationPage.setFileName(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditorFilenameDefaultBase") + "." + AcadEditorPlugin.INSTANCE.getString("_UI_AdapterEditorFilenameExtension"));
		addPage(newFileCreationPage);

		logPage = new ConfigLogTemplatePage("logPage");
		logPage.setDescription("Select a template log file.");
		logPage.setTitle("Template log file");
		addPage(logPage);

		// Try and get the resource selection to determine a current directory for the file dialog.
		//
		if (selection != null && !selection.isEmpty()) {
			// Get the resource...
			//
			Object selectedElement = selection.iterator().next();
			if (selectedElement instanceof IResource) {
				// Get the resource parent, if its a file.
				//
				IResource selectedResource = (IResource)selectedElement;
				if (selectedResource.getType() == IResource.FILE) {
					selectedResource = selectedResource.getParent();
				}

				// This gives us a directory...
				//
				if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
					// Set this for the container.
					//
					String currentDirectory = selectedResource.getLocation().toOSString();
					newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());

					// Make up a unique new name here.
					//
					String defaultModelBaseFilename = AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditorFilenameDefaultBase");
					String defaultModelFilenameExtension = AcadEditorPlugin.INSTANCE.getString("_UI_AdapterEditorFilenameExtension");
					String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
					for (int i = 1; ((IContainer)selectedResource).findMember(modelFilename) != null; ++i) {
						modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
					}
					newFileCreationPage.setFileName(modelFilename);
				}
			}
		}
	}

	/**
	 * Get the file from the page.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFile getModelFile() {
		return newFileCreationPage.getModelFile();
	}
}
