/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.Configuration;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ComponentConfigSection extends Composite
								implements IDetails, ModifyListener
										   , INotifyChangedListener
{
	protected Text descriptionText;		
	
	protected Label uniqueId;
	
    protected boolean isDisplaying;
    protected Configuration currentSelection;
    protected ConfigurationItemProvider itemProvider;
    protected ConfigurationItemProviderAdapterFactory itemFactory;
	
	
	public ComponentConfigSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new ConfigurationItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONFIG_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.MULTI);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONFIG_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		descriptionText.addModifyListener(this);
		
		itemProvider = (ConfigurationItemProvider)itemFactory.createConfigurationAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
        
		if(currentSelection == object)
		  return;
        
		if(descriptionText.isFocusControl() || uniqueId.isFocusControl())		   
		  return;
        
		currentSelection = (Configuration)object;
		isDisplaying = true;
			
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		uniqueId.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (Configuration)currentSelection;
		
		this.currentSelection.setDescription(descriptionText.getText());
		this.currentSelection.setUniqueID(uniqueId.getText());
		
		return false;

	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ConfigurationItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

}
