/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ExtractorSection extends Composite
								implements IDetails, ModifyListener, SelectionListener
								           , INotifyChangedListener
{
	protected Button isReplaceLineBreaks;
	protected Button hasStartEvent;		
	protected Text eventStartText;
	
	protected Button hasEndEvent;		
	protected Text eventEndText;
	
	protected Button isLineBreaks;	
	protected Text lineBreaksText;
	
	protected Text descriptionText;
	protected Label uniqueIdText;	
	
	protected Extractor currentSelection;
	
    protected boolean isDisplaying = false;
    protected ExtractorItemProvider itemProvider;
    protected ExtractorItemProviderAdapterFactory itemFactory;
	
	
	public ExtractorSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new ExtractorItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
				
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.NULL);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_ID"), SWT.NONE);	
		uniqueIdText = factory.createLabel(this, "");
		uniqueIdText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		isLineBreaks = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_HAS_LINEB"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		isLineBreaks.setLayoutData(data);

		isReplaceLineBreaks = factory.createButton(this, AcadEditorPlugin.INSTANCE.getString("REPLACE_LINE_BREAK"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		isReplaceLineBreaks.setLayoutData(data);

		Composite grp = new Composite(this, SWT.NONE);
		detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 10;
		grp.setLayout(detailLayout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		grp.setLayoutData(data);
		label = factory.createLabel(grp, AcadEditorPlugin.getPlugin().getString("STR_EXTR_LINE_BSYMB"), SWT.NONE);	
		data = new GridData();
//		data.horizontalIndent = 20;
		label.setLayoutData(data);
		
		lineBreaksText = factory.createText(grp, "", SWT.NULL);
		lineBreaksText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		grp = new Composite(this, SWT.NONE);
		detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 10;
		grp.setLayout(detailLayout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		grp.setLayoutData(data);
		label = factory.createLabel(grp, AcadEditorPlugin.getPlugin().getString("STR_EXTR_STARTP"), SWT.NONE);
		data = new GridData();
//		data.horizontalIndent = 20;
		label.setLayoutData(data);

		hasStartEvent = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_STARTP"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		hasStartEvent.setLayoutData(data);


		eventStartText = factory.createText(grp, "", SWT.NULL);
		eventStartText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		grp = new Composite(this, SWT.NONE);
		detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 10;
		grp.setLayout(detailLayout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		grp.setLayoutData(data);

		label = factory.createLabel(grp, AcadEditorPlugin.getPlugin().getString("STR_EXTR_END_PATTERN"), SWT.NONE);	
		data = new GridData();
//		data.horizontalIndent = 20;
		label.setLayoutData(data);

		hasEndEvent = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_ENDP"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		hasEndEvent.setLayoutData(data);

		
		eventEndText = factory.createText(grp, "", SWT.NULL);
		eventEndText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		eventEndText.addModifyListener(this);
		eventStartText.addModifyListener(this);
		descriptionText.addModifyListener(this);
		lineBreaksText.addModifyListener(this);
		isLineBreaks.addSelectionListener(this);
		hasStartEvent.addSelectionListener(this);
		hasEndEvent.addSelectionListener(this);
		isReplaceLineBreaks.addSelectionListener(this);
    		
		itemProvider = (ExtractorItemProvider)itemFactory.createExtractorAdapter();
		itemProvider.addListener(this);
	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		if(currentSelection == null || isDisplaying)
		  return;
		
		if(e.getSource() == eventStartText)
		{
			String text = eventStartText.getText();
			if(!text.equals(currentSelection.getStartPattern()))
			{
				if(text.length() == 0 && currentSelection.getStartPattern() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.START_PATTERN);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}		  
		else if(e.getSource() == eventEndText)
		{
			String text = eventEndText.getText();
			if(!text.equals(currentSelection.getEndPattern()))
			{
				if(text.length() == 0 && currentSelection.getEndPattern() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.END_PATTERN);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		else if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		else if(e.getSource() == lineBreaksText)
		{
			String text = lineBreaksText.getText();
			if(!text.equals(currentSelection.getLineBreakSymbol()))
			{
				if(text.length() == 0 && currentSelection.getLineBreakSymbol() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.LINE_BREAK_SYMBOL);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
		currentSelection = null;
	}

    protected void updateControls()
    {
    	isDisplaying = true;
 
		if(currentSelection.getUniqueID() != null)
		   uniqueIdText.setText(currentSelection.getUniqueID());

		if(currentSelection.getDescription() != null)
		   descriptionText.setText(currentSelection.getDescription());
    	
    	if(currentSelection.getStartPattern() != null)
    		eventStartText.setText(currentSelection.getStartPattern());
    		
    	if(currentSelection.getEndPattern() != null)
    	   eventEndText.setText(currentSelection.getEndPattern());
    	   
		if(currentSelection.getLineBreakSymbol() != null)
		   lineBreaksText.setText(currentSelection.getLineBreakSymbol());
		   
		isLineBreaks.setSelection(currentSelection.isContainsLineBreaks());
		hasStartEvent.setSelection(currentSelection.isIncludeStartPattern());
		hasEndEvent.setSelection((currentSelection.isIncludeEndPattern())); 
		isReplaceLineBreaks.setSelection(currentSelection.isReplaceLineBreaks());
 
    	isDisplaying = false;
    }
    
	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == isReplaceLineBreaks)
		{
			boolean value = isReplaceLineBreaks.getSelection();
			
			if(value != currentSelection.isReplaceLineBreaks())
			{
				currentSelection.setReplaceLineBreaks(value);
				
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.START_PATTERN);
						
				String oldValue = currentSelection.getStartPattern();		
				if(descriptor != null)
				{
					descriptor.setPropertyValue(currentSelection, oldValue);										
				}	
			}
			
		}
		
		else if(e.getSource() == isLineBreaks)
		{
			boolean value = isLineBreaks.getSelection();
			
			if(value != currentSelection.isContainsLineBreaks())
			{
				currentSelection.setContainsLineBreaks(value);
				
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.START_PATTERN);
						
				String oldValue = currentSelection.getStartPattern();		
				if(descriptor != null)
				{
					descriptor.setPropertyValue(currentSelection, oldValue);										
				}	
			}
			
		}
		else if(e.getSource() == hasEndEvent)
		{
			boolean value = hasEndEvent.getSelection();
			
			if(value != currentSelection.isIncludeEndPattern())
			{
				currentSelection.setIncludeEndPattern(value);
				
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.START_PATTERN);
						
				String oldValue = currentSelection.getStartPattern();		
				if(descriptor != null)
				{
					descriptor.setPropertyValue(currentSelection, oldValue);										
				}	
			}
			
		}		
		else if(e.getSource() == hasStartEvent)
		{
			boolean value = hasStartEvent.getSelection();
			
			if(value != currentSelection.isIncludeStartPattern())
			{
				currentSelection.setIncludeStartPattern(value);
				
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ExtractorItemProvider.START_PATTERN);
						
				String oldValue = currentSelection.getStartPattern();		
				if(descriptor != null)
				{
					descriptor.setPropertyValue(currentSelection, oldValue);										
				}	
			}
			
		}		

		
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		if(eventEndText.isFocusControl() || eventStartText.isFocusControl()
		   || uniqueIdText.isFocusControl() || descriptionText.isFocusControl()
		   || isLineBreaks.isFocusControl() || lineBreaksText.isFocusControl()
		   || hasEndEvent.isFocusControl() || hasStartEvent.isFocusControl()
		   || isReplaceLineBreaks.isFocusControl()
		   )
		    return;
		    
		updateControls();
	}

	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
        
        if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer());
        
		if(currentSelection == object)
		  return;
        
		if(eventEndText.isFocusControl() || eventStartText.isFocusControl()
		   || uniqueIdText.isFocusControl() || descriptionText.isFocusControl()
		   || isLineBreaks.isFocusControl() || lineBreaksText.isFocusControl()
		   || hasEndEvent.isFocusControl() || hasStartEvent.isFocusControl()
		   || isReplaceLineBreaks.isFocusControl()
		   )
			return;
        
		currentSelection = (Extractor)object;
		isDisplaying = true;
			
		updateControls();
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

		this.currentSelection = (Extractor)currentSelection;
		
		this.currentSelection.setDescription(descriptionText.getText());
		this.currentSelection.setUniqueID(uniqueIdText.getText());

		this.currentSelection.setReplaceLineBreaks(isReplaceLineBreaks.getSelection());
		this.currentSelection.setContainsLineBreaks(isLineBreaks.getSelection());
		this.currentSelection.setLineBreakSymbol(lineBreaksText.getText());
		this.currentSelection.setIncludeStartPattern(hasStartEvent.getSelection());
		this.currentSelection.setStartPattern(eventStartText.getText());
		this.currentSelection.setIncludeEndPattern(hasEndEvent.getSelection());
		this.currentSelection.setEndPattern(eventEndText.getText());
		
		return false;

	}
    
}
