/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.remote;

import java.io.IOException;

import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;

/**
 * object to be implemented by objects which will setup the execution environment for a recorder
 * @author Ernest Jessee
 */
public abstract class RecorderEnvironmentAdapter
{
	
	protected abstract String getClassPathEntry();
		
	
	public void setupExecutionEnvironment(IExecutionEnvironment env) throws IOException
	{
		appendClassPath(env);
	
	}
	
	private void appendClassPath(IExecutionEnvironment environment)
			throws IOException
	{
		String classPathEntry = getClassPathEntry();
		if(classPathEntry!=null && classPathEntry!="") //$NON-NLS-1$
		{
			String classPathTag = "CLASSPATH"; //$NON-NLS-1$
		
			IOrderedProperty property = environment.getEnvByName(classPathTag);
			if(property == null)
			{
				property = new OrderedPropertyImpl();
				property.setName(classPathTag);
			}
					
			property.appendValue(classPathEntry);
		
			
			environment.setEnv(property);
		}
	}
	
}
