/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;

/**
 * Wizard which launches the HttpProxyRecorder
 * @see org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard
 * @author Ernest Jessee
 */
public class HttpRecorderLaunchWizard extends RecorderWizard
{

	private HttpRecorderFileSelectPage fileSelectPage;
	private HttpRecorderNoProjectsPage newProjectPage;

	//private TestSuiteLocationSelectionPage testLocationPage;

	private boolean hasNoProjects = false; 

	public void run() 
	{	
		if(RecorderFactory.getInstance().getActiveRecorder()!=null)
		{
			RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR")), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_ERROR"));  //$NON-NLS-1$
			return;
		}
		
				
		Recorder recorder=null;
				
		try
		{
			recorder = HttpRecorderPlugin.getDefault().getRecorder();

			String recorderParams = "port,"+HttpRecorderPlugin.getPreference(HttpRecorderPlugin.PROXY_PORT); //$NON-NLS-1$			
			String appParams = recorderParams + ";startupURL,"+getStartupURL();

			String adapterID = HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER);
			// recorder.setApplicationAdapterID(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER));
			recorder.setApplicationAdapterID(adapterID);
			if (!(adapterID.equalsIgnoreCase("-1")))
				RecorderAppAdapterFactory.getInstance().getClient(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER)).setInitString(appParams);			
			else //do not add any additional params
				recorderParams = "port,"+HttpRecorderPlugin.getPreference(HttpRecorderPlugin.PROXY_PORT);

			String recordingFileName;
			if (hasNoProjects)
			{
				IProject project = newProjectPage.createJavaProject(monitor);								
				//rec file is based within this file
				if (project != null)
					recordingFileName = project.getFullPath().toString() + "/" + newProjectPage.getRecFile();
				else
					throw new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.JAVA_PROJECT_NOT_CREATED_ERROR"));					
			}
			else
				recordingFileName = fileSelectPage.getSelectedFilePath();
			//assign testsuite name from the recording file name - simplify wizards 			
			String generatorFileName = recordingFileName.substring(0, recordingFileName.lastIndexOf('.')) + ".testsuite";

			HttpRecorderPlugin.storePreference(HttpRecorderPlugin.RECORDING_PATH,recordingFileName);			
			recorder.setConfigParams(recorderParams);
			recorder.setRecordingPath(recordingFileName);
			
			recorder.setScriptgenID(TestgenPlugin.getPreference(TestgenPlugin.TEST_GENERATOR));
			recorder.setTestPath(generatorFileName);

			//TODO Need better place for testkeys file 
			//copy testkeys from pluginroot to c:\ if not present 
			URL resolvedTestkeys = Platform.resolve(new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
			String keyfile = resolvedTestkeys.toString(); 
			if (resolvedTestkeys.getProtocol().equals("file"))
			{
				keyfile = resolvedTestkeys.getFile();
			}
			File file = new File(keyfile);
			if (file.exists())
			{
				File destFile = new File("C:\\testkeys");
				if (destFile.createNewFile()) //only creates if no file exists
				{
					try {
						FileOutputStream out = new FileOutputStream(destFile);
						FileInputStream in = new FileInputStream(file);
						byte[] read = new byte[256];
						int nLen;
						while ((nLen = in.read(read)) != -1)
						{						
							out.write(read, 0, nLen);
						}
						out.flush();
						out.close();
						in.close();
					}
					catch (IOException ioe) {}
				}
			}

			recorder.Record();
		}
		catch (Exception e)
		{
			if(recorder!=null)	
				recorder.setActive(false);
			e.printStackTrace();
			RecorderControlView.getInstance().addMessage(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE")+e.getMessage()); //$NON-NLS-1$
		} 
		
		
		
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		setWindowTitle(HttpRecorderPlugin.getResourceString("NAME"));
		IProject[] projects = org.eclipse.core.resources.ResourcesPlugin.getWorkspace()
							.getRoot().getProjects();
		if (projects.length < 1)
		{
			hasNoProjects = true;
			addPage(newProjectPage = new HttpRecorderNoProjectsPage(HttpRecorderNoProjectsPage.class.getName()));
			newProjectPage.setInitialProjectName(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.DEFAULT_PROJECT_NAME"));
		}
		else
		{
			addPage(fileSelectPage = new HttpRecorderFileSelectPage());		
		}
		//if(!HttpRecorderPlugin.getPreference(HttpRecorderPlugin.TEST_GENERATOR).equalsIgnoreCase("-1")) //$NON-NLS-1$
		//	addPage(testLocationPage = new TestSuiteLocationSelectionPage());
	}

	protected String getStartupURL() throws IOException
	{
		//temp JN
		//TODO Need better place for testkeys file 
		//copy testkeys from pluginroot to c:\ if not present
		String startupURLroot = "readme";
		String HTML = ".html"; 
		URL startupURL = Platform.resolve(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL());
		String strInstall = null; 
		if (startupURL.getProtocol().equals("file"))
		{
			strInstall = startupURL.getFile() + startupURLroot;
		}
		String strLocalizedFile = strInstall + "_" + Locale.getDefault().toString() + HTML;
		File file = new File(strLocalizedFile);
		if (!file.exists())
		{
			strLocalizedFile = strInstall + "_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + HTML;
			file = new File(strLocalizedFile);
			if (!file.exists())
			{
				strLocalizedFile = strInstall + "_" + Locale.getDefault().getLanguage() + HTML;
				file = new File(strLocalizedFile);
				if (!file.exists())
				{
					strLocalizedFile = strInstall + HTML;
					file = new File(strLocalizedFile);
					if (!file.exists())
						return "about:blank";
				}				
			}  
		}		
		return "file://" + strLocalizedFile;
	}

}

