/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.variableloader.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.model.statistical.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.swt.graphics.*;
import java.util.*;

/**
 * This recursive tree operation adds a statistical model to statcon

 */
public class OpAddToTree implements StatConModelOp {
	public static OpAddToTree INSTANCE = new OpAddToTree();

	static ImageManager img = EditorPlugin.img;

	public static void launch(StatisticalModelGraphViewer statcon, SDDescriptor descriptor, SDDescriptor root, boolean update) {
		StatConOpState state = new StatConOpState(new Boolean(update));
		statcon.applyStatConModelOp( new OpAddToTree(), state, descriptor, root);
	}

	private String getTreeName(SDDescriptor sd) {
		String basicname = null;
		//
		// Get the basic name for this node and its duplicates
		//
		if (sd.getDescription() != null) {
			basicname = sd.getName()+" ("+sd.getDescription()+")";
		} else {
			basicname = sd.getName();
		}
		
		if (basicname == null) {
			basicname = "";	
		}
		if (basicname.length() == 0) {
			basicname = "(unknown)";	
		}
		
		return basicname;
	}	

	public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor sd, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
	}
		
	public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor sd, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {

		//ignore null nodes
		if (sd == null) return state;
		if (sd.getName() == null) return state;

		boolean update = ((Boolean)state.state).booleanValue();
		
		TreeItem item = statcon.mapDescriptorToItem(sd);
		TreeItem parent_item = statcon.mapDescriptorToItem(sd.getParent());
		
//		if (parent_item == null) return state;
		
		if (update && item != null) {
			//
			// this descriptor already exists - leave it alone and just check its children
			//
				
			//
			// update any descriptions
			//
			String tmp = getTreeName(sd);
			if (!tmp.equals(item.getText())) {
				item.setText(tmp);
			}

				
		} else {
			//
			// this descriptor does not exist or we are not updating - add it
			//
		
			if (parent_item == null) {
				
				//no parent item - make it a root of the agent
				TRCAgent agent = sd.getAgent();
				
				if (agent == null) return state;
				
				item = new TreeItem(statcon.mapAgentToItem(agent),0);
			} else {
				//parent item, create under parent
				item = new TreeItem(parent_item,0);		
			}
	
			//
			// Get the basic descriptor to the tree
			//
			item.setText(getTreeName(sd));
			item.setImage(img.getImage(ImageManager.IMG_SMODEL_DESCRIPTOR));
			item.setChecked(true);
			item.setGrayed(false);

			statcon.mapDescriptorToItem(sd, item);

		}
		
		//TODO should sort the descriptor children here
		//normal sort doesn't work though, EMF doesn't like the duplicates
//		Collections.sort(sd.getChildren(),new DescriptorComparator());

		addObservations(statcon, sd,item,update);
		addRepresentation(statcon, sd,item,update);

		return state;
	}

	private void addObservations(StatisticalModelGraphViewer statcon, SDDescriptor sd, TreeItem item, boolean update) {
		//
		// Objects related to a SnapshotObservation (graph)
		//
		EList obs = null;
		Image obs_image = null;

		//
		// Search for observations
		//
		if (sd instanceof SDMemberDescriptor) {
			SDMemberDescriptor sdmem = (SDMemberDescriptor)sd;
			
			//
			//Check to see if it has a valid observation (metric)
			//		
			obs = sdmem.getSnapshotObservation();
			if (obs != null) {
				if (obs.size() > 0) {
					obs_image = img.getImage(ImageManager.IMG_SMODEL_COUNTER);	
				} else {
					obs = null;	
				}
			}
		}		

		//
		//Set up the graph node if necessary
		//
		if (obs != null) {
			for (int i = 0; i < obs.size(); i++) {
			
				SDSnapshotObservation o = (SDSnapshotObservation)obs.get(i);
				
				//
				// These types of observations are graphable
				//
				if (o instanceof SDContiguousObservation
					|| o instanceof SDDiscreteObservation
					|| o instanceof SDTextObservation) {

					TreeItem obs_item = statcon.mapObservationToItem(o);
					
					if (!update || obs_item == null) {
						obs_item = new TreeItem(item,0,0);		
			
						obs_item.setText(sd.getName()+" (Graph "+(i+1)+")");			
						obs_item.setImage(obs_image);
						obs_item.setGrayed(false);
						obs_item.setChecked(true);
	
						statcon.mapObservationToItem(o,obs_item);
					}
				}
			
			}
		}

	}

	private void addRepresentation(StatisticalModelGraphViewer statcon, SDDescriptor sd, TreeItem item, boolean update) {
		//
		// Objects related to a ModifiableVariableRepresentation (control)
		//
		SDModifiableVariableRepresentation rep = null;
		Image rep_image = null;

		//
		// Search for representations
		//
		if (sd instanceof SDMemberDescriptor) {
			SDMemberDescriptor sdmem = (SDMemberDescriptor)sd;

			//
			//Check to see if it has a valid modifiable representation (control)
			//
			SDRepresentation reptmp = sdmem.getRepresentation();	
			if (reptmp instanceof SDModifiableVariableRepresentation) {
				rep = (SDModifiableVariableRepresentation)reptmp;
				rep_image = rep.getImage();	
			}
		}		
		
		//
		//Set up the control node if necessary
		//
		if (rep != null) {
			TreeItem rep_item = statcon.mapRepresentationToItem(rep);
			
			if (!update || rep_item == null) {
				rep_item = new TreeItem(item,0,0);		
			
				rep_item.setText(sd.getName()+" (Control)");			
				rep_item.setImage(rep_image);
				if (rep_image == null) {
					rep_item.setImage(img.getImage(ImageManager.IMG_SMODEL_MODIFIABLEREP));
				}
				rep_item.setGrayed(false);
				rep_item.setChecked(true);
	
				statcon.mapRepresentationToItem(rep,rep_item);			
			}
		}		
	}

}