/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.model.statistical.*;

/**
 * This recursive StatCon Tree operation searches for bits of model that have disappeared but
 * still have tree structure in statcon.
 * 
 * Upon finding such phantom tree structures, they are garbage collected and removed
 */
public class OpGarbageCollectTree implements StatConTreeOp {
	public static OpGarbageCollectTree INSTANCE = new OpGarbageCollectTree();

	static ImageManager img = EditorPlugin.img;

	public static void launch(StatisticalModelGraphViewer statcon, TreeItem item, TreeItem root) {
		StatConOpState state = new StatConOpState(null);
		statcon.applyStatConTreeOp( new OpGarbageCollectTree(), state, item, root);
	}

	public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, TreeItem sd, TreeItem root_parent, boolean parents_checked, boolean parents_enabled) {
	}
	public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, TreeItem sd, TreeItem root_parent, boolean parents_checked, boolean parents_enabled) {		

		boolean remove = false;

//TODO check for non-existent representations and observations

		SDDescriptor descriptor = statcon.mapItemToDescriptor(sd);
		if (descriptor == null) {
			remove = true;
		} else if (descriptor.getParent() == null && descriptor.getAgent() == null) {
			remove = true;
		}
		
		SDRepresentation rep = statcon.mapItemToRepresentation(sd);
		if (rep != null) {
			if (rep.getMemberDescriptor() == null) {
				remove = true;	
			}
		}

		SDSnapshotObservation obs = statcon.mapItemToObservation(sd);
		if (obs != null) {
			if (obs.getMemberDescriptor() == null) {
				remove = true;	
			}
		}
		
		if (remove) {
			EditorPlugin.DBG.warning("Removing "+sd.getText());
			OpFreeSubTree.launch(statcon,sd,sd); 			
			state = null;
		}
		
		return state;
	}

}