/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.variableloader.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.model.statistical.*;
import org.eclipse.emf.common.util.*;

/**
 * This recursive StatCon operation generates the statistical model parts of the statcon configuration file 
 */
public class OpGenerateDescriptorConfig implements StatConModelOp {
	public static OpGenerateDescriptorConfig INSTANCE = new OpGenerateDescriptorConfig();

	static ImageManager img = EditorPlugin.img;

	public static void launch(StatisticalModelGraphViewer statcon, SDDescriptor item, SDDescriptor root, StringBuffer xml, int depth) {
		StatConOpState state = new StatConOpState(new State(depth,xml));
		statcon.applyStatConModelOp( new OpGenerateDescriptorConfig(), state, item, root);
	}

	public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor descriptor, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
		State mystate = (State)state.state;
		StringBuffer xml = mystate.xml;
		int depth = mystate.depth;
		
		generatePreChildConfig(statcon,xml,descriptor,depth);
		
		return new StatConOpState(new State(depth+1,xml));
	}

	public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor descriptor, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
		State mystate = (State)state.state;
		StringBuffer xml = mystate.xml;
		int depth = mystate.depth;
		
		generatePostChildConfig(statcon,xml,descriptor,depth);
	}
	
	static class State {
		public State(int depth, StringBuffer xml) {
			this.depth = depth;
			this.xml = xml;
		}
		int depth = 0;
		StringBuffer xml;
	}


	private void generatePostChildConfig(StatisticalModelGraphViewer statcon, StringBuffer xml, SDDescriptor descriptor, int depth) {
		for (int t = 0; t < depth; t++) {
			xml.append("  ");	
		} 
		xml.append("</descriptor>\n");
	}
	
	private void generatePreChildConfig(StatisticalModelGraphViewer statcon, StringBuffer xml, SDDescriptor descriptor, int depth) {

//		TreeItem sd_item = (TreeItem)reverse_map.get(descriptor);
		TreeItem sd_item = (TreeItem)statcon.mapDescriptorToItem(descriptor);

		if (descriptor == null) return;
		if (sd_item == null) return;

		//
		// Append descriptor information
		//
		for (int t = 0; t < depth; t++) {
			xml.append("  ");	
		} 
		xml.append("<descriptor ");
		xml.append("name=\"").append(descriptor.getName()).append("\" ");
		xml.append("ticked=\"").append(sd_item.getChecked()).append("\" ");
		xml.append("expanded=\"").append(sd_item.getExpanded()).append("\" ");
		xml.append(">\n");
		
		//
		// Append descriptor graph informationm
		//
		if (descriptor instanceof SDMemberDescriptor) {
			SDMemberDescriptor mem_descriptor = (SDMemberDescriptor)descriptor;
			EList observations = mem_descriptor.getSnapshotObservation();
			
			for (int i = 0; i < observations.size(); i++) {
				Object o = observations.get(i);
				if (o instanceof SDContiguousObservation || o instanceof SDTextObservation) {
//					TreeItem obs_item = (TreeItem)reverse_map.get(o);
					TreeItem obs_item = (TreeItem)statcon.mapObservationToItem((SDSnapshotObservation)o);

//					BasicGraphSource source = (BasicGraphSource)source_map.get(obs_item);
					BasicGraphSource source = statcon.mapItemToGraphSource(obs_item);
					
//					Graph graph = (Graph)source_graph_map.get(source);
					Graph graph = statcon.mapSourceToGraph(source);

					if (graph != null) {

						for (int t = 0; t < depth; t++) {
							xml.append("  ");	
						} 
						xml.append("<obs_graph ");
						xml.append("ticked=\"").append(obs_item.getChecked()).append("\" ");
						xml.append("obs_index=\"").append(i).append("\" ");
						xml.append("x_slider=\"").append(statcon.getGraphWindow().getXSlider(graph.getXSlider())).append("\" ");
						xml.append("y_slider=\"").append(statcon.getGraphWindow().getYSlider(graph.getYSlider())).append("\" ");
						xml.append("color=\"").append(XMLConfigUtil.colorToString(graph.getForeground())).append("\" ");
						xml.append("line_width=\"").append(graph.getLineWidth()).append("\" ");
						xml.append("line_style=\"").append(XMLConfigUtil.lineStyleToString(graph.getLineStyle())).append("\" ");
						xml.append("multiplier=\"").append(graph.getStaticScaling()).append("\" ");
						xml.append("/>\n");
					
					}
				}
				
			}	
		}
		
		//
		// Append descriptor control information
		//
		if (descriptor instanceof SDMemberDescriptor) {
			SDMemberDescriptor mem_descriptor = (SDMemberDescriptor)descriptor;
			SDRepresentation rep = mem_descriptor.getRepresentation();
			
			if (rep instanceof SDModifiableVariableRepresentation) {
//				TreeItem rep_item = (TreeItem)reverse_map.get(rep);
				TreeItem rep_item = statcon.mapRepresentationToItem(rep);

//				ZoomSlider slider = (ZoomSlider)bar_slider_map.get(rep_item);
				ZoomSlider slider = statcon.mapItemToSlider(rep_item);

				for (int t = 0; t < depth; t++) {
					xml.append("  ");	
				} 
				
				if (slider != null) {
					xml.append("<control ");
					xml.append("ticked=\"").append(rep_item.getChecked()).append("\" ");
					xml.append("y_slider=\"").append(statcon.getGraphWindow().getYSlider(slider)).append("\" ");
					xml.append("/>\n");
				} else {
					xml.append("<control ");
					xml.append("ticked=\"").append(rep_item.getChecked()).append("\" ");
					xml.append("y_slider=\"0\" ");
					xml.append("/>\n");
				}
				
			}
			
		}
/*		
		
		//
		// Append descriptor children
		//
		EList list = descriptor.getChildren();
		for (int i = 0; i < list.size(); i++) {
			SDDescriptor child = (SDDescriptor)list.get(i);
			generateConfig(xml,child,depth+1);	
		}
*/				
	}

}