/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

public interface GraphSource extends BasicGraphSource {
	
	/**
	 * Get the minimum time this graph has data at
	 * @return the minimum time this graph has data at
	 */
	public double getMin();

	/**
	 * Get the maximum time this graph has data at
	 * @return the maximum time this graph has data at
	 */
	public double getMax();

	/**
	 * Get the maximum value this graph source holds
	 * @return the maximum value this graph source holds
	 */
	public double getValueMax();

	/**
	 * Get the minimum value this graph source holds
	 * @return the minimum value this graph source holds
	 */
	public double getValueMin();

	/**
	 * Get the value at or immediately before the provided time
	 * @param x the time to get the value at
	 * @return the value at or immediately before the provided time
	 */
	public double getValueAt(double x);

	/**
	 * Get the average of values between the provided times, inclusive of
	 * x and exclusive of x2
	 * @param x the start time to average from
	 * @param x2 the end time to average to
	 * @return the average of the values between x and x2
	 */
	public double getAverageBetween(double x, double x2);

	/**
	 * Get the sum of values between the provided times, inclusive of
	 * x and exclusive of x2
	 * @param x the start time to sum from
	 * @param x2 the end time to sum to
	 * @return the sumof the values between x and x2
	 */
	public double getSumBetween(double x, double x2);
}