/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.internal.probekit.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.hyades.models.internal.probekit.Code;
import org.eclipse.hyades.models.internal.probekit.ControlKey;
import org.eclipse.hyades.models.internal.probekit.ControlName;
import org.eclipse.hyades.models.internal.probekit.Data;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.models.internal.probekit.Description;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.FragmentAtClassScope;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.models.internal.probekit.Import;
import org.eclipse.hyades.models.internal.probekit.InvocationObject;
import org.eclipse.hyades.models.internal.probekit.Name;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.StaticField;
import org.eclipse.hyades.models.internal.probekit.Target;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ProbekitPackageImpl extends EPackageImpl implements ProbekitPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass codeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass controlKeyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass controlNameEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass dataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass descriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fragmentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fragmentAtClassScopeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass importEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass invocationObjectEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass nameEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass targetEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass staticFieldEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass probeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass probekitEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum dataTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum fragmentTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.models.internal.probekit.ProbekitPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ProbekitPackageImpl()
	{
		super(eNS_URI, ProbekitFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ProbekitPackage init()
	{
		if (isInited) return (ProbekitPackage)EPackage.Registry.INSTANCE.get(ProbekitPackage.eNS_URI);

		// Obtain or create and register package.
		ProbekitPackageImpl theProbekitPackage = (ProbekitPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ProbekitPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies

		// Step 1: create meta-model objects
		theProbekitPackage.createPackageContents();

		// Step 2: complete initialization
		theProbekitPackage.initializePackageContents();

		return theProbekitPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCode()
	{
		return codeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCode_Value()
	{
		return (EAttribute)codeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getControlKey()
	{
		return controlKeyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getControlKey_Name()
	{
		return (EAttribute)controlKeyEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getControlKey_Value()
	{
		return (EAttribute)controlKeyEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getControlName()
	{
		return controlNameEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getControlName_Lang()
	{
		return (EAttribute)controlNameEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getControlName_Text()
	{
		return (EAttribute)controlNameEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getData()
	{
		return dataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getData_Name()
	{
		return (EAttribute)dataEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getData_Type()
	{
		return (EAttribute)dataEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDescription()
	{
		return descriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDescription_Value()
	{
		return (EAttribute)descriptionEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDescription_Lang()
	{
		return (EAttribute)descriptionEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFragment()
	{
		return fragmentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFragment_Type()
	{
		return (EAttribute)fragmentEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFragment_Data()
	{
		return (EReference)fragmentEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFragment_Code()
	{
		return (EReference)fragmentEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFragmentAtClassScope()
	{
		return fragmentAtClassScopeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFragmentAtClassScope_Value()
	{
		return (EAttribute)fragmentAtClassScopeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getImport()
	{
		return importEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getImport_Text()
	{
		return (EAttribute)importEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInvocationObject()
	{
		return invocationObjectEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getInvocationObject_Name()
	{
		return (EAttribute)invocationObjectEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getName_()
	{
		return nameEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getName_Lang()
	{
		return (EAttribute)nameEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getName_Text()
	{
		return (EAttribute)nameEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTarget()
	{
		return targetEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTarget_ClassName()
	{
		return (EAttribute)targetEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTarget_Method()
	{
		return (EAttribute)targetEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTarget_Package()
	{
		return (EAttribute)targetEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTarget_Signature()
	{
		return (EAttribute)targetEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTarget_Type()
	{
		return (EAttribute)targetEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStaticField()
	{
		return staticFieldEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStaticField_Value()
	{
		return (EAttribute)staticFieldEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStaticField_Type()
	{
		return (EAttribute)staticFieldEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProbe()
	{
		return probeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_Name()
	{
		return (EReference)probeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_Description()
	{
		return (EReference)probeEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_ControlKey()
	{
		return (EReference)probeEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_ControlName()
	{
		return (EReference)probeEClass.getEReferences().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_Target()
	{
		return (EReference)probeEClass.getEReferences().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_Import()
	{
		return (EReference)probeEClass.getEReferences().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_FragmentAtClassScope()
	{
		return (EReference)probeEClass.getEReferences().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_Fragment()
	{
		return (EReference)probeEClass.getEReferences().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_InvocationObject()
	{
		return (EReference)probeEClass.getEReferences().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbe_StaticField()
	{
		return (EReference)probeEClass.getEReferences().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProbekit()
	{
		return probekitEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProbekit_Id()
	{
		return (EAttribute)probekitEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProbekit_Version()
	{
		return (EAttribute)probekitEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbekit_Name()
	{
		return (EReference)probekitEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbekit_Description()
	{
		return (EReference)probekitEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProbekit_Probe()
	{
		return (EReference)probekitEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getDataType() {
		return dataTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getFragmentType() {
		return fragmentTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitFactory getProbekitFactory()
	{
		return (ProbekitFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents()
	{
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		codeEClass = createEClass(CODE);
		createEAttribute(codeEClass, CODE__VALUE);

		controlKeyEClass = createEClass(CONTROL_KEY);
		createEAttribute(controlKeyEClass, CONTROL_KEY__NAME);
		createEAttribute(controlKeyEClass, CONTROL_KEY__VALUE);

		controlNameEClass = createEClass(CONTROL_NAME);
		createEAttribute(controlNameEClass, CONTROL_NAME__LANG);
		createEAttribute(controlNameEClass, CONTROL_NAME__TEXT);

		dataEClass = createEClass(DATA);
		createEAttribute(dataEClass, DATA__NAME);
		createEAttribute(dataEClass, DATA__TYPE);

		descriptionEClass = createEClass(DESCRIPTION);
		createEAttribute(descriptionEClass, DESCRIPTION__VALUE);
		createEAttribute(descriptionEClass, DESCRIPTION__LANG);

		fragmentEClass = createEClass(FRAGMENT);
		createEAttribute(fragmentEClass, FRAGMENT__TYPE);
		createEReference(fragmentEClass, FRAGMENT__DATA);
		createEReference(fragmentEClass, FRAGMENT__CODE);

		fragmentAtClassScopeEClass = createEClass(FRAGMENT_AT_CLASS_SCOPE);
		createEAttribute(fragmentAtClassScopeEClass, FRAGMENT_AT_CLASS_SCOPE__VALUE);

		importEClass = createEClass(IMPORT);
		createEAttribute(importEClass, IMPORT__TEXT);

		invocationObjectEClass = createEClass(INVOCATION_OBJECT);
		createEAttribute(invocationObjectEClass, INVOCATION_OBJECT__NAME);

		nameEClass = createEClass(NAME);
		createEAttribute(nameEClass, NAME__LANG);
		createEAttribute(nameEClass, NAME__TEXT);

		targetEClass = createEClass(TARGET);
		createEAttribute(targetEClass, TARGET__CLASS_NAME);
		createEAttribute(targetEClass, TARGET__METHOD);
		createEAttribute(targetEClass, TARGET__PACKAGE);
		createEAttribute(targetEClass, TARGET__SIGNATURE);
		createEAttribute(targetEClass, TARGET__TYPE);

		staticFieldEClass = createEClass(STATIC_FIELD);
		createEAttribute(staticFieldEClass, STATIC_FIELD__VALUE);
		createEAttribute(staticFieldEClass, STATIC_FIELD__TYPE);

		probeEClass = createEClass(PROBE);
		createEReference(probeEClass, PROBE__NAME);
		createEReference(probeEClass, PROBE__DESCRIPTION);
		createEReference(probeEClass, PROBE__CONTROL_KEY);
		createEReference(probeEClass, PROBE__CONTROL_NAME);
		createEReference(probeEClass, PROBE__TARGET);
		createEReference(probeEClass, PROBE__IMPORT);
		createEReference(probeEClass, PROBE__FRAGMENT_AT_CLASS_SCOPE);
		createEReference(probeEClass, PROBE__FRAGMENT);
		createEReference(probeEClass, PROBE__INVOCATION_OBJECT);
		createEReference(probeEClass, PROBE__STATIC_FIELD);

		probekitEClass = createEClass(PROBEKIT);
		createEAttribute(probekitEClass, PROBEKIT__ID);
		createEAttribute(probekitEClass, PROBEKIT__VERSION);
		createEReference(probekitEClass, PROBEKIT__NAME);
		createEReference(probekitEClass, PROBEKIT__DESCRIPTION);
		createEReference(probekitEClass, PROBEKIT__PROBE);

		// Create enums
		dataTypeEEnum = createEEnum(DATA_TYPE);
		fragmentTypeEEnum = createEEnum(FRAGMENT_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents()
	{
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(codeEClass, Code.class, "Code", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getCode_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(controlKeyEClass, ControlKey.class, "ControlKey", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getControlKey_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getControlKey_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(controlNameEClass, ControlName.class, "ControlName", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getControlName_Lang(), ecorePackage.getEString(), "lang", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getControlName_Text(), ecorePackage.getEString(), "text", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(dataEClass, Data.class, "Data", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getData_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getData_Type(), this.getDataType(), "type", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(descriptionEClass, Description.class, "Description", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getDescription_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getDescription_Lang(), ecorePackage.getEString(), "lang", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(fragmentEClass, Fragment.class, "Fragment", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getFragment_Type(), this.getFragmentType(), "type", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getFragment_Data(), this.getData(), null, "data", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getFragment_Code(), this.getCode(), null, "code", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(fragmentAtClassScopeEClass, FragmentAtClassScope.class, "FragmentAtClassScope", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getFragmentAtClassScope_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(importEClass, Import.class, "Import", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getImport_Text(), ecorePackage.getEString(), "text", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(invocationObjectEClass, InvocationObject.class, "InvocationObject", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getInvocationObject_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(nameEClass, Name.class, "Name", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getName_Lang(), ecorePackage.getEString(), "lang", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getName_Text(), ecorePackage.getEString(), "text", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(targetEClass, Target.class, "Target", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTarget_ClassName(), ecorePackage.getEString(), "className", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTarget_Method(), ecorePackage.getEString(), "method", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTarget_Package(), ecorePackage.getEString(), "package", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTarget_Signature(), ecorePackage.getEString(), "signature", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTarget_Type(), ecorePackage.getEString(), "type", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(staticFieldEClass, StaticField.class, "StaticField", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getStaticField_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getStaticField_Type(), ecorePackage.getEString(), "type", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(probeEClass, Probe.class, "Probe", !IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getProbe_Name(), this.getName_(), null, "name", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_Description(), this.getDescription(), null, "description", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_ControlKey(), this.getControlKey(), null, "controlKey", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_ControlName(), this.getControlName(), null, "controlName", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_Target(), this.getTarget(), null, "target", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_Import(), this.getImport(), null, "import", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_FragmentAtClassScope(), this.getFragmentAtClassScope(), null, "fragmentAtClassScope", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_Fragment(), this.getFragment(), null, "fragment", null, 1, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_InvocationObject(), this.getInvocationObject(), null, "invocationObject", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbe_StaticField(), this.getStaticField(), null, "staticField", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(probekitEClass, Probekit.class, "Probekit", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getProbekit_Id(), ecorePackage.getEString(), "id", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getProbekit_Version(), ecorePackage.getEString(), "version", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getProbekit_Name(), this.getName_(), null, "name", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbekit_Description(), this.getDescription(), null, "description", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getProbekit_Probe(), this.getProbe(), null, "probe", null, 1, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		// Initialize enums and add enum literals
		initEEnum(dataTypeEEnum, DataType.class, "DataType");
		addEEnumLiteral(dataTypeEEnum, DataType.CLASS_NAME_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.METHOD_NAME_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.METHOD_SIG_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.THIS_OBJECT_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.ARGS_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.RETURNED_OBJECT_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.IS_FINALLY_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.EXCEPTION_OBJECT_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.STATIC_FIELD_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.CLASS_SOURCE_FILE_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.METHOD_NAMES_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.METHOD_LINE_TABLES_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.METHOD_NUMBER_LITERAL);
		addEEnumLiteral(dataTypeEEnum, DataType.EXECUTABLE_UNIT_NUMBER_LITERAL);

		initEEnum(fragmentTypeEEnum, FragmentType.class, "FragmentType");
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.ENTRY_LITERAL);
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.CATCH_LITERAL);
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.EXIT_LITERAL);
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.BEFORE_CALL_LITERAL);
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.AFTER_CALL_LITERAL);
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.STATIC_INITIALIZER_LITERAL);
		addEEnumLiteral(fragmentTypeEEnum, FragmentType.EXECUTABLE_UNIT_LITERAL);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore
		createXSD2EcoreAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createXSD2EcoreAnnotations()
	{
		String source = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "representation", "schema",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (codeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "code",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getCode_Value(), 
		   source, 
		   new String[] {
			 "representation", "simple-content"
		   });		
		addAnnotation
		  (controlKeyEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "controlKey",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getControlKey_Name(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getControlKey_Value(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "value",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (controlNameEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "controlName",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getControlName_Lang(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "lang",
			 "targetNamespace", "http://www.w3.org/XML/1998/namespace"
		   });		
		addAnnotation
		  (getControlName_Text(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "text",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (dataTypeEEnum, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "dataType",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (dataEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "data",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getData_Name(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getData_Type(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "type",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (descriptionEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getDescription_Value(), 
		   source, 
		   new String[] {
			 "representation", "simple-content"
		   });		
		addAnnotation
		  (getDescription_Lang(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "lang",
			 "targetNamespace", "http://www.w3.org/XML/1998/namespace"
		   });		
		addAnnotation
		  (fragmentTypeEEnum, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "fragmentType",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (fragmentEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "fragment",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getFragment_Data(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "data",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getFragment_Code(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "code",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getFragment_Type(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "type",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (fragmentAtClassScopeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "fragmentAtClassScope",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getFragmentAtClassScope_Value(), 
		   source, 
		   new String[] {
			 "representation", "simple-content"
		   });		
		addAnnotation
		  (importEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "import",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getImport_Text(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "text",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (invocationObjectEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "invocationObject",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getInvocationObject_Name(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (nameEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getName_Lang(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "lang",
			 "targetNamespace", "http://www.w3.org/XML/1998/namespace"
		   });		
		addAnnotation
		  (getName_Text(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "text",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (targetEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "target",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getTarget_ClassName(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "className",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getTarget_Method(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "method",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getTarget_Package(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "package",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getTarget_Signature(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "signature",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getTarget_Type(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "type",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (staticFieldEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "staticField",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getStaticField_Value(), 
		   source, 
		   new String[] {
			 "representation", "simple-content"
		   });		
		addAnnotation
		  (getStaticField_Type(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "type",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (probeEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "probe",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_Name(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_Description(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_ControlKey(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "controlKey",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_ControlName(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "controlName",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_Target(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "target",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_Import(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "import",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_FragmentAtClassScope(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "fragmentAtClassScope",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_Fragment(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "fragment",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_InvocationObject(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "invocationObject",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbe_StaticField(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "staticField",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (probekitEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "probekit",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbekit_Name(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbekit_Description(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbekit_Probe(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "probe",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbekit_Id(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "id",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getProbekit_Version(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "version",
			 "targetNamespace", null
		   });
	}
} //ProbekitPackageImpl
