/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.actions;

import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.jface.action.Action;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogNavigatorFilterAction extends Action {
	private int fFilterProperty;
	private LogNavigator navigator;
	

	public LogNavigatorFilterAction(LogNavigator navigator,
		String label, int property, boolean initValue)
	{
		super(label);
		
		this.navigator= navigator;
		fFilterProperty= property;
		setChecked(initValue);

		setToolTipText(label);
	}
	/**
	 * @see Action#actionPerformed
	 */
	public void run() {	
		valueChanged(isChecked());
	}
	/* (non-Javadoc)
	 * Method declared on IAction.
	 */
	public void setChecked(boolean checked)
	{
		//IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		//store.setValue(TraceConstants.getPreferenceString(fFilterProperty),checked);
		navigator.getSettings().put(TraceConstants.getPreferenceString(fFilterProperty),checked);
		setChecked(checked, true);
	}
	/* (non-Javadoc)
	 * Method declared on IAction.
	 */
	public void setChecked(boolean checked, boolean refresh)
	{
		super.setChecked(checked);
		valueChanged(checked, refresh);
	}
	
	private void valueChanged(boolean on)
	{
		valueChanged(on, false);
	}
	private void valueChanged(boolean on, boolean refresh) {
		if (on) {
			navigator.removeFilter(fFilterProperty);
		} else {
			navigator.addFilter(fFilterProperty);
		}

		if(refresh)
		{
			navigator.getTreeViewer().refresh();			
		}
	}

}
