/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;

public class LogAnalyzerAdvanceFilterPrefPage
{
	private CBEAdvFilterUI _advfilter;
	private IPreferenceStore _preferenceStore;
	
	public LogAnalyzerAdvanceFilterPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		composite.setLayoutData(data);

		_advfilter = new CBEAdvFilterUI();
		_advfilter.createControl(composite);

		initializeValues();
//		WorkbenchHelp.setHelp(composite, ContextIds.ACTLOG_PREF_FILTER_PROPERTIES);

		return composite;
	}

	public void init(IWorkbench workbench) {}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		_advfilter.initializeValues(true);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		_advfilter.initializeValues(false);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		return true;		
	}

	public boolean performApply(){
		storeValues();
		return true;		
	}
	
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private boolean storeValues() {
		boolean ret = _advfilter.storeValues(_preferenceStore);
		if(ret){			
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_ADV_CHANGE, this));				
		}
		return ret;
	}
}