/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
/**
 * 
 */
public class TraceMergeUI{

	private Button _chkMerge;
	private Button _chkLargeLogSupport;
	private TreeViewer _viewer;
	private Label _description;
	protected List _monitorsList = new ArrayList();
	/**
	 * Constructor for TraceMergeUI.
	 */
	public TraceMergeUI() {
		super();
	}

	public Composite createControl(Composite parent)
	{
		GridLayout layout;
		GridData   data;
		
		Composite result = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
	
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 200;

		result.setLayoutData(data);
		createSpace(result);

		if(HierarchyPlugin.getPlugin().getPluginPreferences().contains(IHyadesResourceFactory.LARGE_LOG_SUPPORT_DB_TYPE))
			createLargeLogSupport(result);
		
		createMergeGroup(result);
		createDescription(result);
		createTreeViewer(result);
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_chkMerge,
			LogUIPlugin.getPluginId()+".tmlo0001");

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_viewer.getControl(),
			LogUIPlugin.getPluginId()+".tmlo0002");
		
		return result;
	}
	
	/**
	 * @param result
	 */
	private void createLargeLogSupport(Composite result) {
		Composite grpLargeLogSupport = new Composite(result, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		grpLargeLogSupport.setLayout(layout);
		
		_chkLargeLogSupport = new Button(grpLargeLogSupport, SWT.CHECK);
		_chkLargeLogSupport.setText(LogUIPlugin.getResourceString("STR_LARGE_LOG_SUPPORT_LBL_"));
		GridData data = new GridData();
		data.horizontalIndent = 15;
		_chkLargeLogSupport.setLayoutData(data);
		
	}

	private void createMergeGroup(Composite result){
	
		Composite grpMerge = new Composite(result, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		grpMerge.setLayout(layout);
			
		_chkMerge = new Button(grpMerge, SWT.CHECK);
		_chkMerge.setText(LogUIPlugin.getResourceString("STR_MERGE_LBL_"));
		GridData data = new GridData();
		data.horizontalIndent = 15;
		_chkMerge.setLayoutData(data);
	
	}
	
	private void createSpace(Composite parent){
		Label space = new Label(parent, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		space.setLayoutData(data);
	}
	
	private void createDescription(Composite parent){
		_description = new Label(parent, SWT.NONE);
		GridData data = new GridData();
		data.horizontalIndent = 15;
		_description.setLayoutData(data);
	
		_description.setText(LogUIPlugin.getResourceString("STR_MERGETREE_DESC"));
		//_description.setVisible(false);
	}
	private void createTreeViewer(Composite result){
					
		_viewer = new TreeViewer(result);
		_viewer.setContentProvider(new TraceMergeUIContentProvider());
		_viewer.setLabelProvider(new PDLabelProvider());
		_viewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
	
		GridData tree = GridUtil.createFill();
		tree.widthHint = 200;
		tree.horizontalIndent = 15;
	    _viewer.getTree().setLayoutData(tree);
		_viewer.getTree().setEnabled(false);
	
	}
	
	public Tree getTree(){
		return _viewer.getTree();
	}
	
	public Button getMergeButton(){
		return _chkMerge;
	}
		
	public Label getDescription(){
		return _description;
	}
	
	public void selectMergedAgent(TRCAgentProxy mergedAgent){
		_viewer.setExpandedState(mergedAgent.getProcessProxy(), true);
		_viewer.setSelection(new StructuredSelection(mergedAgent));
	}
	
	class TraceMergeUIContentProvider implements IStructuredContentProvider, ITreeContentProvider{
	 	
	 	public TraceMergeUIContentProvider(){ 	
	 	}
	 	
		public Object[] getElements(Object inputElement) {

			List list = new ArrayList();
			if(inputElement instanceof IWorkspaceRoot){
				getProcessesFromMemory(list);	
				getProcessesFromWorkspace(list, inputElement);
			}
			else if(inputElement instanceof TRCProcessProxy){
				list.addAll(HyadesUtil.getLogAgents((TRCProcessProxy)inputElement));
			}
			return list.toArray();
		}

		private void getProcessesFromMemory(List list){
			EList resources = UIPlugin.getDefault().getResourceSet().getResources();
			int size = resources.size();
			for(int i=0; i<size;i++){
				Resource res = (Resource)resources.get(i);
				EList ext = res.getContents();
				Iterator iter = ext.iterator();
				while (iter.hasNext())
				{
					Object obj = iter.next();
					if (obj instanceof TRCMonitor){
						_monitorsList.add(obj);
						list.addAll(HyadesUtil.getProcesses((TRCMonitor)obj));
					}					
				}
			}
			
		}
		
		private void getProcessesFromWorkspace(List list, Object inputElement){
			IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
			ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
			for(int idx=0; idx< projects.length; idx++){
				List resources = HyadesUtil.getResources(projects[idx]);
				for(int j = 0; j<resources.size(); j++){
					IResource resource = (IResource)resources.get(j);
					if(resource!=null){
						List monitors = HyadesUtil.getMonitors(resource, resourceSet);
						int monitors_size = monitors.size();
						for(int k=0; k < monitors_size; k++){ 	
							TRCMonitor monitor = (TRCMonitor)monitors.get(k);
							if(monitor!=null && !_monitorsList.contains(monitor)){
								 list.addAll(HyadesUtil.getProcesses(monitor));
							}
							else{
								continue;
							}
						}							
					}
					else{
						continue;
					}
				}
			}
		
		}
		
		
		public void dispose() {

		}

		public void inputChanged(
			Viewer viewer,
			Object oldInput,
			Object newInput) {

		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement) {

			return getElements(parentElement);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
		 */
		public Object getParent(Object element) {

			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element) {

			if(element instanceof TRCAgentProxy){
				return false;
			}
			return true;
		}

	}
	
	public boolean getLargeLogSupport() {
		if(_chkLargeLogSupport!=null)
			return _chkLargeLogSupport.getSelection();
		else
			return false;
	}

	/**
	 * @param b
	 */
	public void setUseLargeLogSupport(boolean b) {
		if(_chkLargeLogSupport!=null)
			_chkLargeLogSupport.setSelection(b);
	}

}
