/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.views;


import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.SymptomDBDialog;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler.ConfigurationElement;
import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogPaneTreeViewer extends TreeViewer {

    private LogViewerUI _logViewUI = null;
    private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
    protected Action _updateAction;
    
    //-------------------------------
    // UpdateAction popup action
    //-------------------------------	
    class UpdateAction extends Action {
        public UpdateAction(String name) {
            super(name);

            WorkbenchHelp.setHelp(this, ContextIds.ACTLOG_VIEW_POPUP_REFRESH);
        }

        /**
         * Invoked when an action occurs.
        	* Argument context is the Window which contains the UI from which this action was fired.
         * This default implementation prints the name of this class and its label.
         */
        public void run() {
            _logViewUI.update();
        }
    }
    public LogPaneTreeViewer(LogViewerUI logViewUI, Composite parent, String role) {
        super(parent);

        _logViewUI = logViewUI;

        _updateAction = new UpdateAction(LogUIPlugin.getResourceString("REFRESH_VIEWS"));        
    }
    
    // Attaches a context menu listener to the table.
    public void setMenuListener(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu(getControl());
        getControl().setMenu(menu);
    }

    public void addSelectionListener(SelectionListener listener) {
        ((Tree) getControl()).addSelectionListener(listener);
    }

    public void fillContextMenu(IMenuManager menu) {

        ISelection sel = getSelection();

        if (sel instanceof IStructuredSelection) {

            if (!sel.isEmpty())
                updateMenu(menu, ((IStructuredSelection) sel).getFirstElement());
        }

        menu.add(new Separator());
        menu.add(_updateAction);
        menu.add(new Separator());
	        
		 //popup menu contribution
		 menu.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));	        
    }

    public void updateMenu(IMenuManager menu, Object logObject) {

        final ISelection sel = getSelection();

        if (sel instanceof IStructuredSelection) {

            //Action analyzeAction = new AnalyzeAction(LogUIPlugin.getResourceString("STR_ANALYZE_ACT"), logType, false);

            //menu.add(analyzeAction);
			MenuManager manager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ACT"));
            menu.add(manager);
            fillMenu(manager, logObject);
            //WorkbenchHelp.setHelp(analyzeAction, ContextIds.ACTLOG_VIEW_POPUP_ANALYZE);
            menu.add(new Separator());
            			
            //Action analyzeAllAction = new AnalyzeAction(LogUIPlugin.getResourceString("STR_ANALYZE_ALL_ACT"), logType, true);
           // menu.add(analyzeAllAction);
		   manager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ALL_ACT"));
           menu.add(manager);
           fillMenu(manager);
        }
    }

 public void dispose(){ 
	
	List logAnalyzers = eph.getLogAnalyzers();
	for (Iterator iter = logAnalyzers.iterator(); iter.hasNext();) {
		ILogAnalyzer element = ((ConfigurationElement) iter.next()).getAnalyzer();
		element.unloadDatabase();
	}			
 }
 
 private void fillMenu(IContributionManager innerMgr){
   
   innerMgr.removeAll();
   List logAnalyzers = eph.getLogAnalyzers();
   if(logAnalyzers!=null){
	   for (Iterator iter = logAnalyzers.iterator(); iter.hasNext();) {
		   ConfigurationElement config = (ConfigurationElement) iter.next();
		   Action analyzeAction = new AnalyzeAction(config.getName(), config.getAnalyzer(), true);
		   innerMgr.add(analyzeAction);		
	   }
   }	 
 
 }
 
 private void fillMenu(IContributionManager innerMgr, Object logObject) {
	
	innerMgr.removeAll();
	List logAnalyzers = eph.getLogAnalyzer(logObject);
	if(logAnalyzers!=null){
		for (Iterator iter = logAnalyzers.iterator(); iter.hasNext();) {
			ConfigurationElement config = (ConfigurationElement) iter.next();
			Action analyzeAction = new AnalyzeAction(config.getName(), config.getAnalyzer(), false);
			innerMgr.add(analyzeAction);		
		}
	}	 
 }

 class BasicLoadAction extends Action {

	private ILogAnalyzer logAnalyzer = null;
	private boolean reload = false;
	
	public BasicLoadAction(String label, ILogAnalyzer logAnalyzer){
		super(label);
		this.logAnalyzer = logAnalyzer;		
	}

	public ILogAnalyzer getLogAnalyzer(){
		return logAnalyzer;
	}
	
	public boolean getReload(){
		return reload;
	}
	
	public void setReload(boolean newVal){
		reload = newVal;
	}
	    
    public void run() {

        BusyIndicator.showWhile(null, new Runnable() {

            public void run() {

                logAnalyzer.loadDatabase();

                if (logAnalyzer.errorMsg() != null) {
                    MessageDialog.openError(getControl().getShell(), LogUIPlugin.getResourceString("STR_LOG_MSG"), logAnalyzer.errorMsg());
                    return;
                }
            }

        });
    }
    public boolean isEnabled() {
        return true;
    }    
 }
 
 class LoadAction extends BasicLoadAction{

	public LoadAction(String label, ILogAnalyzer logAnalyzer){
		super(label, logAnalyzer);
		
	}
	
	public void run(){
        
        SymptomDBDialog dialog = new SymptomDBDialog(getControl().getShell(), LogUIPlugin.getResourceString("STR_SYMPTOM_DB_DLG_TITLE"), null);
        setReload(false);
        dialog.open();

        if (dialog.getReturnCode() == Window.OK) {
        	setReload(true);
        }	
	}
 	
 }
 
 
 class AnalyzeAction extends LoadAction{
 	
	boolean analyzeAll = false;
	private IStructuredSelection sel;
	private ILogAnalyzer aLogAnalyzer;
		
	public AnalyzeAction(String label, ILogAnalyzer logAnalyzer){
		super(label, logAnalyzer);
	}
	
	public AnalyzeAction(String label, ILogAnalyzer logAnalyzer, boolean analyzeAll){
		super(label, logAnalyzer);
		this.analyzeAll = analyzeAll; 
		
	}

	public IStructuredSelection getSelection(){
		
		if(analyzeAll){
			sel =  new StructuredSelection(((LogContentProvider)getContentProvider()).getChildren(getInput()));
		}
		else
			sel = (IStructuredSelection)LogPaneTreeViewer.this.getSelection();
		
		return sel;			
	}

    public void run() {
                		
		Runnable analyze = new Runnable(){

			public void run() {
	
				getLogAnalyzer().loadDatabase();
				if(getLogAnalyzer().errorMsg()==null){	
					getLogAnalyzer().analyze(getSelection());
				}
			}
		};
		BusyIndicator.showWhile(null, analyze);
		if (getLogAnalyzer().errorMsg()!=null &&
			getLogAnalyzer().errorMsg().equals(LogUIPlugin.getResourceString("STR_NO_SYMPTOM_DB_ERROR"))){ 
			if(MessageDialog.openQuestion(getControl().getShell(), LogUIPlugin.getResourceString("STR_LOG_MSG"), getLogAnalyzer().errorMsg())){
				super.run();					
				if(getReload()){	
					BusyIndicator.showWhile(null, analyze);
				}

			}
			else{	
				return;
			}
		}
            
	   //Refresh after analyzing all selected records.
		refresh();

		//Need to send an event so that the Analysis Result area will be updated.
		Event event = new Event();
		event.item = ((Tree) getControl()).getSelection()[0];
		getControl().notifyListeners(SWT.Selection, event);
	}
        
 }
 
}
