/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogSetUI implements Listener{

	private Text txtLogSetName;

	private LogSetDialog dialog;
	private List lstLogSets;
	private Button btnRename;
	private Button btnRemove;
	private Label lblError;

	/**
	 * 
	 */
	public LogSetUI(LogSetDialog dialog) {
		this.dialog = dialog;		
	}
	
	public void createContent(Composite parent, int type){
		
		Composite result = new Composite(parent, SWT.NONE);
		GridData data = GridUtil.createFill();
		data.widthHint = 400;
		result.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		
		result.setLayout(layout);
			
		createWidgets(result, type);	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
	 */
	public void handleEvent(Event event) {
		
		if(event.widget==txtLogSetName){
			if(txtLogSetName.getText().length()==0 || dialog.getLogSets().get(txtLogSetName.getText())!=null){
				dialog.setOKButtonEnabled(false);				
			}else{
				dialog.setOKButtonEnabled(true);
			}
			if(dialog.getLogSets().get(txtLogSetName.getText())!=null){
				lblError.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOGSET_ERR"));
			}else{
				lblError.setText("");
			}
			dialog.setDefaultLogSet(txtLogSetName.getText());
			
		}else if(event.widget==lstLogSets){
			if(!lstLogSets.getItem(lstLogSets.getSelectionIndex()).equals(dialog.getDefaultLogSet())){
				dialog.setLogSetSelectionChanged(true);
			}
			dialog.setDefaultLogSet(lstLogSets.getItem(lstLogSets.getSelectionIndex()));
						
		
		}else if(event.widget==btnRename){
			LogSetDialog dlg = new LogSetDialog(dialog.getShell(), ImportLogWizardPage.RENAME_LOGSET);
			dlg.setLogSets(dialog.getLogSets());
			dlg.setLogSetName(lstLogSets.getItem(lstLogSets.getSelectionIndex()));
			int i = lstLogSets.getSelectionIndex();
			if(dlg.open()==Window.OK){				
				renameLogSet(i, lstLogSets.getItem(i), dlg.getDefaultLogSet());
							
			}
		}else if(event.widget==btnRemove){
			
			Map logSets = dialog.getLogSets();		
			String logSet = lstLogSets.getItem(lstLogSets.getSelectionIndex());
			
			logSets.remove(logSet);
			lstLogSets.remove(lstLogSets.getSelectionIndex());

			if(logSet.equals(dialog.getDefaultLogSet())){
				if(lstLogSets.getItemCount()>0){
					dialog.setDefaultLogSet(lstLogSets.getItem(0));
				}else{
					dialog.setDefaultLogSet(null);
				}
				dialog.setLogSetSelectionChanged(true);					
			}
			if(logSet.equals(dialog.getCurrentLogSet())){
				dialog.setCurrentLogSetChanged(true);
			}
		}
		updateButtons();
	}
	
	private void updateButtons(){
		if(btnRemove!=null && btnRename!=null){	
			if(lstLogSets.getSelectionIndex()<0){
				btnRemove.setEnabled(false);
				btnRename.setEnabled(false);
			}else{
				btnRemove.setEnabled(true);
				btnRename.setEnabled(true);
			}				
		}
	}
	
	private void createWidgets(Composite result, int type){
		
		switch (type){

			case ImportLogWizardPage.NEW_LOGSET: 
				createNewLogSetUI(result);
				break;
			case ImportLogWizardPage.OPEN_LOGSET:
				createOpenLogSetUI(result);
				break;
			case ImportLogWizardPage.EDIT_LOGSET:
				createEditLogSetUI(result);
				break;
			case ImportLogWizardPage.RENAME_LOGSET:
				createRenameLogSetUI(result);

		}
	}

    private void createNewLogSetUI(Composite result){
		
		Label desc = new Label(result, SWT.WRAP);
		GridData data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		desc.setLayoutData(data);
		desc.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_MSG"));
		
		createSpace(result);
		
		Label log_set = new Label(result, SWT.NONE);
		data = new GridData(GridData.BEGINNING);
		log_set.setLayoutData(data);
		log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_LBL"));
		
		txtLogSetName = new Text(result, SWT.BORDER);
		data = GridUtil.createHorizontalFill();
	
		txtLogSetName.setLayoutData(data);
		
		lblError = new Label(result, SWT.WRAP);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		lblError.setLayoutData(data);
		lblError.setForeground(JFaceColors.getErrorText(dialog.getShell().getDisplay()));
		
		txtLogSetName.addListener(SWT.Modify, this);		
    }
    
	private void createRenameLogSetUI(Composite result){
		
		Label log_set = new Label(result, SWT.NONE);
		GridData data = new GridData(GridData.BEGINNING);
		log_set.setLayoutData(data);
		log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_LBL"));
		
		txtLogSetName = new Text(result, SWT.BORDER);
		data = GridUtil.createHorizontalFill();
	
		txtLogSetName.setLayoutData(data);
		txtLogSetName.setText(dialog.getLogSetName()!=null ? dialog.getLogSetName():"");	
		txtLogSetName.selectAll();
		
		lblError = new Label(result, SWT.WRAP);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		lblError.setLayoutData(data);
		lblError.setForeground(JFaceColors.getErrorText(dialog.getShell().getDisplay()));
		
		txtLogSetName.addListener(SWT.Modify, this);
		
	}

	private void createOpenLogSetUI(Composite result){
		
		Label desc = new Label(result, SWT.WRAP);
		GridData data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		desc.setLayoutData(data);
		desc.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_MSG"));
		
		createSpace(result);
		
		Label log_set = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();		
		log_set.setLayoutData(data);
		log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SETS"));

		lstLogSets = new List(result, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		lstLogSets.setLayoutData(data);
		loadLogSetsList();
		
		lstLogSets.addListener(SWT.Selection, this);		
 
	}
	
	private void createEditLogSetUI(Composite result){

		Label desc = new Label(result, SWT.WRAP);
		GridData data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		desc.setLayoutData(data);
		desc.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_MSG"));

		createSpace(result);
			
		Label log_set = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;		
		log_set.setLayoutData(data);
		log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SETS"));
		
		lstLogSets = new List(result, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		data = GridUtil.createHorizontalFill();
		data.widthHint = 300;
		lstLogSets.setLayoutData(data);
		
		Composite buttons = new Composite(result, SWT.NONE);
		result.setLayoutData(GridUtil.createFill());
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		buttons.setLayout(layout);
		
		btnRename = new Button(buttons, SWT.PUSH);
		btnRename.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_RENAME_SET"));
		GridData btnData = GridUtil.createHorizontalFill();
		btnData.widthHint = 90;
		btnData.horizontalAlignment = GridData.CENTER;
		btnRename.setLayoutData(btnData);		
		
		btnRemove = new Button(buttons, SWT.PUSH);
		btnRemove.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE_SET"));
		btnData = GridUtil.createHorizontalFill();
		btnData.widthHint = 90;
		btnData.horizontalAlignment = GridData.CENTER;
		btnRemove.setLayoutData(btnData);
					
		loadLogSetsList();
		
		lstLogSets.addListener(SWT.Selection, this);
		btnRename.addListener(SWT.Selection, this);
		btnRemove.addListener(SWT.Selection, this);   
		
		updateButtons();
		
	}
	
	private void loadLogSetsList(){
		java.util.Set logSets = dialog.getLogSets().keySet();		
		
		for (Iterator iter = logSets.iterator(); iter.hasNext();) {
			lstLogSets.add((String)iter.next());		
		}
	}	
	
	private void createSpace(Composite parent){
		Label space = new Label(parent, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		space.setLayoutData(data);
	}
	
	private void renameLogSet(int i, String oldName, String newName){

		Map logSets = dialog.getLogSets();
		java.util.List logList = (java.util.List)logSets.get(oldName);		
		logSets.remove(oldName);
		logSets.put(newName, logList);
		lstLogSets.remove(i);
		lstLogSets.add(newName, i);
		if(oldName.equals(dialog.getDefaultLogSet())){
			dialog.setDefaultLogSet(newName);
		}
		if(oldName.equals(dialog.getCurrentLogSet())){
			dialog.setCurrentLogSetChanged(true);
		}
	}
	
	public String getLogSetName(){
		
		if(txtLogSetName!=null){
			return txtLogSetName.getText();
		}
		else{
			if(lstLogSets!=null){
				return lstLogSets.getItem(lstLogSets.getSelectionIndex());
			}			
		}
		return null;
	
	}
	
	public String[] getLogSets(){
		
		if(lstLogSets!=null){
			return lstLogSets.getItems();
		}
		
		return null;
	}
	
	public void setTextSelection(){
		txtLogSetName.selectAll();
	}
	
}
