/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Nov 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class NewCorrelationWizard extends Wizard implements INewWizard {

	protected LogSelectionWizardPage selPage;
	protected CorrelationSelectionWizardPage corrPage;
	private IStructuredSelection sel;
	protected CorrelationContainerProxy correlationContainerProxy;
	private IWorkbench workbench;	
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		
		BusyIndicator.showWhile(Display.getDefault(), new Runnable(){	
			public void run(){
				correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(corrPage.getCorrelation(),  selPage.getLogFiles(), selPage.getName());				
			}			
		});
			
		if(correlationContainerProxy!=null){
			
			try {
				IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
				if(page != null && !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) ){
					IAdaptable element =
					ResourcesPlugin.getWorkspace().getRoot();
					if (element != null)
						page =
							workbench.showPerspective(
								PDPerspective.ID_TRACE_PERSPECTIVE,
								workbench.getActiveWorkbenchWindow(),
								element);
				}
				if(page!=null){					
					final IViewPart part = page.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
					if(part!=null){
										
						Display.getDefault().asyncExec(new Runnable()
						{
							public void run()
							{
								((LogNavigator)part).selectReveal(new StructuredSelection(correlationContainerProxy));
							}
						});						
					}
				}
			} catch (Exception e) {				
				e.printStackTrace();
			}
		}
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		store.setValue("corr_nr",store.getInt("corr_nr")+1);
		
		return true;	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		sel = selection;
		this.workbench = workbench;		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {


		setWindowTitle(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"));
		super.addPages();
		selPage = new LogSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), sel);
		addPage(selPage);
			
		corrPage = new CorrelationSelectionWizardPage(LogUIPlugin.getResourceString("STR_NEW_CORR_WIZARD_TITLE"), CorrelationHelper.getInstance().getCorrelationExtensions());
		addPage(corrPage);		
	}
	
}
