/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.actions.ActionGroup;

import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * Superclass of all actions to be added to the navigator.
 * 
 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup} class.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public abstract class NavigatorActionGroup 
extends ActionGroup implements IDisposable
{
	/**
	 * The navigator.
	 */
	private INavigator navigator;
	
	/**
	 * Constructs a new navigator action group and creates its actions and 
	 * action groups.
	 * @param navigator the resource navigator
	 */
	public NavigatorActionGroup(INavigator navigator)
	{
		this.navigator = navigator;
		createActions();
		createActionGroups();
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	public void dispose()
	{
		navigator = null;
		super.dispose();
	}

	/**
	 * Returns the navigator.
	 */
	public INavigator getNavigator()
	{
		return navigator;
	}
	
	/**
	 * Handles a key pressed event by invoking the appropriate action.
	 * Does nothing by default.
	 */
	public void handleKeyPressed(KeyEvent event)
	{
	}

	/**
	 * Creates the actions contained in this action group.
	 */
	abstract protected void createActions();
	
	/**
	 * Creates the actions groups contained in this action group.
	 */
	 protected void createActionGroups()
	 {
	 }
	
	
	/**
	 * Runs the default action in the group.
	 * Does nothing by default.
	 * @param selection the current selection
	 */
	public void runDefaultAction(IStructuredSelection selection)
	{
	}
}
