/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.hyades.ui.internal.util.ContextIds;

/**
 * Action to set the criteria of a 
 * {@link org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter}.  Each instance
 * of this class is associated to a specific criteria.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public class NavigatorSorterAction 
extends NavigatorAction
{
	private int criteria;
	
	/**
	 * Constructor for NavigatorSorterAction
	 * @param navigator
	 * @param label
	 */
	public NavigatorSorterAction(INavigator navigator, String label, int criteria)
	{
		super(navigator,label);
		this.criteria = criteria;
		WorkbenchHelp.setHelp(this, HyadesUIPlugin.getID() + ContextIds.ACT_NAVIGATORS);						
	}
	
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		ViewerSorter sorter = getNavigator().getViewer().getSorter();
		if(sorter instanceof NavigatorViewerSorter)
			((NavigatorViewerSorter)sorter).setCriteria(criteria);
	}
}
