/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.test.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.common.internal.editor.TestSuiteForm;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitForm 
extends TestSuiteForm
{
	private SourceInfoSection sourceInfoSection;
	
	/**
	 * Constructor for JUnitForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public JUnitForm(JUnitEditorExtension junitEditorExtension, WidgetFactory widgetFactory)
	{
		super(junitEditorExtension, widgetFactory);
		setHeadingText(TestJavaPlugin.getString("EDT_JUNIT_TTL"));
	}

	protected JUnitForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}


	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		sourceInfoSection.dispose();
	}
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_FORM_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.JUNIT_FORM);
				break;
				
			case HELP_TEST_CASE_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.JUNIT_FORM_METHOD);
				break;
				
			case HELP_TYPE_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.JUNIT_FORM_TYPE);
				break;

			case HELP_FILE_CASE_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.JUNIT_FORM_NAME);
				break;
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createTestCaseElementsSectionControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection)
	 */
	protected Control createTestCaseElementsSectionControl(Composite parent, NamedElementsSection testCaseElementsSection)
	{
		return testCaseElementsSection.createControl(parent, factory, TestJavaPlugin.getString("EDT_JUNIT_TST_METHS"), TestJavaPlugin.getString("EDT_JUNIT_TST_METHS_DSC"));
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createLeftColumnControls(org.eclipse.swt.widgets.Composite)
	 */
	protected void createLeftColumnControls(Composite parent)
	{
		super.createLeftColumnControls(parent);
		
		sourceInfoSection = new SourceInfoSection(this);
		sourceInfoSection.setHeaderText(TestJavaPlugin.getString("SRC_INFO_TTL"));
		Control control = sourceInfoSection.createControl(parent, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#load()
	 */
	public void load()
	{
		super.load();
		sourceInfoSection.setInput(getTestSuite());
	}
}
