/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestCaseNewWizard;
import org.eclipse.hyades.test.manual.TestManualImages;
import org.eclipse.hyades.test.manual.TestManualPlugin;

/**
 * Wizard for the JUnit Test Case
 * 
 * @author marcelop
 * @since 0.3.0
 */
public class ManualTestCaseNewWizard
extends TestCaseNewWizard
{
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public ManualTestCaseNewWizard()
	{
		super();

		setWindowTitle(TestManualPlugin.getString("ACT_TST_CASE_ADD_TIP"));
		setDefaultPageImageDescriptor(TestManualImages.INSTANCE.getImageDescriptor(TestManualImages.IMG_WIZBAN_NEW_MANUAL_TESTCASE));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.MANUAL_TEST_CASE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		ITestSuite testSuite = (ITestSuite)getSelection().getFirstElement();
		String label = testSuite.getName();

		getAttributeWizardPage().setTitle(TestManualPlugin.getString("ACT_TST_CASE_ADD_TIP"));
		getAttributeWizardPage().setDescription(TestManualPlugin.getString("WIZ_TST_CASE_GEN_PG_ATT_DSC", label));
		addPage(getAttributeWizardPage());
	}
}
