/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Oct 15, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author sdirkers
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.test.http.runner.internal.exec;

import org.eclipse.hyades.test.http.runner.HttpResourceBundle;

public class Cookie {
        /**
         * Basic constructor
         *
         */
        public Cookie() {
                cookie = null;
                cname = null;
                cval = null;
                sslflag = false;
                expires = null;
                version = 0;
                domain = null;
                path = null;
                isip = false;
        }
        /**
         *  Constructor from Editing manually:
         * @param name   Name of NAME=VALUE for cookie
         * @param val    Value of NAME=VALUE for cookie
         * @param sslflg  secure flag
         * @param exp    Expires string
         * @param dom    Host or Domain
         * @param pth    Path on Host or Domain
         * @param vers   Version ( presently only 0)
         * @param ipaddrf  Flag if this is an ipaddr domain
         */
        public Cookie(String name, String val, boolean sslflg, String exp, String dom, String pth, int vers, boolean ipaddrf)
        {
          if (name != null)
             cname = new String(name);
          else {
          	  name = null;
          	  System.out.println(HttpResourceBundle.getInstance().getString("COOKIES_NONAME"));
          }
          
          if ( val != null)
             cval = new String(val);
          if (name != null )
             cookie = new String(name+ "=" +val);
          else cval = null;   
          sslflag = sslflg;
          if (exp != null)
             expires = new String(exp);
          else expires = null;
          if ( dom != null)   
            domain = new String(dom);
          else {
          	  System.out.println(HttpResourceBundle.getInstance().getString("COOKIES_NOHOST"));
          	   domain = null;
          }
          if ( pth != null)   
             path = new String(pth);
          else  {
          	System.out.println(HttpResourceBundle.getInstance().getString("COOKIES_NOPATH"));
          	path =null;
          }
          version = vers;   // only zero allowed
          isip = ipaddrf;

        
        }

        /**
         *  Separates cookie into name and value
         * @param cook  The entire NAME=VALUE; string of cookie
         * @return
         */
        public int sepcookie(String cook){

                int j = cook.indexOf('=');
                if (j > 0 && j < cook.length()-1)
                  {
                        cname = new String(cook.substring(0,j));
                        cval = new String(cook.substring(j+1));
                        return 0;
                  }
                else
                  {
                          // not a valid cookie
                        cname = null;
                        cval = null;
                        cookie = null;
                        return 1;
                  }

        }

        public String getcookie(){
                return cookie;
        }

        public int setcookie(String cook){
                int rc = 0;
                cookie = new String(cook);
            rc = sepcookie(cook);
            return rc;

        }

        public void setcookie(String name, String value)
        {
                cname = new String(name);
                cval = new String(value);
                cookie = new String (name + "=" + value);
        }

        public void setsslflag(boolean flag)
        {
          sslflag = flag;
        }

        public boolean getsslflag()
        {
                return sslflag;
        }

        public String getexpires(){
                return expires;
        }

        public void setexpires(String exp){
                expires = new String(exp);
        }

        public int getversion() {
                return version;
        }
        public void setversion(int vers) {
                version = vers;
        }

        public String getdomain() {
                return domain;
        }
        public void setdomain(String dom) {
                domain = new String(dom);
        }
        public String getpath() {
                return path;
        }
        public void setpath(String p) {
                path = new String(p);
        }


        public String cookie;
        public String cname;
        public String cval;
    public boolean sslflag;
    public String expires;
    public int version;
    public String domain;
    public String path;
    public boolean isip;


}
