package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Interface for logging (e.g. writing) APIs for all Java primitives and 
 * <code>java.lang.Object</code>s.
 *  
 * 
 * @author      Paul Slauenwhite
 * @version     March 7, 2003
 * @deprecated  Replaced by Apache Commons' org.apache.commons.logging.Log interface. 
 */
public interface ILogger {

	/**
	 *	Log a boolean message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(boolean msg);

	/**
	 *	Log a char message.
	 *
	 *  @param msg The message to be logged.
	 */
	public void write(char msg);

	/**
	 *	Log a byte message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(byte msg);

	/**
	 *	Log a short message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(short msg);

	/**
	 *	Log an int message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(int msg);

	/**
	 *	Log a long message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(long msg);

	/**
	 *	Log a float message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(float msg);

	/**
	 *	Log a double message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(double msg);

	/**
	 *	Log an Object message.
	 *
	 *	@param msg The message to be logged.
	 */
	public void write(Object obj);
}
