/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.util;

import org.w3c.dom.Element;

/**
 * This interface defines a migrator class to migrate a component configuration
 * from one version to another.
 */
public interface IComponentMigrator {
	
	/**
	 * Migrate method
	 * 
	 * @param oldConfiguration
	 * @return new configuration
	 * @throws AdapterMigrationException
	 */
	
	public Element migrate(Element oldConfiguration) throws AdapterMigrationException;

}
