/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.ui.IWorkbenchPart;

/**
 * This class provides basics to Interaction UML2 Sequence Diagram loaders without messages.
 */
public abstract class NoMessageInteractions extends BaseTraceInteractions {

	/**
	 * Implementation of IUml2SDLoader
	 */
	public void onSetViewer() {
	}

	private HashMap instancesMap;
	private TraceLifelineDraft currentTraceLifeline;
	private int lastEventOccurrence;
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#fillPage()
	 */
	public void fillPage(TraceInteractionUpdate update) {
//System.err.println("fillPage("+currentMofObjectFromPDProjectExplorer+")");
		traceThreadMap = new HashMap();
		traceThreadList = new ArrayList();
		instancesMap = new HashMap();
		currentTraceLifeline = null;
		lastEventOccurrence = 1;
		currentProcesses.init();
		for (TRCFullMethodInvocation methodInvocation = currentProcesses.consumeMethodInvocation();
	 	 	 methodInvocation != null &&
			 !monitor.isCanceled();
	 	 	 methodInvocation = currentProcesses.consumeMethodInvocation()) {
			getTraceLifelineDraftForMethodInvocation(frame, methodInvocation);
		}
		if (currentTraceLifeline != null) {
			currentTraceLifeline.setEnd(lastEventOccurrence++);
			setExecutionOccurence(currentTraceLifeline);
			createSyncMessageReturn(currentTraceLifeline, null);
		}
		traceThreadMap = null;
		traceThreadList = null;
		instancesMap = null;
		currentTraceLifeline = null;
	}
	
	protected void getTraceLifelineDraftForMethodInvocation
											(Frame f, TRCFullMethodInvocation mi) {
		EObject obj = getLifelineEObjectFromMethodInvocation(mi);
		TraceLifelineDraft draft = (TraceLifelineDraft)instancesMap.get(obj);
		if (draft != currentTraceLifeline) {
			if (currentTraceLifeline != null) {
				currentTraceLifeline.setEnd(lastEventOccurrence++);
				setExecutionOccurence(currentTraceLifeline);
				createSyncMessageReturn(currentTraceLifeline, mi);
			}
		}
		if (draft == null) {
			draft = new TraceLifelineDraft();
			instancesMap.put(obj, draft);
			Lifeline lifeline = new Lifeline();
			draft.setLifeline(lifeline);
			lifeline.setName(getLifeLineTitle(obj, currentProcesses.size() > 1));
			lifeline.setCategory(getLifeLineCategory(obj));
			f.addLifeLine(lifeline);
		}
		if (draft != currentTraceLifeline) {
			draft.setMethodInvocation(mi);
			draft.setStart(lastEventOccurrence++);
			createSyncMessage(draft);
			currentTraceLifeline = draft;
		}
	}
	
	/**
	 * @param draft
	 */
	protected void createSyncMessage(TraceLifelineDraft draft) {
		SyncMessage sm = new SyncMessage();
		draft.getLifeline().setCurrentEventOccurrence(draft.getStart());
		sm.setEndLifeline(draft.getLifeline());
		sm.setTime(getEntryTime(draft.getMethodInvocation()));
		frame.addMessage(sm);
	}

	/**
	 * 
	 */
	protected void createSyncMessageReturn(TraceLifelineDraft draft, TRCFullMethodInvocation newOne) {
		SyncMessageReturn smr = new SyncMessageReturn();
		draft.getLifeline().setCurrentEventOccurrence(draft.getEnd());
		smr.setStartLifeline(draft.getLifeline());
		if (newOne != null) {
			if (newOne.getProcess() == draft.getMethodInvocation().getProcess()) {
				smr.setTime(getEntryTime(newOne));
			} else {
				smr.setTime(TraceInteractionUtils.getAbsoluteExitTime(draft.getMethodInvocation()));
			}
		} else {
			smr.setTime(lastTime);
		}
		frame.addMessage(smr);
	}
	
	protected abstract double getEntryTime(TRCFullMethodInvocation mi);
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#updateSD(org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate)
	 */
	protected void updateSD(TraceInteractionUpdate update) {
		// No pages, nor filters, neither collapsing: nothing to do
	}

	protected double lastTime;
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#computeModel()
	 */
	protected void computeModel() {
		// currentProcesses.init(); // this would be mandatory if we'd like to do something
		lastTime = 0;
		for (Iterator i = currentProcesses.iterator(); i.hasNext(); ) {
			TRCProcess process = (TRCProcess)((TraceProcess)i.next()).getProcess();
			double absoluteEntryTime = TraceInteractionUtils.getAbsoluteEntryTime(process);
			double absoluteExitTime = TraceInteractionUtils.getAbsoluteExitTime(process);
			if (lastTime < absoluteExitTime) {
				lastTime = absoluteExitTime;
			}
		}
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#externalExtendedSelectionChanged(org.eclipse.ui.IWorkbenchPart, java.lang.Object, org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate)
	 */
	protected boolean externalExtendedSelectionChanged(IWorkbenchPart part,
													   Object selection,
													   TraceInteractionUpdate update) {
		// Nothing to do
		return false;
	}

}
