/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;

/**
 * This class aims to populate a Process Interaction UML2 Sequence Diagram.
 */
public class ProcessInteractions extends NoMessageInteractions {
	
	/**
	 * Categories:
	 * - only one for processes
	 */
	public static final int CATEGORY_PROCESS = 0;
	private static LifelineCategories[] traceCategories;
	static {
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_PROCESS] = new LifelineCategories();
		traceCategories[CATEGORY_PROCESS].setName(TraceSDPlugin.getResourceString("STR_PROCESS")); //$NON-NLS-1$
		traceCategories[CATEGORY_PROCESS].setImage(new ImageImpl(TraceSDPlugin.getResourceImage("process_obj.gif"))); //$NON-NLS-1$
	}
	
	/**
	 * @return
	 */
	protected void createFrame() {
		super.createFrame();
		frame.setLifelineCategories(traceCategories);
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#setFrameName()
	 */
	public void setFrameName() {
		frame.setName(TraceSDPlugin.getResourceString("STR_UML2SD_PROCESS_INTERACTION")); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getProcess(); // TRCProcess
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	protected int getLifeLineCategory(EObject to) {
		return CATEGORY_PROCESS;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	protected String getLifeLineTitle(EObject to, boolean long_) {
		TRCProcess process = (TRCProcess)to;
		return process.getAgent().getAgentProxy().getProcessProxy().getName()+" [Pid "+process.getPid()+"]"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_PROCESS_INTERACTION"); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.NoMessageInteractions#getEntryTime(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected double getEntryTime(TRCFullMethodInvocation mi) {
		if (mi == mi.getProcess().getInvocations().get(0)) {
			return TraceInteractionUtils.getAbsoluteEntryTime(mi.getProcess());
		} else {
			return TraceInteractionUtils.getAbsoluteEntryTime(mi);
		}
	}

}
