/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * @author jtoomey
 * @author marcelop
 */
public class JavaExecutionEnvironmentAdapter
implements IExecutionEnvironmentAdapter
{
	/**
	 * @see org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter#setupExecutionEnvironment(org.eclipse.hyades.execution.core.IExecutionEnvironment, org.eclipse.hyades.models.common.testprofile.TPFTestSuite, java.lang.String)
	 */
	public void setupExecutionEnvironment(IExecutionEnvironment executionEnvironment, TPFTestSuite testSuite, TPFTest test, TPFDeployment deployment)
		throws ClassCastException {
		List properties = ((IDeployableComponent)testSuite).getEnvironmentVariables().getProperties();
		if(properties == null)
			return;
		for(Iterator i = properties.iterator(); i.hasNext();)
		{
			IProperty prop = (IProperty)i.next();
			
			IOrderedProperty orderedProperty = executionEnvironment.getEnvByName(prop.getName());
			if(orderedProperty == null)
			{
				orderedProperty = new OrderedPropertyImpl();
				orderedProperty.setName(prop.getName());
			}
			orderedProperty.appendValue(prop.getValue());			
			executionEnvironment.setEnv(orderedProperty);
		}
	}
}
