/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * @author rduggan
 *
 * This is an adapter that knows how to configure the JavaProcessExecutorImpl
 * at runtime.
 */
public class JavaProcessExecutableObjectAdapter	implements IExecutableObjectAdapter {

	/**
	 * @see org.eclipse.hyades.execution.harness.IExecutableObjectAdapter#setupExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject, org.eclipse.hyades.models.common.testprofile.TPFTestSuite, org.eclipse.hyades.models.common.testprofile.TPFTest)
	 */
	public void setupExecutableObject(IExecutableObject execObj, TPFTestSuite suite, TPFTest test, TPFDeployment deployment)	throws ClassCastException {
			/* Read the classname of the test out of the test suite */
			ITestSuite facadeSuite = (ITestSuite) suite;
			String testID=test.getId();
			String testClass = facadeSuite.getImplementor().getResource();
			
			// Get the number of users from the CFGInstance
			int nusers = 1;
			try {
				CFGInstance cfg = (CFGInstance) suite.getInstances().get(0);
				nusers = cfg.getMaxCount();
			} catch (Exception e) {
				nusers = 1;
			}
		
			/* The arguments to the JVM is simply the classname */
			((JavaProcessExecutableObjectStub)execObj).setArgs("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8005 " + "-Dhyades.loadtest.nusers=" + nusers + " org.eclipse.hyades.test.java.runner.HyadesJUnitRunner "+testClass+" "+testID+" "+nusers);
		    
		    ((JavaProcessExecutableObjectStub)execObj).setTestID(test.getId());
		    ((JavaProcessExecutableObjectStub)execObj).setSuiteID(suite.getId());
	}

}
