/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.harness;
import java.net.InetAddress;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
/**
 * @author amathur
 * @author ejessee
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class XMLExecutionDataProcessor
	extends XMLLoader
	implements DataServerListener, IExecutionHarnessDataProcessor {
		
	private final String START_TAG = "<EXECUTION>";
	private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
	public static final String IID = "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
	private ITest test = null;
	private Agent controlAgent = null;
	private Process process = null;

	private String hostName;
	private String executionResultName;
	private String executionResultLocation;
	private String portNumber;
	/**
	 * XMLDataProcessor constructor comment.
	 */
	public XMLExecutionDataProcessor() 
	{
	 
		super((TRCMonitor) null);
		
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLLoader#isIgnoredElement()
	 */
	protected boolean isIgnoredElement() {
		if (startDocument) {
			if (currentElementName == null) {
				return true;
			}
			if (currentElementName.equals("EXECUTION")) {
				return true;
			}
			else {
				startDocument = false;
			}
		}
		return false;
	}
	
	protected boolean isValidTag(String buf) {
		if (buf.startsWith(START_TAG) || buf.startsWith(XML_VERSION_TAG))
			return false;
		else
			return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.local.common.DataServerListener#dataServerExited()
	 */
	public void dataServerExited() {		
		// Clean up the ExecutionContext
		ExecutionContext eContext = (ExecutionContext) context.getCustomData().get(ExecutionContext.root);
		eContext.cleanUp();
		cleanUp();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#incommingData(byte[], int, java.net.InetAddress)
	 */
	public void incommingData(byte[] buffer, int length, InetAddress peer) {
		try {
			super.loadEvent(buffer, length);
		}
		catch (InvalidXMLException e) {
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#incommingData(char[], int, java.net.InetAddress)
	 */
	public void incommingData(char[] buffer, int length, InetAddress peer) {
		byte[] newBuffer = new byte[length];
		for (int i = 0; i < length; i++) {
			newBuffer[i] = (byte) buffer[i];
		}
		this.incommingData(newBuffer, newBuffer.length, peer);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#invalidDataType(byte[], int, java.net.InetAddress)
	 */
	public void invalidDataType(byte[] data, int length, InetAddress peer) {
		// No use of this method	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#waitingForData()
	 */
	public void waitingForData() 
	{
		// No use of this method		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.TestExecutionHarnessDataProcessor#init(org.eclipse.hyades.models.common.facades.behavioral.ITest, org.eclipse.hyades.models.common.configuration.CFGLocation, java.lang.String, java.lang.String)
	 */
	public void init()
	{
			//		Specify the ignore for an unexpected event
			 defaultLoader =  new IgnoredXMLFragmentLoader();
		
			
			 if(!(getTest() instanceof TPFTestSuite))
			 	return;
			 	
		     // Create an execution context & add it to the Hierarchy Context					
			// This will create the root execution result/history for this execution
			 TPFTestSuite suite = (TPFTestSuite)getTest();
			 ExecutionContext eContext = new ExecutionContext(suite, suite.getId(), executionResultLocation, executionResultName);
		
			 // Add the ExecutionContext to the HierarchyContext
			 context.getCustomData().put(ExecutionContext.root, eContext);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#getConfigElement()
	 */
	public IConfigurationElement getConfigElement()
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#getID()
	 */
	public String getID()
	{
		return IID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#getName()
	 */
	public String getName()
	{
		return getClass().getName();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#setConfigElement(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public void setConfigElement(IConfigurationElement theElement)
	{

	}

	/**
	 * @return
	 */
	public ITest getTest()
	{
		return test;
	}

		
	/**
	 * @return
	 */
	public Agent getControlAgent()
	{
		return controlAgent;
	}

	/**
	 * @param agent
	 */
	public void setControlAgent(Agent agent)
	{
		controlAgent = agent;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#setInitData(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public void setInitData(
		ITest test,
		String hostName,
		String executionResultName,
		String executionResultLocation,
		String portNumber)
	{
		this.test=test;
		this.hostName = hostName;
		this.executionResultName = executionResultName;
		this.executionResultLocation = executionResultLocation;
		this.portNumber = portNumber;
		

	}

	/**
	 * @return
	 */
	public Process getProcess()
	{
		return process;
	}

	/**
	 * @param process
	 */
	public void setProcess(Process process)
	{
		this.process = process;
	}

}
