package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;
//B import com.ibm.ws.performance.threadanalyzer.tagui.TaGUI;

/*
need to make getEjbNames work
need to add support for output (and parsing) of monitor owner since it really helps 
   answer the question "why is everyone waiting?"
*/

public class DumpData implements Externalizable
{
        // 173422 changed version to 2 since field dumpParserClassname was added
        private static int _curVersion = 2;     // update when version changes (data added)
        private int _version = -1;

        public synchronized static int getID()
        {
                return ++_curID;
        }

        public DumpData()
        {
                _version = _curVersion;
                _threads = new Hashtable();
                _monitors = new Hashtable();
                _threadsByTOS = new Hashtable();
                _env  = new AnalyzerEnv();
                _fHtml = DumpParser.getArg( "reportType" ).equalsIgnoreCase( "html" );
                _threadDump = new ThreadDump();
                _displayName = null;
                _description = null;
                //dipak
				dumpParserClassName = null;
//WARNING:  This object is versioned.  If changes are made to object structure,
//                  the versioning code must be updated.
        }


        public void setDisplayName( String displayName )
        {
                _displayName = displayName;
        }

        public String getDisplayName()
        {
                return _displayName;
        }

        public String getDescription()
        {
                return _description;
        }

        public void setDescription( String description )
        {
                _description = description;
        }

		public String getDumpingJvmName() {
			return _dumpingJvmName;
		}

		public void setDumpingJvmName(String jvmName) {
			_dumpingJvmName = jvmName;
		}

		public void addDumpTextLine( String line, int lineNo )
        {
                _threadDump.addLine( line, lineNo );
        }

        public Enumeration getDumpTextEnum()
        {
                return _threadDump.getEnumerator();
        }

        public String getNextDumpTextLine( Enumeration enum )
        {
                return _threadDump.getNextLine( enum );
        }

        public void setInputFilename( String filename )
        {
                _inputFilename = filename;
        }

        public Thd addThd( String name, String threadId, String state, String priority )
        {
                Thd thd = new Thd( name, threadId, state, priority );
                _threads.put( threadId, thd );
        logDebug("[DumpData] added thread: " + name + " " + threadId);
                return thd;
        }

        public Thd getThd( String thdId )
        {
                return(Thd)_threads.get( thdId );
        }

    public int getThreadDumpSize()
    {
        return _threadDump.getSize();
    }

        public ServletThreadPool getServletThreadPool()
        {
                return new ServletThreadPool( this );
        }
        public OrbThreadPool getOrbThreadPool()
        {
                return new OrbThreadPool( this );
        }

        public OverallThreadPool getOverallThreadPool()
        {
                return new OverallThreadPool( this );
        }

        public void buildCommonTOSLists()
        {
                if ( _threadsByTOS == null )
                        _threadsByTOS = new Hashtable();
                Enumeration enum = null;
        int count = 0;
                for ( enum = _threads.keys(); enum.hasMoreElements(); )
                {
                        String sKey = (String)enum.nextElement();
                        Thd thd = getThd( sKey );
                        int ndx = Integer.parseInt( thd.getProperty( "SIGNIFICANT_TOS_NDX" ));

                        String stkKey = null;
                        if ( ndx >= 0 )
                        {
                                StkEntry se = thd.getStkEntry( ndx );

                                if ( se != null )
                                        stkKey = se.getFQName();

                                else
                                        logErr("[DumpData] ERROR: stack entry is null");
                        }
                        else
                        {
                                // case to handle Threads with empty stacks
                                stkKey = "*** WARNING *** Thread with empty stack";
                        }

                        // see if the entry exists in the hash table
                        // if so, then add the thread to the list 
                        // if not, then create a new list and add the 
                        // list to the hash table
                        Vector vec = (Vector)_threadsByTOS.get( stkKey );
                        if( thd.getName().indexOf("Signal dispatcher") == -1 )
                        {
                                if ( vec != null )
                                {
                                        vec.add( thd );
                                }
                                else
                                {
                                        vec = new Vector();
                                        vec.add( thd );
                                        _threadsByTOS.put( stkKey, vec );
                                }         
                        }
                }
                // now update all threads with next/prev information for
                // later html formatting.
        count = 0;
                for ( enum = _threadsByTOS.keys(); enum.hasMoreElements(); )
                {
                        String stkKey = (String)enum.nextElement();
                        Vector vec = (Vector)_threadsByTOS.get( stkKey );
                        Thd tPrev = null;
                        Thd tCur = null;
                        for ( int i = 0; i < vec.size(); ++i )
                        {
                                tCur = (Thd)vec.elementAt( i );
                                tCur._prevByTOS = tPrev;
                                tPrev = tCur;
                                if ( (i+1) < vec.size() )
                                        tCur._nextByTOS = (Thd)vec.elementAt( i+1 );
                        }
                }
        }


        public Monitor addMonitor( String name, int mon_type )
        {
                Monitor mon = null;
                name = name.trim();

                mon = new Monitor( name, mon_type );
                _monitors.put( name, mon );

                return mon;
        }

        public Enumeration getMonitorEnum( )
        {
                Enumeration enum = _monitors.keys();
                return enum;
        }

        public Monitor getNextMonitor( Enumeration enum )
        {
                String key = null;
                Monitor retVal = null;
                if ( enum.hasMoreElements() )
                {
                        key = (String)enum.nextElement();
                        retVal = (Monitor)_monitors.get( key );
                }
                return retVal;
        }

        public Monitor getMonitorById( int id )
        {
                Enumeration e = getMonitorEnum();
                Monitor m = getNextMonitor( e );
                while ( m != null )
                {
                        if ( m.getId() == id )
                                break;
                        m = getNextMonitor( e );
                }
                return m;
        }

        public Thd getThreadById( int id )
        {
                Enumeration e = getThreadEnum();
                Thd t = getNextThread( e );
                while ( t != null )
                {
                        if ( t.getId() == id )
                                break;
                        //System.out.println( "Thread id: " + t.getId() + " != " + id );
                        t = getNextThread( e );
                }
                //System.out.println( "getThreadById for " + id + " is returning: " + t );
                return t;
        }

        public Enumeration getThreadEnum( )
        {
                Enumeration enum = _threads.keys();
                return enum;
        }

        public Thd getNextThread( Enumeration enum )
        {
                String key = null;
                Thd retVal = null;
                if ( enum.hasMoreElements() )
                {
                        key = (String)enum.nextElement();
                        retVal = (Thd)_threads.get( key );
                }
                return retVal;
        }


        public Monitor getHeapLock()
        {
                Enumeration enum = getMonitorEnum();
                Monitor m = getNextMonitor( enum );
                while ( m != null )
                {
                        if ( m._name.equals( "HEAP_LOCK" ) )
                                return m;
                        m = getNextMonitor( enum );
                }
                return null;
        }

        public Vector webLockWaiters( Monitor m )
        {
                logDebug( "Checking monitor: " + m.getName() + "  contains " + m._waiters.size() + " waiters");

                // how many web threads are waiting on the lock?
                Vector vRet = null;
                if ( m != null )
                {
                        Vector webWaiters = new Vector();
                        for ( int i = 0; i < m._waiters.size(); ++i )
                        {
                                Thd thd =  (Thd)m._waiters.elementAt( i );
                                if ( thd.isExecutingWebWork() )
                {
                    logDebug( "  thd: " + i + "  is executing web work" );
                                        webWaiters.add( m._waiters.elementAt( i ) );
                }
                        }
                        if ( webWaiters.size() > 0 )
                                vRet = webWaiters;
                }
                return vRet;
        }

        public Vector orbLockWaiters( Monitor m )
        {
                // how many orb threads are waiting on the lock?
                Vector vRet = null;
                if ( m != null )
                {
                        Vector orbWaiters = new Vector();

                        for ( int i = 0; i < m._waiters.size(); ++i )
                        {
                                Thd thd =  (Thd)m._waiters.elementAt( i );
                                if ( thd.isExecutingRemoteOrbWork() )
                                        orbWaiters.add( m._waiters.elementAt( i ) );
                        }
                        if ( orbWaiters.size() > 0 )
                                vRet = orbWaiters;
                }
                return vRet;
        }

        public void writeTo( String fileName ) throws Exception
        {
                try
                {
                        FileOutputStream fo = new FileOutputStream( fileName );
                        ObjectOutputStream so = new ObjectOutputStream( fo );
                        writeExternal( so );
                        so.flush();
                        so.close();
                }
                catch ( Exception e )
                {
                        e.printStackTrace();
                        throw e;
                }
        }


        public static DumpData readFrom( String fileName ) throws Exception
        {
                DumpData cnew = new DumpData();
                try
                {
                        FileInputStream fi = new FileInputStream( fileName );
                        ObjectInputStream si = new ObjectInputStream( fi );  
                        cnew.readExternal( si );
                        si.close();
                }
                catch ( Exception e )
                {
                        // e.printStackTrace();
                        throw e;
                }

                return cnew;

        }

        public void fixupIdRefs()
        {
                // fixup all references in the object graph that were written as IDs
                // to the external stream.

                Enumeration enum = getThreadEnum();

                Thd thd = getNextThread(enum );

                while ( thd != null )
                {

                        int monID = thd.getWaitMonitorId();

                        if ( monID > 0 )
                        {
                                Monitor m = getMonitorById( monID );
                                if ( m != null )
                                        thd.setWaitMonitor( m );
                        }

                        thd = getNextThread(enum );

                }

                enum = getMonitorEnum();
                Monitor m = getNextMonitor( enum );
                while ( m != null )
                {
                        //System.out.println( "Fixing up monitor: " + m );
                        m.fixupWaiters( this );
                        m = getNextMonitor( enum );
                }


        }

        public void initAnalysis()
        {
                setAnalysisType();

                _tosTrans = null;
                try
                {
                        _tosTrans = ResourceBundle.getBundle( "ta_tos_trans" );
                }
                catch ( Exception e )
                {
                        Locale l = Locale.getDefault();

                        // Fix this later

                        /*
                        logErr( "cannot load top of stack translator for this locale. Top of" );
                        logErr( "   stack information will not be translated into meaningful text." );
                        logErr( "ta_tos_trans_" + l.getLanguage() + "_" + l.getCountry() + ".properties" );
                        logErr( e.getMessage() );
                        */
                }
                loadExternalEvaluators( DumpParser.getArg( "detailXML" ));       // loads external classes whose 
                Enumeration enum = null;
                String key = null;

                // loop over the threads and monitors and call 
                // the helpers.  The helpers set properties used
                // later in the analysis.  For instance: WAITING_FOR_WEB_WORK=true, etc.

                // the threads

                // **********************************************************************
                // ALSO, Here the pgm also calculates the number of threads with missing stacks
                // so the analysis sections can warn of the possibility of 
                // mis/dis-information....
                // **********************************************************************

                calcMissingThreadStacks();

                for ( enum = _threads.keys(); enum.hasMoreElements(); )
                {
                        key = (String)enum.nextElement();
                        Thd thd = (Thd)_threads.get( key );
                        Object params[] = new Object[2];
                        params[0] = _env;
                        params[1] = thd;

                        // there's really no reason to call the helpers, but...

                        logDebug( thd.getName() + " has a stack size of: " + thd.getStkSize() + ". Threads missing stacks is now: " + _threadsMissingStacks );

                        for ( int i = 0; i < _threadDetailHelpers.size(); ++i )
                        {
                                Method helper = (Method)_threadDetailHelpers.elementAt( i );

                                try
                                {

                                        helper.invoke( null, params ); // static call requires no object ref 
                                }
                                catch ( Exception e )
                                {
                                        logErr( "Exception while executing thread detail helper '" + helper.getName() + "'" );
                                        e.printStackTrace();
                                }
                        }
                }

                // the monitors 
                for ( enum = _monitors.keys(); enum.hasMoreElements(); )
                {
                        key = (String)enum.nextElement();
                        Monitor m = (Monitor)_monitors.get( key );
                        Object params[] = new Object[2];
                        params[0] = _env;
                        params[1] = m;
                        for ( int i = 0; i < _monitorDetailHelpers.size(); ++i )
                        {
                                Method helper = (Method)_monitorDetailHelpers.elementAt( i );

                                try
                                {

                                        helper.invoke( null, params ); // static call requires no object ref 
                                }
                                catch ( Exception e )
                                {
                                        logErr( "Exception while executing monitor detail helper '" + helper.getName() + "'" );
                                }
                        }
                }

                // coalesce the monitors having COALESCE=true

                // Since enumertions seem to change as elements
                // are added to the target, get a static list first.
                // This reduces the possibility of duplicate
                // thread lists being applied to a coalesced monitor
                Vector keys = new Vector();

                for ( enum = _monitors.keys(); enum.hasMoreElements(); )
                {
                        key = (String)enum.nextElement();
                        keys.add( key );
                }

                for ( int i = 0; i < keys.size(); ++i )
                {
                        key = (String)keys.elementAt( i );
                        Monitor m = (Monitor)_monitors.get( key );
                        String coalesce = m.getProperty( "COALESCE" );
                        if ( coalesce != null && coalesce.equals( "true" ) )
                        {
                                // delete this monitor from the hashtable
                                // and append it's waiter list to the
                                // coalesced monitor
                                _monitors.remove( m.getName() );
                                //System.err.println( "Coalesce: " + m.getName() );
                                String newName = null;
                                int idx = m.getName().indexOf( '@' );
                                if ( idx > -1 )
                                        newName = m.getName().substring( 0, idx );
                                else newName = m.getName();
                                Monitor cm = (Monitor)_monitors.get( newName );
                                if ( cm != null )
                                {
                                        cm._waiters.addAll( m._waiters );
                                }
                                else
                                {
                                        m._name = newName;
                                        _monitors.put( newName, m );
                                }
                        }
                }

                logDebug( "DumpData.print - building common TOS lists" );
//B             TaGUI.getOpenExistingDialog().append( "\r\nBuilding common TOS lists\r\n" );
                buildCommonTOSLists();
        // this is a major bottleneck...
                _tosInfo = new TOSInfo( _threadsByTOS ); // ead - 20011105
                //_tosInfo.build();                                              // ead - 20011105
                logDebug( "DumpData.print - determining thread breakdown" );
//B             TaGUI.getOpenExistingDialog().append( "\r\nDetermining thread breakdown\r\n" );
                // determine the breakdown of what threads are doing.

                _totThreads = 0;
                _unknownThreads = 0;
                _webWaitThreads = 0;
                _orbWaitThreads = 0;
                _workingWebThreads = 0;
                _workingOrbThreads = 0;

                for ( enum = _threads.keys(); enum.hasMoreElements(); )
                {
                        ++_totThreads;
                        key = (String)enum.nextElement();
                        Thd thd = (Thd)_threads.get( key );
                        if ( thd.waitingForWebWork() )
                                ++_webWaitThreads;
                        if ( thd.waitingForOrbWork() )
                                ++_orbWaitThreads;
                        if ( thd.isExecutingWebWork() )
                                ++_workingWebThreads;
                        if ( thd.isExecutingRemoteOrbWork() )
                                ++_workingOrbThreads;

                }

                _unknownThreads = _totThreads - ( _webWaitThreads + _orbWaitThreads + _workingWebThreads + _workingOrbThreads );
        }

        public void outputVector( Vector v )
        { // for the functions that return a vector, this will print their
                // results.  
                for ( int i = 0; i < v.size(); ++i )
                {
                        rptOut2( (String)v.elementAt( i ));
                }
        }


        public void warnMissingStacks( OutputStream o )
        {
                PrintStream ps = new PrintStream( o );

                String warnMsg = missingStacksMsg();

                if ( warnMsg != null && warnMsg.length() > 0 )
                {
                        ps.println( "WARNING: " + warnMsg );
                }

        }

        protected void calcMissingThreadStacks()
        {
                _threadsMissingStacks = 0;
                for ( Enumeration enum = _threads.keys(); enum.hasMoreElements(); )
                {
                        String key = (String)enum.nextElement();
                        Thd thd = (Thd)_threads.get( key );

                        if ( thd.getStkSize() <= 0 
                                 && !thd.getName().equalsIgnoreCase( "signal dispatcher" ) )
                                ++_threadsMissingStacks;

                }
        }

        protected Vector warnMissingStacks()
        {
                Vector v = new Vector();

                String warnMsg = missingStacksMsg();
                if ( warnMsg != null && warnMsg.length() > 0 )
                {
                        logWarning( warnMsg );
                        v.add( "WARNING: " + warnMsg );
                }


                return v;
        }


        protected String missingStacksMsg()
        {
                calcMissingThreadStacks();
                String warnMsg = "";
                if ( _threadsMissingStacks > 0 )
                {
                        warnMsg = "" + _threadsMissingStacks + " threads have no stack information.";
                }
                return warnMsg;
        }

        public void print( String rptName )
        {
                PrintStream ps = null;
                try
                {
                        ps = new PrintStream( ( new FileOutputStream( rptName )));
                }
                catch ( FileNotFoundException fnfe )
                {
                        logErr( "Cannot create output file " + rptName );
                        System.exit( -1 );
                }
                print( ps );
        }

        public void print( )
        {
                print( System.out );
        }

        public void print( PrintStream ps )
        {
                setPrintStream( ps );

                logDebug( "DumpData.print( ) begins..." );
                // methods are called to examine
                // thread+stack and monitor details

                initAnalysis();


                logDebug( "DumpData.print - beginning of report" );
                if ( _fHtml )
                {

                        rptOut("<html>" );
                        rptOut2( "<title>Thread dump analysis " );

                        if ( _inputFilename != null )
                        {
                                rptOut2( "for " + _inputFilename );
                        }

                        rptOut2("</title>" );

                        rptOut2( "<h2>Thread dump analysis " );

                        if ( _inputFilename != null )
                        {
                                rptOut2( "for " + _inputFilename );
                        }

                        rptOut2("</h2>" );

                        printHeading();

                        if ( _analysisType != ANALYZE_WAS )
                                rptOut2( "Analysis type:" + DumpParser.getArg( "analyze" ) );

                        rptOut( "<a name=top></a><h2>Contents</h2>" );
                        rptOut2( "<ul>" );
                        rptOut2( "<li><a href=#disclaimer>Disclaimer</a></li>" );
                        rptOut2( "<li><a href=#notice>Notice</a></li>" );
                        rptOut2( "<li><a href=#summary>Summary</a></li>" );
                        rptOut2( "<li><a href=#observations>Observations</a>" );
                        rptOut2( "   <ul>" );
                        if ( (_analysisType & ANALYZE_SERVLET) == ANALYZE_SERVLET )
                        {

                                rptOut2( "      <li><a href=#spa>Servlet thread pool analysis</a></li>" );
                                rptOut2( "      <li><a href=#sta>Servlet engine thread analysis</a></li>" );
                                rptOut2( "      <li><a href=#sma>Servlet engine monitor analysis</a></li>" );
                        }
                        if ( (_analysisType & ANALYZE_EJB) == ANALYZE_EJB )
                        {
                                rptOut2( "      <li><a href=#opa>ORB thread pool analysis</a></li>" );
                                rptOut2( "      <li><a href=#ota>ORB thread analysis</a></li>" );
                                rptOut2( "      <li><a href=#oma>ORB monitor analysis</a></li>" );
                        }
                        //rptOut2( "      <li><a href=#opa> thread pool analysis</a></li>" );
                        if ( (_analysisType & ANALYZE_OTHER) == ANALYZE_OTHER )
                        {

                                rptOut2( "      <li><a href=#ta>Overall thread analysis</a></li>" );
                                rptOut2( "      <li><a href=#ma>Overall monitor analysis</a></li>" );
                        }
                        rptOut2( "   </ul>" );
                        rptOut2( "</li>" );
                        if ( _logLevel >= DumpParser.DETAIL )
                        {

                                rptOut2( "<a href=#dtd><li>Thread details</li></a>" );
                                rptOut2( "<a href=#dmd><li>Monitor details</li></a>" );
                        }
                        rptOut2( "</ul>" );
                }

                Enumeration enum = null;
                String key = null;
                outputVector( disclaimer() );

                outputVector( notice() );

                if ( _inputFilename != null )
                {
                        rptOut( "Input file: " + _inputFilename );
                }

                logDebug( "DumpData.print - doing summary section" );
                outputVector( summary() );

                //Monitor m = getHeapLock();
                //int heapLockWaiters = 0;
                //String heapWaiters = "";
                //if( m != null )
                //{
                //   heapLockWaiters = m._waiters.size();
                //   heapWaiters += heapLockWaiters;
                //}
                //else heapWaiters += "unknown";
                //rptOut( "Threads waiting on heap lock......... " + heapWaiters );

                rptOut( );
                rptOut( );

                rptOut( );
                rptOut( html("<a name=observations></a><h1>") + "Observations..." + html("</h1>") );

                if ( (_analysisType & ANALYZE_SERVLET) == ANALYZE_SERVLET )
                {

                        logDebug( "DumpData.print - doing servlet pool analysis" );

                        outputVector( servletPoolAnalysis(  ));
                        servletThreadPool();
                        outputVector( servletThreadAnalysis( ));
                        outputVector( servletMonitorAnalysis( ));
                }
                if ( (_analysisType & ANALYZE_EJB) == ANALYZE_EJB )
                {

                        logDebug( "DumpData.print - doing orb pool analysis" );
                        outputVector( orbPoolAnalysis( ));
                        orbThreadPool();
                        outputVector( orbThreadAnalysis( ));
                        outputVector( orbMonitorAnalysis());
                }
                if ( (_analysisType & ANALYZE_OTHER) == ANALYZE_OTHER )
                {

                        logDebug( "DumpData.print - doing overall thread analysis" );
                        outputVector( overallThreadAnalysis( ));
                        overallThreadPool();
                        outputVector( overallMonitorAnalysis( ));
                }
                rptOut( html("<h3>") + "End of analysis section" + html("</h3>") );
                rptOut( " " );
                //System.err.println( "loglevel = " + _logLevel );


                if ( _logLevel >= DumpParser.DETAIL )
                {
                        logDebug( "DumpData.print - writing thread details" );

                        rptOut( html("<a name=dtd></a><h1>") +"Detailed thread dump" + html("</h1>") );
                        rptOut2( html("<a href=#top>[top]</a>") );
                        for ( enum = _threads.keys(); enum.hasMoreElements(); )
                        {
                                key = (String)enum.nextElement();
                                Thd thd = (Thd)_threads.get( key );
                                int indent = 0;
                                rptOut2( html("<pre>") );
                                outputVector( thd.format( indent, _fHtml ));
                                rptOut2( html("<br><a href=#top>[top]</a>") );
                                rptOut2( html("</pre>") );
                        }        

                        //rptOut( "** END Detailed thread dump ** " );
                        rptOut2( html("<a href=#top>[top]</a>") );
                        rptOut( " " );

                        logDebug( "DumpData.print - writing monitor details" );
                        enum = getMonitorEnum();
                        Monitor m = getNextMonitor( enum );
                        rptOut2( html("<a name=dmd></a><h3>") + "Detailed monitor dump" + html("</h3>") );
                        rptOut2( html("<a href=#top>[top]</a>") );

                        while ( m != null )
                        {
                                rptOut2( html("<pre>") );
                                outputVector( m.format( 1, _fHtml ));
                                rptOut2( html("<br><a href=#top>[top]</a>") );
                                rptOut2( html("</pre>") );
                                m = getNextMonitor( enum );
                        }

                        rptOut( "** END Detailed monitor dump **" );
                        rptOut2( html("<a href=#top>[top]</a>") );
                        rptOut( " " );
                }
                rptOut( "** END OF REPORT **" );
                rptOut( html("</html>") );
                logDebug( "DumpData.print( ) end." );

        // must close all handles to allow browser to open the file
        ps.flush();
        ps.close();
        }

        protected void setPrintStream( PrintStream ps )
        {
                _rptOut = ps;
        }

        protected void printHeading()
        {
                rptOut( "Thread analyzer version: " + formattedVersion() );
        }

        public Vector summary()
        {
                Vector v = new Vector();

                v.add( "" );
                v.add( "" );
                v.add( html( "<a name=summary><h1>") + "Summary" + html("</h1></a>&nbsp;&nbsp;<a href=#top>[top]</a>") );
                v.add( html("<pre>") );
                v.add( "Thread utilization summary: " );
                v.add( "  Total threads................................................... " + _totThreads );
                v.add( "     threads waiting for web work................................. " + _webWaitThreads );
                v.add( "     threads waiting for remote orb work.......................... " + _orbWaitThreads );
                v.add( "     threads doing web or local orb work.......................... " + _workingWebThreads );
                v.add( "     threads doing remote orb work................................ " + _workingOrbThreads );
                v.add( "     threads doing other (non web or remote orb workload) tasks... " + _unknownThreads );
                //dipak
                // check if Deadlock exists
                if( deadlockExists ) 
                {
                        v.add("\nDeadlock(s) found.  See Overall Monitor Analysis for details.");
                }
                else {
                		v.add("\nNo deadlock(s) found.");
                }
                v.add( html("<a href=#top>[top]</a>") );
                v.add( html("</pre>") );
                return v;
        }

        public Vector disclaimer()
        {
                Vector v = new Vector();
                v.add( html("<a name=disclaimer></a><h3>") +"Disclaimer" + html("</h3>") );
                v.add( html( "<pre>" ));
                v.add( "      IBM has made every effort to ensure information and" );
                v.add( "      recommendations to be  correct.  However, results are not" );
                v.add( "      guaranteed.  System changes should not be made based" );
                v.add( "      on information obtained using this or any other tool" );
                v.add( "      without full consideration of the possible ramifications" );
                v.add( "      of such changes." );
                v.add( html( "</pre>" ));
                v.add( html("<a href=#top>[top]</a>") );
                return v;
        }

        public Vector notice()
        {
                Vector v = new Vector();
                v.add( html("<a name=notice></a><h3>") +"Notice" + html("</h3>") );
                v.add( html( "<pre>" ));
                v.add( "      This tool primarily focuses on threads created by the IBM WebSphere server runtime." );
                v.add( "      Also, the tool assumes that a representative workload is being driven through" );
                v.add( "      the system for analysis." );
                v.add( html( "</pre>" ));
                v.add( html("<a href=#top>[top]</a>") );
                return v;
        }

        public void servletThreadPool()
        {
                ServletThreadPool stp = getServletThreadPool();
                TaGridElement[][] gea = stp.getTosGrid();
                Object headers[] = stp.getTosGridHeaders();

                rptOut2( html( "<b>" ) + "Top of stack information. " + html( "</b>" ));
                rptOut2( "Highest weight items *may* indicate the need for more analysis." );
                rptOut2( "Items with a weight of 0 are shown for completeness, but represent" );
                rptOut2( "   non-applicable system functions." );

                if ( gea != null )
                {
                        rptOut2( html( "<table border=1 ><tr>" ));
                        int rows = gea.length;
                        int cols = gea[0].length;
                        String heading = "";
                        for ( int r = 0; r < headers.length; ++r )
                        {

                                heading += html( "<th>" ) + headers[r].toString() + "\t\t" + html( "</th>" );
                        }
                        rptOut2( heading );
                        rptOut2( html( "</tr>" ) );
                        for ( int r = 0; r < rows; ++r )
                        {
                                rptOut2( html( "<tr>" ) );
                                String line = "";
                                for ( int c = 0; c < cols; ++c )
                                {
                                        line += html( "<td>" ) + gea[r][c].toString() + "\t\t" + html( "</td>" );
                                }
                                rptOut2( line );
                                rptOut2( html( "</tr>" ) );
                        }
                        rptOut2( html( "</table><br><br>" ));
                }
        }

        public void orbThreadPool()
        {
                OrbThreadPool otp = getOrbThreadPool();
                TaGridElement[][] gea = otp.getTosGrid();
                Object headers[] = otp.getTosGridHeaders();

                rptOut2( html( "<br><b>" ) + "Top of stack information. " + html( "</b><br>" ));
                rptOut2( "Highest weight items *may* indicate the need for more analysis." );
                rptOut2( "Items with a weight of 0 are shown for completeness, but represent" );
                rptOut2( "   non-applicable system functions." );

                if ( gea != null )
                {
                        rptOut2( html( "<table border=1 ><tr>" ));
                        int rows = gea.length;
                        int cols = gea[0].length;
                        String heading = "";
                        for ( int r = 0; r < headers.length; ++r )
                        {

                                heading += html( "<th>" ) + headers[r].toString() + "\t\t" + html( "</th>" );
                        }
                        rptOut2( heading );
                        rptOut2( html( "</tr>" ) );
                        for ( int r = 0; r < rows; ++r )
                        {
                                rptOut2( html( "<tr>" ) );
                                String line = "";
                                for ( int c = 0; c < cols; ++c )
                                {
                                        line += html( "<td>" ) + gea[r][c].toString() + "\t\t" + html( "</td>" );
                                }
                                rptOut2( line );
                                rptOut2( html( "</tr>" ) );
                        }
                        rptOut2( html( "</table><br><br>" ));
                }
        }

        public void overallThreadPool()
        {
                OverallThreadPool otp = getOverallThreadPool();
                TaGridElement[][] gea = otp.getTosGrid();
                Object headers[] = otp.getTosGridHeaders();

                rptOut2( html( "<b>" ) + "Top of stack information. " + html( "</b>" ));
                rptOut2( "Overall thread analysis should be interpreted carefully." );
                rptOut2( "Items with a high number of associated threads *may not*" );
                rptOut2( "   be items of concern since threads waiting for work" );
                rptOut2( "   will show up with large numbers of associated threads." );

                if ( gea != null )
                {
                        rptOut2( html( "<table border=1 ><tr>" ));
                        int rows = gea.length;
                        int cols = gea[0].length;
                        String heading = "";
                        for ( int r = 0; r < headers.length; ++r )
                        {

                                heading += html( "<th>" ) + headers[r].toString() + "\t\t" + html( "</th>" );
                        }
                        rptOut2( heading );
                        rptOut2( html( "</tr>" ) );
                        for ( int r = 0; r < rows; ++r )
                        {
                                rptOut2( html( "<tr>" ) );
                                String line = "";
                                for ( int c = 0; c < cols; ++c )
                                {
                                        line += html( "<td>" ) + gea[r][c].toString() + "\t\t" + html( "</td>" );
                                }
                                rptOut2( line );
                                rptOut2( html( "</tr>" ) );
                        }
                        rptOut2( html( "</table><br><br>" ));
                }
        }


        public Vector orbPoolAnalysis()
        {
                return orbPoolAnalysis( _tosTrans, _orbWaitThreads, _workingOrbThreads );
        }

        protected Vector orbPoolAnalysis( ResourceBundle tosTrans, int waitingThreads, int workingThreads )
        {

                Vector v = new Vector();

                Enumeration enum = null;
                String key = null;
                int apparentPoolSize = waitingThreads + workingThreads;
                double fractionOfPoolWorking =  (double)workingThreads / (double)apparentPoolSize;

                double pctPoolWorking = fractionOfPoolWorking * 100;

                v.add( html( "<pre>" ));

                v.add( html("<a name=opa></a><h3>") + "ORB thread pool analysis" + html("</h3>") );

//              v.addAll( warnMissingStacks() );

                if ( workingThreads > 0 )
                {

                        if ( fractionOfPoolWorking < 0.80 )
                        {
                                v.add( _sTab + "   The ORB remote call handler thread pool does not seem to be driven to full capacity." );
                                v.add( _sTab + "   It's possible that there's a network bandwidth or workload generator constraint." );
                                v.add( "" );
                                if ( apparentPoolSize > 5 )     // the default
                                {
                                        v.add( _sTab + "   It appears that the workload in this pool may be bursty." );
                                        v.add( _sTab + "      Since the ORB remote call handler pool size is dynamic," );
                                        v.add( _sTab + "      it's possible that some other resource may be fully consumed" );
                                        v.add( _sTab + "      causing ORB requests to not be handled effectively." );
                                }
                        }
                        else
                        {
                                if ( fractionOfPoolWorking > 0.98 )
                                {
                                        if ( apparentPoolSize <= 5 )
                                        {
                                                v.add( _sTab + "   The pool should expand itself." );
                                        }
                                        else
                                        {
                                                v.add( _sTab + "    The pool has apparently expanded from the default of 5 to " + apparentPoolSize );
                                        }
                                }
                                else
                                {
                                        v.add( _sTab + "   The pool seems to be adequately utilized assuming relatively" );
                                        v.add( _sTab + "      full resource utilization across the system" );
                                }
                        }
                }
                else
                {
                        v.add( _sTab + "No ORB remote call handler workload appears to be active" );
                }
                //rptOut( _sTab + "** END Servlet engine thread pool analysis." );
                v.add( html("<a href=#top>[top]</a>") );
                v.add( html( "</pre>" ));
                v.add( "" );
                v.add( "" );
                return v;
        }
        public Vector orbThreadAnalysis()
        {

                Vector v = new Vector();
                Enumeration enum = null;
                String key = null;

                v.add( html("<a name=ota></a><h3>") + "ORB thread analysis" + html("</h3>") );
//              v.addAll( warnMissingStacks() );

                boolean fReportedProblems = false;
                for ( enum = _threadsByTOS.keys(); enum.hasMoreElements(); )
                {
                        key = (String)enum.nextElement();
                        Vector vec = (Vector)_threadsByTOS.get( key );
                        int orbThreads = 0;
                        int nonOrbThreads = 0;
                        Vector callers = new Vector(); // the callers of the TOS
                        Thd thdPrior = null;
                        Hashtable ejbs = new Hashtable();
                        int qualCount = 0;
                        for ( int i = 0; i < vec.size(); ++i )
                        {
                                Thd thd = (Thd)vec.elementAt( i );

                                if ( thd.isExecutingRemoteOrbWork() )
                                {
                                        ++qualCount;
                                        // build the callers list
                                        if ( thdPrior != null )
                                                thd.firstStackDifference( callers, thdPrior );
                                        if ( qualCount == 2 )
                                                thdPrior.firstStackDifference( callers, thd ); // hack to get first thread's caller if necessary
                                        thdPrior = thd;

                                        ++orbThreads;
                                        String ejbNames[] = thd.getEjbNames(); 
                                        if ( ejbNames.length != 0 )
                                        {
                                                for ( int j = 0; j < ejbNames.length; ++j )
                                                {

                                                        Integer count = (Integer)ejbs.get( ejbNames[ j ] );
                                                        if ( count == null )
                                                                count = new Integer( 1 );
                                                        else
                                                                count = new Integer( count.intValue() + 1);
                                                        ejbs.put( ejbNames[ j ], count );
                                                }
                                        }
                                }
                                else ++nonOrbThreads;
                        }


                        if ( orbThreads > 1 )
                        {
                                v.add( html( "<pre>" ));
                                fReportedProblems = true;
                                v.add( _sTab + "   " + key + " seems to be a " );
                                String sNonOrb = ".";
                                if ( nonOrbThreads > 0 )
                                        sNonOrb = " and " + nonOrbThreads + " non-ORB remote call handler threads.";
                                v.add( _sTab + "         concurrently executed by " + orbThreads + " ORB remote call handler threads" + sNonOrb );
                                String tosText = null;
                                try
                                {
                                        tosText = _tosTrans.getString( key );
                                }
                                catch ( Exception e )
                                {
                                        // nada
                                }

                                if ( tosText != null )
                                {
                                        v.add( _sTab + "      SPECIFICS about " + key );
                                        v.add( format( 18, 80, "This method "  + tosText ));
                                }
                                double dFractOfWorking = (double)orbThreads / (double)_workingOrbThreads;

                                if ( dFractOfWorking > 0.25 )
                                {
                                        int pctWorking = (int)(dFractOfWorking * 100);
                                        v.add( _sTab + "      Since " + pctWorking + "% (" + orbThreads + " out of " + _workingOrbThreads +  ") of the threads doing ORB remote call handler work seem to be" );
                                        v.add( _sTab + "          executing this method, it would seem that there " );
                                        v.add( _sTab + "          is some possibility that this method and its call path" );
                                        v.add( _sTab + "          may warrant investigation." );
                                }


                                Enumeration ejbNames = ejbs.keys() ;

                                if ( ejbNames.hasMoreElements() )
                                        v.add( _sTab + "      EJBs affected: " );

                                for ( ; ejbNames.hasMoreElements(); )
                                {
                                        String sKey = (String)ejbNames.nextElement();
                                        v.add( _sTab + "         " + sKey + " [" + (Integer)ejbs.get( sKey ) + " occurrances]" );
                                }

                                v.add( _sTab + "      callers (ORB RCH threads only): " );

                                if ( callers.size() <= 0 )
                                {
                                        v.add( _sTab + "         The method seems to be called by EJBs from one code path.");
                                }

                                for ( int i = 0; i < callers.size(); ++i )
                                {
                                        v.add( _sTab + "         " + Thd.getCallerName( callers.elementAt( i )) + " [" + Thd.getCallerCount( callers.elementAt( i )) + "]");   
                                }

                                v.add( " " );
                                v.add( html( "</pre>" ));
                        }
                }
                if ( ! fReportedProblems )
                        v.add( _sTab + "      no observations to report." );
                v.add( html("<a href=#top>[top]</a>") );
                v.add( "" );
                v.add( "" );
                return v;
        }

        public Vector orbMonitorAnalysis()
        {
                return orbMonitorAnalysis( _workingOrbThreads );
        }

        protected Vector orbMonitorAnalysis( int workingRmtOrbThreads )
        {

                Vector v = new Vector();

                v.add( html("<a name=oma></a><h3>") + "ORB monitor analysis" + html("</h1>") );
                // iterate over the monitors and do the lock analysis for each monitor
                // with respect to web work

                Enumeration lockEnum = getMonitorEnum();
                Monitor m = null;

                int blockedCount = 0;

                Vector callers = new Vector(); // the callers of the lock
                v.add( html( "<pre>" ));

                while ( ( m = getNextMonitor( lockEnum )) != null )
                {

                        Vector orbWaiters = orbLockWaiters( m );

                        int waiters = 0;
                        if ( orbWaiters != null )
                                waiters = orbWaiters.size();

                        if ( waiters > 0 )
                        {
                                ++blockedCount;
                                v.add( _sTab + "   Lock name: " + m.getName() );

                                if ( m.getName().equals( "com.ibm.ejs.cm.pool.Waiter" ) )
                                {
                                        v.add( _sTab + "      NOTE: " + m.getName() + " is the monitor used to mutex datasource" );
                                        v.add( _sTab + "            connection pools within WebSphere. It's very possible that" );
                                        v.add( _sTab + "            SLIGHTLY increasing the connection pool size for the affected datasource." );
                                        v.add( _sTab + "            may relieve the constraint." );
                                }

                                v.add( _sTab + "      There is/are " + waiters + " ORB remote call handler thread(s) waiting on the lock." );

                                logDebug( "Threre are " + workingRmtOrbThreads + " working remote threads." );

                                double fractionWaiting = (double)waiters / (double)workingRmtOrbThreads;

                                if ( fractionWaiting > 0.25 )
                                {
                                        v.add( _sTab + "      It seems that a significant number of ORB remote call handler threads doing work" );
                                        v.add( _sTab + "         are blocked on this lock." );
                                        v.add( _sTab + "      Understanding the usage of this lock" );
                                        v.add( _sTab + "         may be important." );
                                }
                                v.add( "" );

                                Thd thdPrior = null;

                                for ( int i = 0; i < waiters; ++i )
                                {

                                        Thd thd = (Thd)orbWaiters.elementAt( i );

                                        // build the callers list
                                        if ( thdPrior != null )
                                                thd.firstStackDifference( callers, thdPrior );
                                        if ( i == 1 )
                                                thdPrior.firstStackDifference( callers, thd ); // hack to get first thread's caller if necessary
                                        thdPrior = thd;
                                }

                        }

                }
                if ( blockedCount == 0 )
                {
                        v.add( _sTab + "   No 'running' ORB remote call handler threads seem to be blocked by java monitors." );
                        v.add( _sTab + "      NOTE: running means threads not waiting for work." );
                        v.add( _sTab + "              since threads waiting for work always appear blocked." );
                }
                else
                {
                        v.add( _sTab + "   Blocked callers: " );

                        if ( callers.size() <= 0 )
                        {
                                v.add( _sTab + "      The blockage seems to be entered from one code path.");
                        }

                        for ( int i = 0; i < callers.size(); ++i )
                        {
                                v.add( _sTab + "      " + Thd.getCallerName( callers.elementAt( i )) + " [" + Thd.getCallerCount( callers.elementAt( i )) + "]" );   
                        }

                }
                v.add( html("<a href=#top>[top]</a>") );
                v.add( "" );
                v.add( "" );
                v.add( html( "</pre>" ));
                return v;
        }

        public Vector overallThreadAnalysis()
        {
                return overallThreadAnalysis( _tosTrans );
        }

        protected Vector overallThreadAnalysis( ResourceBundle tosTrans )
        {
                Vector v = new Vector();

                v.add( html("<a name=ta></a><h3>") + "Overall thread analysis" + html("</h3>") );

                v.add( html( "<pre>" ));

//              v.addAll( warnMissingStacks() );

                Enumeration enum = null;
                String key = null;

                boolean fReportedProblems = false;
                for ( enum = _threadsByTOS.keys(); enum.hasMoreElements(); )
                {
                        key = (String)enum.nextElement();
                        //System.err.println("[DumpData] key: " + key);
                        Vector vec = (Vector)_threadsByTOS.get( key );
                        int threads = 0;
                        Vector callers = new Vector(); // the callers of the TOS
                        Thd thdPrior = null;
                        for ( int i = 0; i < vec.size(); ++i )
                        {
                                Thd thd = (Thd)vec.elementAt( i );
                                //System.err.println("[DumpData] \tthd name: " + thd.getName() + "  i: " + i);

                                // build the callers list
                                if ( thdPrior != null )
                                        thd.firstStackDifference( callers, thdPrior );
                                if ( i == vec.size()-1 && vec.size()>1 )
                                        thdPrior.firstStackDifference( callers, thd ); // hack to get last thread's caller if necessary
                                thdPrior = thd;

                                ++threads;
                        }
                        //System.err.println();


                        if ( threads > 1 )
                        {
                                fReportedProblems = true;
                                v.add( _sTab + "   " + key + " is being executed by " );
                                v.add( _sTab + "         " + threads + " threads." );
                                String tosText = null;
                                try
                                {
                                        tosText = tosTrans.getString( key );
                                }
                                catch ( Exception e )
                                {
                                        // nada
                                }

                                if ( tosText != null )
                                {
                                        v.add( _sTab + "      SPECIFICS about " + key );
                                        v.add( format( 18, 80, "This method "  + tosText ));
                                }

                                v.add( _sTab + "      callers: " );

                                if ( callers.size() <= 0 )
                                {
                                        v.add( _sTab + "         The method seems to be called from one code path.");
                                }

                                for ( int i = 0; i < callers.size(); ++i )
                                {
                                        v.add( _sTab + "         " + Thd.getCallerName( callers.elementAt( i )) + " [" + Thd.getCallerCount( callers.elementAt( i )) + "]" );   
                                }

                                v.add( " " );
                        }
                }
                if ( ! fReportedProblems )
                        v.add( _sTab + "      no observations to report." );
                //rptOut( _sTab + "** END servlet engine thread analysis." );
                v.add( html("<a href=#top>[top]</a>") );
                v.add( "" );
                v.add( "" );
                v.add( html( "</pre>" ));
                return v;

        }


        public Vector overallMonitorAnalysis()
        {
                Vector v = new Vector();

                if( _monitors.size() > 0 )
                            v.add( html("<a name=ma></a><h3>") + "Overall monitor analysis" + html("</h1>") );
                else if ( deadlockResults == null )
                            v.add( html("<a name=ma></a><h3>") + "No monitor information in thread dump provided by JDK" + html("</h1>") );
        
                if( deadlockResults != null ){
                		v.addAll(deadlockResults);
                }
        
                return v;
        }

        public Vector servletMonitorAnalysis( )
        {
                return servletMonitorAnalysis( _workingWebThreads );
        }

        protected Vector servletMonitorAnalysis( int workingWebThreads )
        {

                Vector v = new Vector();


                v.add( html("<a name=sma></a><h3>") + "Servlet engine monitor analysis" + html("</h1>") );
                v.add( html( "<pre>" ));

                // iterate over the monitors and do the lock analysis for each monitor
                // with respect to web work

                Enumeration lockEnum = getMonitorEnum();
                Monitor m = null;

                int blockedCount = 0;

                Vector callers = new Vector(); // the callers of the lock

                while ( (m = getNextMonitor( lockEnum )) != null )
                {

                        Vector webWaiters = webLockWaiters( m );
                        int waiters = 0;
                        if ( webWaiters != null )
                                waiters = webWaiters.size();

            logDebug( waiters + " waiters and " + workingWebThreads + " workingWebThreads" );

                        if ( waiters > 0 )
                        {
                                ++blockedCount;
                                v.add( _sTab + "   Lock name: " + m.getName() );
                                if ( m.getName().equals( "com.ibm.ejs.cm.pool.Waiter" ) )
                                {
                                        v.add( _sTab + "      NOTE: " + m.getName() + " is the monitor used to mutex datasource" );
                                        v.add( _sTab + "            connection pools within WebSphere. It's very possible that" );
                                        v.add( _sTab + "            SLIGHTLY increasing the connection pool size for the affected datasource." );
                                        v.add( _sTab + "            may relieve the constraint." );
                                }
                                v.add( _sTab + "      There is/are " + waiters + " servlet engine thread(s) waiting on the lock." );
                                double fractionWaiting = (double)waiters / (double)workingWebThreads;

                                if ( fractionWaiting > 0.25 )
                                {
                                        v.add( _sTab + "      It seems that a significant number of servlet threads doing work" );
                                        v.add( _sTab + "         (" + waiters + " out of " + workingWebThreads + ") are waiting on this lock." );
                                        v.add( _sTab + "      Understanding the reason behind this wait " );
                                        v.add( _sTab + "         could lead to a way to improve performance for the servlets involved." );
                                }
                                v.add( "" );
                                /*
                                rptOut( _sTab + "         Here's a breakdown of what threads blocked on this monitor are doing (top 3 entries of stack )..." );
                                rptOut( _sTab + "            These thread stacks will probably help characterize the problem." );
                                rptOut( _sTab + "         Correlate the thread-id to the more detailed thread information at the end" );
                                rptOut( _sTab + "            of this report if more stack information is needed. ");
                                */
                                Thd thdPrior = null;

                                for ( int i = 0; i < waiters; ++i )
                                {

                                        Thd thd = (Thd)webWaiters.elementAt( i );

                                        // build the callers list
                                        if ( thdPrior != null )
                                                thd.firstStackDifference( callers, thdPrior );
                                        if ( i == 1 )
                                                thdPrior.firstStackDifference( callers, thd ); // hack to get first thread's caller if necessary
                                        thdPrior = thd;

                                        /*
                                        rptOut( _sTab + "         thread id-" + thd._threadId + "   thread name-" + thd.getName() );
                                        if( thd.getStkSize() > 0 )
                                        {
         
                                           for( int j = 0; j < 3 && j < thd.getStkSize(); ++j )
                                                  rptOut( _sTab + "            " + thd.getStkEntry( j ).getFQName() );
                                        }
                                        else rptOut( _sTab + "         *no stack information* " );
                                        */
                                }
                                //rptOut( );
                                //rptOut( );
                        }
                }
                if ( blockedCount == 0 )
                {
                        v.add( _sTab + "   No 'running' servlet threads seem to be blocked by java monitors." );
                        v.add( _sTab + "      NOTE: running means servlet threads not waiting for work." );
                        v.add( _sTab + "              since servlet threads waiting for work always appear blocked." );
                }
                else
                {
                        v.add( _sTab + "   Blocked callers: " );

                        if ( callers.size() <= 0 )
                        {
                                v.add( _sTab + "      The blockage seems to be entered from one code path.");
                        }

                        for ( int i = 0; i < callers.size(); ++i )
                        {
                                v.add( _sTab + "      " + Thd.getCallerName( callers.elementAt( i )) + " [" + Thd.getCallerCount( callers.elementAt( i )) + "]" );   
                        }

                }
                //rptOut( _sTab + "** END servlet engine thread lock analysis." );
                v.add( html("<a href=#top>[top]</a>") );
                v.add( "" );
                v.add( "" );
                v.add( html( "</pre>" ));
                return v;

        }

        public Vector servletPoolAnalysis()
        {
                return servletPoolAnalysis( _tosTrans, _webWaitThreads, _workingWebThreads );
        }

        protected Vector servletPoolAnalysis( ResourceBundle tosTrans, int webWaitThreads, int workingWebThreads )
        {
                Vector v = new Vector();

                String sTab = "   ";
                Enumeration enum = null;
                String key = null;
                int apparentWebPoolSize = webWaitThreads + workingWebThreads;
                double fractionOfWebPoolWorking =  (double)workingWebThreads / (double)apparentWebPoolSize;

                double pctWebPoolWorking = fractionOfWebPoolWorking * 100;

                v.add( html("<a name=spa></a><h3>") + "Servlet engine thread pool analysis (MAX CONNECTIONS)" + html("</h3>") );

                v.add( html( "<pre>" ));
//              v.addAll( warnMissingStacks() );

                if ( workingWebThreads > 0 )
                {

                        if ( fractionOfWebPoolWorking < 0.80 )
                        {
                                v.add( sTab + "   The servlet thread pool does not seem to be driven to full capacity." );
                                v.add( sTab + "   It's possible that there's a network bandwidth or workload generator constraint." );
                                v.add( "" );
                                v.add( "" );
                                v.add( sTab + "   It's also possible that the system under test is saturated." );
                                v.add( sTab + "      In this case, it's possible that the servlet thread pool may be over allocated." );
                                v.add( sTab + "      Check the thread pool size (MAX CONNECTIONS) in the servlet engine configuration." );
                                v.add( sTab + "      Currently, it's adequate to allocate no more than 5 or 6 threads per processor" );
                                v.add( sTab + "         unless the workload tends to wait on external resources, locks or java monitors." );
                                v.add( sTab + "         If threads tend to wait, then experimentation may be required to find the \"sweet spot\"." );
                        }
                        else
                        {
                                if ( fractionOfWebPoolWorking > 0.98 )
                                {
                                        v.add( sTab + "   If the WebSphere system under test has extra capacity, performance may be enhanced by increasing MAX CONNECTIONS for the servlet engine." );
                                }
                                else
                                {
                                        v.add( sTab + "   Assuming the system under test is near capacity with respect to resources, it would seem that the servlet engine is adequately busy." );
                                        v.add( sTab + "      more analysis will follow." );
                                }
                        }
                }
                else
                {
                        v.add( sTab + "No servlet workload appears to be active" );
                }
                //rptOut( _sTab + "** END Servlet engine thread pool analysis." );
                v.add( html("<a href=#top>[top]</a>") );
                v.add( "" );
                v.add( "" );
                return v;
        }

        public Vector servletThreadAnalysis()
        {

                Vector v = new Vector();

                Enumeration enum = null;
                String key = null;
                String sTab = "   ";

                v.add( html("<a name=sta></a><h3>") + "Servlet engine thread analysis" + html("</h3>") );
//              v.addAll( warnMissingStacks() );

                boolean fReportedProblems = false;
                for ( enum = _threadsByTOS.keys(); enum.hasMoreElements(); )
                {
                        key = (String)enum.nextElement();
                        Vector vec = (Vector)_threadsByTOS.get( key );
                        int servletThreads = 0;
                        int nonServletThreads = 0;
                        Vector callers = new Vector(); // the callers of the TOS
                        Thd thdPrior = null;
                        Hashtable servlets = new Hashtable();
                        int qualCount = 0;
                        for ( int i = 0; i < vec.size(); ++i )
                        {
                                Thd thd = (Thd)vec.elementAt( i );

                                if ( thd.isExecutingWebWork() )
                                {
                                        ++qualCount;
                                        // build the callers list
                                        if ( thdPrior != null )
                                                thd.firstStackDifference( callers, thdPrior );
                                        if ( qualCount == 2 )
                                                thdPrior.firstStackDifference( callers, thd ); // hack to get first thread's caller if necessary
                                        thdPrior = thd;

                                        ++servletThreads;
                                        String servletName = thd.getServletName();
                                        if ( servletName != null )
                                        {
                                                Integer count = (Integer)servlets.get( servletName );
                                                if ( count == null )
                                                        count = new Integer( 1 );
                                                else
                                                        count = new Integer( count.intValue() + 1);
                                                servlets.put( servletName, count );
                                        }
                                }
                                else ++nonServletThreads;
                        }


                        if ( servletThreads > 1 )
                        {
                                fReportedProblems = true;
                                v.add( sTab + "   " + key + " seems to be currently executing on " );
                                String sNonServlet = ".";
                                if ( nonServletThreads > 0 )
                                        sNonServlet = " and " + nonServletThreads + " non-servlet threads.";
                                v.add( sTab + "          " + servletThreads + " servlet threads" + sNonServlet );
                                String tosText = null;
                                try
                                {
                                        tosText = _tosTrans.getString( key );
                                }
                                catch ( Exception e )
                                {
                                        // nada
                                }

                                if ( tosText != null )
                                {
                                        v.add( sTab + "      SPECIFICS about " + key );
                                        v.add( format( 18, 80, "This method "  + tosText ));
                                }
                                double dFractOfWorking = (double)servletThreads / (double)_workingWebThreads;

                                if ( dFractOfWorking > 0.25 )
                                {
                                        int pctWorking = (int)(dFractOfWorking * 100);
                                        v.add( sTab + "      Since " + pctWorking + "% (" + servletThreads + " out of " + _workingWebThreads +  ") of the threads doing servlet work seem to be" );
                                        v.add( _sTab + "          executing this method, it would seem that there " );
                                        v.add( _sTab + "          is some possibility that this method and its call path" );
                                        v.add( _sTab + "          may warrant investigation." );
                                }


                                Enumeration servletNames = servlets.keys() ;

                                if ( servletNames.hasMoreElements() )
                                        v.add( sTab + "      Servlets affected: " );

                                for ( ; servletNames.hasMoreElements(); )
                                {
                                        String sKey = (String)servletNames.nextElement();
                                        v.add( sTab + "         " + sKey + " [" + (Integer)servlets.get( sKey ) + " occurrances]" );
                                }

                                v.add( sTab + "      Callers (servlet threads only): " );

                                if ( callers.size() <= 0 )
                                {
                                        v.add( sTab + "         The method seems to be called by servlets from one code path.");
                                }

                                for ( int i = 0; i < callers.size(); ++i )
                                {
                                        v.add( sTab + "         " + Thd.getCallerName( callers.elementAt( i )) + " [" + Thd.getCallerCount( callers.elementAt( i )) + "]" );   
                                }

                                v.add( " " );
                        }
                }
                if ( ! fReportedProblems )
                        v.add( sTab + "      no observations to report." );
                //rptOut( _sTab + "** END servlet engine thread analysis." );
                v.add( html( "</pre>" ));
                v.add( html("<a href=#top>[top]</a>") );
                return v;

        }
        protected void loadExternalEvaluators( String xmlFile )
        {
                _monitorDetailHelpers = new Vector();
                _threadDetailHelpers  = new Vector();
                Vector classes = new Vector();

                /* until the xml is really needed, disable it.
                NonValidatingTXDOMParser parser = new NonValidatingTXDOMParser( );
                try
                {
                   parser.parse( xmlFile );
                }
                catch( Exception e )
                {
                   logErr( "XML parse error or XML input file not found. File: " + xmlFile );
                   System.exit( -1 );
                }
                TXDocument inDoc = (TXDocument)parser.getDocument();
  
                Element rootElem = inDoc.getDocumentElement();
                if( rootElem == null )
                {
                   logErr( "Malformed XML document." );
                   System.exit( -1 );
                }
                NodeList list = null;
  
  
                list = rootElem.getElementsByTagName( "monitor_detail" );
                for( int i = 0; i < list.getLength(); i++ )
                {
                   Element subelement = (Element)list.item( i );
                   if( subelement.getParentNode() == rootElem )
                   {
                          logDebug( "Subelement " + subelement.getTagName()   );
                          NodeList list2 = subelement.getElementsByTagName( "class" );
                          for( int j = 0; j < list2.getLength(); ++j )
                          {
                                 TXText nmElem = (TXText)list2.item( j ).getFirstChild();
                                 String clsNm = nmElem.getNodeValue();
                                 logDebug( clsNm );
                                 classes.add( clsNm.trim() );
                          }
                   }
                }
                list = rootElem.getElementsByTagName( "thread_detail" );
                for( int i = 0; i < list.getLength(); i++ )
                {
                   Element subelement = (Element)list.item( i );
                   if( subelement.getParentNode() == rootElem )
                   {
                          logDebug( "Subelement " + subelement.getTagName()   );
                          NodeList list2 = subelement.getElementsByTagName( "class" );
                          for( int j = 0; j < list2.getLength(); ++j )
                          {
                                 TXText nmElem = (TXText)list2.item( j ).getFirstChild();
  
                                 String clsNm = nmElem.getNodeValue();
                                 logDebug( clsNm );
                                 classes.add( clsNm.trim() );
                          }
                   }
                }
                */

                /* work-around to disable XML parsing */
                classes.add( "com.ibm.ws.performance.threadanalyzer.utils.V353MonDetail" );
                classes.add( "com.ibm.ws.performance.threadanalyzer.utils.V353ThdDetail" );
                /* end work-around to disable XML parsing */

                logDebug( "*Analysis helper classes*" );

                for ( int i = 0; i < classes.size(); ++i )
                {
                        // methods must match one of the following signatures (with some exceptions)
                        //   public static void setProps( AnalyzerEnv, Thd )
                        //   -- or --
                        //   public static void setProps( AnalyzerEnv, Monitor )
                        // They cannot be abstract.

                        String clsNm = (String)classes.elementAt( i );
                        clsNm = clsNm.replace( '/', '.' );
                        try
                        {
                                logDebug( _sTab + "" + clsNm );

                                Class cls = Class.forName( clsNm );
                                Method m[] = cls.getDeclaredMethods();
                                for ( int j = 0; j < m.length; ++j )
                                {
                                        String methodType = "unknown";
                                        if ( m[ j ].getName().equals( "setProps" ) )
                                        {
                                                Class params[] = m[ j ].getParameterTypes();
                                                if ( params.length == 2 )
                                                {
                                                        //rptOut( params[0].getName() + " " + params[1].getName() );
                                                        if ( params[ 0 ].getName().equals( "com.ibm.ws.performance.threadanalyzer.AnalyzerEnv" ) )
                                                        {
                                                                Class retType = m[ j  ].getReturnType();
                                                                //System.out.println( retType.getName() );
                                                                int modifiers = m[ j ].getModifiers();
                                                                if ( Modifier.isStatic( modifiers ) 
                                                                         && Modifier.isPublic( modifiers )
                                                                         && !Modifier.isAbstract( modifiers ) )
                                                                {

                                                                        if ( retType.getName().equals( "void" ) )
                                                                        {
                                                                                if ( params[ 1 ]. getName().equals( "com.ibm.ws.performance.threadanalyzer.Thd" ) )
                                                                                {
                                                                                        methodType = "Thd";
                                                                                        _threadDetailHelpers.add( m[ j ] ); 
                                                                                }
                                                                                else if ( params[ 1 ]. getName().equals( "com.ibm.ws.performance.threadanalyzer.Monitor" ) )
                                                                                {
                                                                                        methodType = "Monitor";
                                                                                        _monitorDetailHelpers.add( m[ j ] ); 
                                                                                }
                                                                        }
                                                                }
                                                        }

                                                }
                                        }
                                        if ( methodType.equals( "Thd" ) || methodType.equals( "Monitor" ) )
                                        {
                                                logDebug( _sTab + _sTab + "" + m[ j ].toString() );
                                                logDebug( _sTab + _sTab + "method type: " + methodType );
                                        }
                                }
                        }
                        catch ( ClassNotFoundException cnfe )
                        {
                                logErr( _sTab + _sTab + "WARNING: " + clsNm + " described in detail XML not found." );
                        }

                }

        }

        private void rptOut( String msg )
        {
                _rptOut.println( html("<pre>") + msg + html("</pre>") );
        }
        private void rptOut2( String msg )
        {
                _rptOut.println( msg  );
        }
        private void rptOut2( )
        {
                _rptOut.println();
        }
        private void rptOut( )
        {
                _rptOut.println( html("<br>") );
        }

        private void logOut( String msg )
        {
                System.err.println( msg );
        }

        private void logErr( String msg )
        {
                System.err.println( msg );
        }

        private void logWarning( String msg )
        {
                if ( _logLevel >= DumpParser.WARNING )
                        System.err.println( "WARNING: " + msg );
        }

        private void logDebug( String msg )
        {
                if ( _logLevel >= DumpParser.DEBUG )
                        System.err.println( "DEBUG: " + msg );
        }
		//dipak
		//need to get at the logLevel for deadlock detection
		public int getLogLevel()
		{
			return _logLevel;
		}        

        private String html( String sHtml )
        {
                if ( _fHtml )
                        return sHtml;
                return "";
        }
        private String format( int minCol, int maxCol, String sIn )
        {
                String sOut = "";
                String sCur = "";
                int curCol = 1;
                StringTokenizer st = new StringTokenizer( sIn, " \t\n" );
                while ( st.hasMoreTokens() )
                {
                        while ( ++curCol < minCol )
                        {
                                sOut += " ";
                        }
                        sCur = st.nextToken();
                        curCol += sCur.length();
                        if ( curCol > minCol )
                        {
                                sOut += " ";
                                ++curCol;
                        }
                        sOut += sCur;
                        if ( curCol >= maxCol )
                        {
                                curCol = 1;
                                sOut += "\r\n";
                        }
                }
                return sOut;
        }

        public void setLogLevel( int logLevel )
        {
                _logLevel = logLevel;
        }

        public void setAnalysisType()
        {
                String analysis = DumpParser.getArg( "analyze" );
                int level = 0;
                if ( analysis.equalsIgnoreCase( "all" ) )
                        level = ANALYZE_ALL;
                if ( analysis.equalsIgnoreCase( "was" ) )
                        level = ANALYZE_WAS;
                if ( analysis.equalsIgnoreCase( "servlet" ) )
                        level = ANALYZE_SERVLET;
                if ( analysis.equalsIgnoreCase( "ejb" ) )
                        level = ANALYZE_EJB;
                if ( analysis.equalsIgnoreCase( "other" ) )
                        level = ANALYZE_OTHER;
                if ( level != 0 ) // let default stand if not set
                        _analysisType = level;
        }

        protected static String formattedVersion()
        {
                String sRet = null;

                sRet = "" + _majorVersion + "." + _minorVersion;
                if ( _majorVersion < 1 )
                {
                        sRet += " (pre-release INTERNAL USE ONLY)";
                }
                return sRet;
        }

        public int getWebWaiting()
        {
                return _webWaitThreads;
        }

        public int getWebWorking()
        {
                return _workingWebThreads;
        }

        public int getOrbWaiting()
        {
                return _orbWaitThreads;
        }

        public int getOrbWorking()
        {
                return _workingOrbThreads;
        }

        public int getOthers()
        {
                return _unknownThreads;
        }

        public int getTotal()
        {
                return _totThreads;
        }

        public void writeExternal( ObjectOutput out ) throws IOException
        {
                out.writeInt( _curVersion );

                out.writeInt( _totThreads );
                out.writeInt( _webWaitThreads );
                out.writeInt( _orbWaitThreads );
                out.writeInt( _workingOrbThreads );
                out.writeInt( _workingWebThreads );
                out.writeInt( _unknownThreads );

                out.writeInt( _analysisType );

                out.writeInt( _logLevel );
                out.writeBoolean(_fHtml );
                
                //out.writeObject( _threads );      // all threads
                // write out all threads
                int thdCount = _threads.size();
                //System.out.println( "Threads to write: " + thdCount );

                out.writeInt( thdCount );
                Enumeration e = getThreadEnum();
                Thd thd = getNextThread( e );
                while ( thd != null )
                {
                        thd.writeExternal( out );
                        thd = getNextThread( e );
                }
                // end write threads

                // write out the monitors
                //out.writeObject( _monitors );      // all monitors
                int monCount = _monitors.size();
                out.writeInt( monCount );
                e = getMonitorEnum();
                Monitor m = getNextMonitor( e );
                while ( m != null )
                {
                        m.writeExternal( out );
                        m = getNextMonitor( e );
                }
                // end write out the monitors

                //out.writeObject( _env );      // the global environment
                _env.writeExternal(out);

                out.writeObject( _inputFilename ); // file that generated this dumpdata
                out.writeInt( _threadsMissingStacks ); // number of threads missing stacks

                //out.writeObject( _threadDump ); // the original thread dump text.
                _threadDump.writeExternal(out);

                out.writeObject( _displayName ); // the user assigned name.
                out.writeObject( _description ); // the user assigned description.

                // begin version 2 data
				//dipak
				out.writeObject( dumpParserClassName );

        }

        public void readExternal( ObjectInput in ) throws IOException, ClassNotFoundException
        {
                _version             = in.readInt();

                _totThreads          = in.readInt();
                _webWaitThreads      = in.readInt();
                _orbWaitThreads      = in.readInt();
                _workingOrbThreads   = in.readInt();
                _workingWebThreads   = in.readInt();
                _unknownThreads      = in.readInt();

                _analysisType        = in.readInt();

                //_logLevel            = in.readInt();
                in.readInt();
                _fHtml               = in.readBoolean();

                // read in the threads
                //_threads             = (Hashtable)in.readObject();      // all threads
                int thdCount         = in.readInt();
                //System.out.println( "Threads to read: " + thdCount );
                if ( _threads == null )
                        _threads = new Hashtable();
                for ( int i = 0; i < thdCount; ++i )
                {
                        Thd thd = new Thd();
                        thd.readExternal( in );

                        _threads.put( thd.getThreadId(), thd );
                }
                // end read threads 

                // read in the monitors
                //_monitors            = (Hashtable)in.readObject();      // all monitors
                int monCount         = in.readInt();
                //System.out.println( "Monitors to read: " + monCount );
                if ( _monitors == null )
                        _monitors = new Hashtable();
                for ( int i = 0; i < monCount; ++i )
                {
                        Monitor mon = new Monitor();
                        mon.readExternal( in );

                        _monitors.put( mon.getName(), mon );
                }
                // end read threads 

                //_env                 = (AnalyzerEnv)in.readObject();      // the global environment
                _env = new AnalyzerEnv();
                _env.readExternal(in);

                _inputFilename       = (String)in.readObject(); // file that generated this dumpdata
                _threadsMissingStacks = in.readInt(  ); // number of threads missing stacks

                //_threadDump          = (ThreadDump)in.readObject(  ); // the original thread dump text.
                if(_threadDump == null) //dipak
                {
                _threadDump = new ThreadDump();
                }
                _threadDump.readExternal( in );
                _displayName         = (String)in.readObject(); // the display name
                _description         = (String)in.readObject(); // high level description

                // 173422 - check for version 2 data
                // if the version is < 2, then init data to null and skip read since it doesn't exist.
				//dipak
                if( _version >= 2 )  // 173422
				dumpParserClassName  = (String)in.readObject();
                else dumpParserClassName = null; // 173422

                fixupIdRefs();


        }

        //dipak
        public Hashtable getThreads() {
                return _threads;
        }
        //dipak
        public Hashtable getMonitors() {
                return _monitors;
        }
        //dipak
        public ThreadDump getThreadDump() {
                return _threadDump;
        }
        //dipak
        public void setDeadLockResults(Vector dlr) 
        {
                deadlockResults = dlr;
        }
        //dipak
        public void setDeadLockExists(boolean dle) 
        {
                deadlockExists = dle;
        }

        //elton
        public boolean isDeadLockExists() 
        {
                return deadlockExists;
        }
        //dipak
        public void setDumpParserClassName(String dpcn) {
        	dumpParserClassName = dpcn;
        }
        public String getDumpParserClassName(){
        	return dumpParserClassName;
        }
        
        public String getDumpParserClassNameFromDumpData()
        {
          int file_type;
          file_type = DumpParser.getDumpParserTypeFromDumpData( this );
          DumpParser d = DumpParser.createParser( file_type, null );
          if ( d != null )
            return d.getClass().getName();
          else 
            return null;
        }
                
        
        //private String dummyStreamTestVar = null;
        protected int _totThreads = 0;
        protected int _webWaitThreads = 0;
        protected int _orbWaitThreads = 0;
        protected int _workingOrbThreads = 0;
        protected int _workingWebThreads = 0;
        protected int _unknownThreads = 0;

        protected int _analysisType               = ANALYZE_WAS;

        private int _logLevel          = DumpParser.DETAIL;
        public  boolean _fHtml         = false;
        private Hashtable _threads     = null;          // all threads
        private Hashtable _monitors    = null;          // all monitors
        public AnalyzerEnv _env        = null;          // the global environment
        protected String _inputFilename = null; // file that generated this dumpdata
        public int _threadsMissingStacks = 0; // number of threads missing stacks
        protected ThreadDump _threadDump = null; // the original thread dump text.
        protected String _description = null; // user assigned description of the dumpdata
        protected String _displayName = null; // user assigned name of this dumpdata
        // end of version 1 data
        // version 2 data begins here...
        protected String dumpParserClassName				= null;
        // version 3 data begins here...
        protected String _dumpingJvmName = null; // name of dumping JVM

        //
        // ONLY STATIC and transients below this line
        //
        protected static final String _sTab = "   ";
        transient protected ResourceBundle _tosTrans = null;
        protected static int _majorVersion = 1;
        protected static int _minorVersion = 1;

        protected transient PrintStream _rptOut = System.out;
        // handle analyze=[all | was | servletonly | ejb ] using bitflags
        public final static int ANALYZE_SERVLET   = 1; 
        public final static int ANALYZE_EJB       = 2;
        public final static int ANALYZE_WAS       = ANALYZE_SERVLET | ANALYZE_EJB;
        public final static int ANALYZE_OTHER     = 0x00008000;
        public final static int ANALYZE_ALL       = -1;
        private static int _curID      = 0;
        transient public Hashtable _threadsByTOS = null;          // lists of threads with same TOS. TOS is key
        transient public TOSInfo   _tosInfo      = null; 
        transient public Vector _threadDetailHelpers = null;  // helpers to grok thread stacks for various WAS versions
        transient public Vector _monitorDetailHelpers = null; // helpers to grok monitor information for various WAS versions
        //dipak Vector for deadlock detection results.
        transient private Vector deadlockResults                  = null;  // 173422
        transient private boolean deadlockExists                  = false; // 173422
//WARNING:  This object is versioned.  If changes are made to the persistent object structure,
//                  the versioning code must be updated.
        
};

class ThdGrp implements Serializable
{
        // not used.  Groups are bypassed since
        // the thread dumps don't contain
        // thread group information.
        public ThdGrp( String name )
        {
                _name = name;
                _ID = DumpData.getID();
                _threads = new Hashtable();
        }


        public String _name = null;
        public int _ID = -1;
        public Hashtable _threads = null; // all threads in this group

}

