package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

//B import com.ibm.ws.performance.threadanalyzer.tagui.TaGUI;


/*
  
  Tops of stacks. 
      - creates object model that pulls out some of the relationships
         between stack frames allowing "views" to be built by the
         GUI that show the various "entry points" that arrive at 
         a given set of Tops of Stacks.
         These "entry points" also contain lists of entry point callers
         to allow views based on the callers of the routine that 
         is bottlenecked.
                                               
  NOTE: the hashtable _threadsByTOS contained in DumpData should
         have been part of this object.  However, the change
         will be too big to incorporate it now.  Maybe later.  For now,
         the _threadsByTOS is taken as a ctor parameter.
*/
public class TOSInfo
{

   // for now, DumpData.initAnalysis() will build
   // threadsByTOS, ctor a TOSInfo and pass in
   // threadsByTOS.  Later, the building of 
   // TBTOS should be moved to this object.
   public TOSInfo( Hashtable threadsByTOS )
   {
      _oldThreadsByTOS = threadsByTOS;
      // using tos HT, build another (yes, unfortunately)
      // similar to it except that it can contain
      // the entry point objects and doesn't contain the
      // entire thread list by TOS (it would be more redundant)

      _threadsByTOS = new Hashtable();
      build();


   }


   public int tosCount()
   {
      return _threadsByTOS.size();
   }

   public Hashtable getTosHT()
   {
      return _threadsByTOS;
   }

   protected void build()
   {
      // for each TOS, use the thread list to determine 
      // the entry points.  For each entry point build
      // an inverted list of the callers
      // uses: TOSEntryPoint and TOSEntryPointCaller

      // 1. for each tos, build a list of lists of
      //    threads with same stack config.  One will
      //    be selected as a prototype for each 
      //    different stack configuration (continue
      //    to track the threads with same stack
      //    config).
      // 2. for each prototype, compare the stacks
      //    to find the common entry points.
      // 2a. find first difference with each other
      //     prototype.
      // 2b. Stacks with same first difference point
      //     have common entry point at that location.
      // 2c. Create a TOSEntryPoint object containing
      //     a prototype stack entry at this point along
      //     with the list of all the threads with this same
      //     entry point.  Union of all prototype thread lists.
      Enumeration enum = _oldThreadsByTOS.keys();
      while( enum.hasMoreElements() )
      { // for each top of stack do the ops outlined above
         Vector entryPoints = new Vector();
         Vector allThreads = null;
         Vector prototypes = new Vector();
         String tos = (String)enum.nextElement();
         allThreads = (Vector)_oldThreadsByTOS.get( tos );

         if( allThreads.size() < 1 )
            break;
         Thd thd = (Thd)allThreads.elementAt( 0 );

         Proto proto = new Proto();
         proto._threads.add( thd ); // create new prototype with first thread
         prototypes.add( proto ); // keep track of this new proto

         for( int i = 1; i < allThreads.size(); ++i ) // skip first thread
         {
            boolean fAdded = false;
            thd = (Thd)allThreads.elementAt( i );
            for( int j = 0; j < prototypes.size(); ++j )
            {
                /*
               if( ++dotCountMinor == 100 )
               {
                   TaGUI.getOpenExistingDialog().append( "." );
                   dotCountMinor = 0;
                   dotCountMajor++;
               }

               if( dotCountMajor == 50 )
               {
                   TaGUI.getOpenExistingDialog().append( "\r\n" );
                   dotCountMajor = 0;
               }
               */

               proto = (Proto)prototypes.elementAt( j );
               Thd thd2 = proto.getPrototype();

               if( compareStack( thd, thd2 ) )
               {
                  proto._threads.add( thd );
                  fAdded = true;
                  break;
               }

            }
            if( !fAdded )
            {
               proto = new Proto();
               proto._threads.add( thd );
               prototypes.add( proto );
            }
         }

         //TaGUI.getOpenExistingDialog().append( "\r\nComparing prototypes\r\n" );
 
         dotCountMinor++;
//B      TaGUI.getOpenExistingDialog().append( "." );

         // now there should be a list of prototypes with unique stack
         // configurations (each prototype also has a list of the threads 
         // having the same stack configurations)

         // now compare the prototype stacks to build the entry point list
         if( prototypes.size() > 1 )
         {
            for( int i = 0; i < prototypes.size()-1; ++i )
            {
               //dotCountMinor = 0;

               Proto proto1 = (Proto)prototypes.elementAt( 0 );
               for( int j = i+1; j < prototypes.size(); ++j )
               {
                  mark();

                  Proto proto2 = (Proto)prototypes.elementAt( j );
                  int idx = compareForStkSimilarity( proto1, proto2 );
                  if( idx > 1 )
                  {
                     // check to see if this is an existing
                     //    TOSEntryPoint.
                     // If so, then add the threads from both protos
                     //    but check to make sure the threads are
                     //    not duplicates for this entry point.
                     // If the TOSEntryPoint does not already exist,
                     //    then create a new one and add the threads
                     //    from both protos. 

                     TOSEntryPoint tep = findEntryPoint( proto1, idx, entryPoints );
                     if( tep != null )
                     {
                        tep.addThreadsNoDups( proto1._threads );
                        tep.addThreadsNoDups( proto2._threads );
                     }
                     else
                     {
                        StkEntry se = proto1.getPrototype().getStkEntry( idx );
                        if( se != null )
                        {
                           tep = new TOSEntryPoint( se );
                           tep.addThreadsNoDups( proto1._threads );
                           tep.addThreadsNoDups( proto2._threads );
                           entryPoints.add( tep );
                        }
                     }

                  }
               }
            }
         }

         if( entryPoints != null && entryPoints.size() > 0 )
            _threadsByTOS.put( tos, entryPoints );

      }

      /*
      enum = _threadsByTOS.keys();
      while( enum.hasMoreElements() )
      {
         String tos = (String)enum.nextElement();
         Vector entryPoints = (Vector)_threadsByTOS.get( tos );
         System.out.println( "TOS----" + tos );
         for( int i = 0; i < entryPoints.size(); ++i )
         {
            TOSEntryPoint ep = (TOSEntryPoint)entryPoints.elementAt( i );
            String epName = ep.getName();
            if( epName != null )
            {
               System.out.println( "    EP: " + epName );
            }
         }
      }
      */
      

   }

   private void mark()
   {
       if( dotCountMinor++ == 100 )
       {
//B        TaGUI.getOpenExistingDialog().append( "." );
           dotCountMinor = 0;
           dotCountMajor++;
       }

       if( dotCountMajor == 50 )
       {
//B        TaGUI.getOpenExistingDialog().append( "\r\n" );
           dotCountMajor = 0;
       }
   }

   protected int compareForStkSimilarity( Proto proto1, Proto proto2 )
   {
      Thd t1 = proto1.getPrototype();
      Thd t2 = proto2.getPrototype();
      StkEntry se1 = null;
      StkEntry se2 = null;
      int idx = 0;
      while( idx < t1.getStkSize() && idx < t2.getStkSize() )
      {
         if( t1.getStkEntry( idx ).getFQName().equals( t2.getStkEntry( idx ).getFQName() ))
         {
            ++idx;
            continue;
         }
         break;
      }
      return idx;
   }

   protected TOSEntryPoint findEntryPoint( Proto proto, int idx, Vector entryPoints )
   {
      TOSEntryPoint tRet = null;
      for( int i = 0; i < entryPoints.size(); ++i )
      {
         TOSEntryPoint ep = (TOSEntryPoint)entryPoints.elementAt( i );
         if( ep != null && idx < proto.getPrototype().getStkSize() )
         {
            String epName = ep.getName();
            StkEntry protoSe = proto.getPrototype().getStkEntry( idx );
            //System.out.println(" -----" );
            //protoSe.print( 1 );
            //System.out.println(" -----" );
            if( epName.equals( protoSe.getFQName() ))
            {
               // entry is the same, now compare the stacks to make sure they're
               // the same path.
               Thd thd1 = (Thd)ep._threads.elementAt( 0 );
               Thd thd2 = proto.getPrototype();

               tRet = ep;
               for( int j = 0; j <= idx; ++j )
               {
                  if( ! thd1.getStkEntry( idx ).getFQName().equals( thd2.getStkEntry( idx ).getFQName() ))
                  {
                     tRet = null;
                     break;
                  }
               }
            }
         }
         if( tRet != null )
            break;
      }
      return tRet;
   }

   protected boolean compareStack( Thd t1, Thd t2 )
   {
      boolean fRet = false;
      if( t1.getStkSize() == t2.getStkSize() )
      {
         for( int i = 0; i < t1.getStkSize(); ++i )
         {
            if( ! t1.getStkEntry( i ).getFQName().equals( t2.getStkEntry( i ).getFQName() ))
               break;
         }
      }
      return fRet;
   }

   // add getFirstThread, getNextThread to emulate _threadsByTOS from dumpdata
   // so that clients of _threadsByTOS have a migration path.

   protected Vector     _entryPoints      = null;
   protected Hashtable  _oldThreadsByTOS  = null;
   protected Hashtable  _threadsByTOS     = null;

   private static int dotCountMinor = 0;
   private static int dotCountMajor = 0;

}

class Proto
{
   Proto()
   {
      _threads = new Vector();
   }

   Thd getPrototype()
   {
      Thd tRet = null;
      if( _threads != null && _threads.size() > 0 )
         tRet = (Thd)_threads.elementAt( 0 );
      return tRet;
   }
   Vector _threads = null;
}
