package org.eclipse.hyades.collection.threadanalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;
//B import com.ibm.ws.performance.threadanalyzer.getthreaddump.GetThreadDump;
//B import com.ibm.ws.performance.threadanalyzer.tagui.TaGUI;


public class ThreadAnalyzer
{
   private static ThreadAnalyzer instance = null;
   private static boolean cmdLine = false;

   public static void main( String args[] )
   {
	   instance = new ThreadAnalyzer();

//       instance.cmdLine       = true;
//      instance.myDummyDialog = new DummyDialog();
       ThreadAnalyzer.cmdLine       = true;
       ThreadAnalyzer.myDummyDialog = new DummyDialog();

       try
       {
           instance.doIt(args);
       }
       catch( TaTimedOutException ttoe )
       {
       }
       System.exit(0);
   }

   public static DummyDialog getDummyDialog()
   {
       return myDummyDialog;
   }

   public static boolean inCmdLineMode()
   {
       return cmdLine;
   }

   public boolean doIt( String args[] )
      throws TaTimedOutException
   {
      //Properties env = new Properties();
      Vector env = new Vector();
      String thePath = null;
      String wasHome = null;
      String javaExe = null;
      try
      {
         BufferedReader r = new BufferedReader( new InputStreamReader( System.in ));
         while( r.ready() )
         {
            String sIn = r.readLine();
            //System.out.println( "'" + sIn + "'" );
            if( sIn != null && sIn.length() > 0 )
            {
               int idx = sIn.indexOf( "=" );
               if( idx != -1 )
               {
                  String sKey = sIn.substring( 0, idx );
                  if( idx+1 > sIn.length() )
                     continue;
                  String sVal = sIn.substring( idx+1 );
                  //System.out.println( sIn + " -- " + sKey + " ==== " + sVal );
                  //env.setProperty( sKey, sVal );
                  if( !sKey.equalsIgnoreCase( "path" ) )
                     env.add( sIn );
                  else thePath = sVal;
                  if( sKey.equalsIgnoreCase( "was_home" ) )
                     wasHome = sVal;
                  if( sKey.equalsIgnoreCase( "java_exe" ) )
                     javaExe = sVal;
               }
            }
         }
      }
      catch( IOException ioe )
      {
         System.err.println( TAUtils.getNLSValue("ta.errmsg.CannotReadEnv", "Cannot read environment")+"." );
      }
      parseArgs( args );

      if( getArg( "was_home" ) != null )
      {
         wasHome = getArg( "was_home" );
      }
      else putArg( "was_home", wasHome );


      if( wasHome == null )
      {
         System.err.println( "was_home " + TAUtils.getNLSValue("ta.errmsg.NotSet", "not set") + "." );
         syntax();
      }

      String myClasspath = System.getProperty( "java.class.path" );
      String myPath = (thePath != null ? thePath : "") + System.getProperty( "path.separator" ) + System.getProperty( "java.library.path" );

	  try
	  {
		  getProductVersion( wasHome + "/properties/com/ibm/websphere/product.xml" );
	  }
	  catch( FileNotFoundException not40 )
	  {

		  try
		  {
			  File baseProductFile   = new File( wasHome + "/properties/version/BASE.product" );
			  File bobcatProductFile = new File( wasHome + "/properties/version/embeddedEXPRESS.product" );

			  if( ! baseProductFile.exists() &&
                  ! bobcatProductFile.exists()
                )
			  {
				 logError( "WAS 5.0 not detected" );
				 throw new FileNotFoundException();
			  }

			  // BASE.product or embeddedEXPRESS.product file was found so it must be 5.0
			  _edition = "BASE";
		  }
		  catch( FileNotFoundException not50 )
		  {
			  logError( "No valid WAS installation detected." );
			  return false;
		  }
	  }

      logDebug( TAUtils.getNLSValue("ta.logdebug.ProductEdition", "Product edition") + ": " + _edition );

      loadWasProps();

      File fTemp = null;

      if( javaExe == null )
      {
         javaExe = getWasJavaExe();
         //System.out.println( "Java exe = " + javaExe );
      }

      logDebug("[ThreadAnalyzer] servername: " + getArg("servername"));

      if( getArg( "servername" ) != null )
      {
         logDebug("[ThreadAnalyzer] dumpOut: " + getArg("dumpOut"));

//B      if( TaGUI.getInstance() == null )
//B      {
//B          TaGUI.setServer   ( getArg ("serverName"));
//B          TaGUI.setSoapPort ( Integer.parseInt( getArg ("soapPort")));
//B      }

         if( getArg( "dumpOut" ) == null )
         {
            logDebug("[ThreadAnalyzer] dumpOut == null");
            // create a tempfile for dumpout
            try
            {
               if( getArg( "tmpDir" ).equalsIgnoreCase( "system" ))
               {
                  fTemp = File.createTempFile( "thread_", ".analyzed" );
               }
               else
               {
                  fTemp = File.createTempFile( "thread_", ".analyzed", new File( getArg( "tmpDir" )));
               }
               fTemp.deleteOnExit(); 
            }
            catch( IOException ioe )
            {
               System.err.println( TAUtils.getNLSValue("ta.errmsg.ErrCreatingTempFile", "Error creating temp file.") );

			   ioe.printStackTrace();
			   return false;
               //System.exit( 1 );
            }
            _args.put( "dumpOut".toUpperCase(), new Arg( fTemp.getPath() ));
            //System.err.println( "Using temp file: " + f.getPath() );
         }

         try
         {
             if( ! getThreadDump( javaExe, wasHome, env, myClasspath, myPath ) )
                 return false;
         }
         catch( TaTimedOutException ttoe )
         {
             logDebug("[ThreadAnalyzer] throwing TaTimedOutException");
             throw ttoe;
         }
//		 _args.put("analyze".toUpperCase(), new Arg("none"));
      }
      else
      {
         _args.put( "dumpOut".toUpperCase(), new Arg( getArg( "dumpIn" )));
      }


      if( ! getArg( "analyze" ).equalsIgnoreCase( "none" ) )
      {

         String outFilename = new String();
         try
         {
            if( getArg( "reportOut" ).equalsIgnoreCase( "default" ))
            {
               String dumpOut = getArg( "dumpOut");

               if( getArg( "reportType" ).equalsIgnoreCase( "html" ))
                  outFilename = dumpOut + ".html";
               else
                  outFilename = dumpOut + ".txt";
            }
            else
            {
               outFilename = getArg( "reportOut" );
            }
            File fOut = new File( outFilename );
            logDebug("[ThreadAnalyzer] deleting: " + outFilename);
            fOut.delete(); // delete it if it already exists
            outFilename = fOut.getCanonicalPath();
            
         }
         catch( IOException ioe )
         {
			ioe.printStackTrace();
            System.err.println( TAUtils.getNLSValue("ta.errmsg.ErrorOn", "error on") + " " + outFilename );
            ioe.getMessage();
         }

         parseAndAnalyze( javaExe, env, myClasspath, myPath, outFilename );

         Process p = null;

         String osName = System.getProperty( "os.name" );

         boolean fRptOut = getArg( "streamOut" ) == null && !getArg( "reportType" ).equalsIgnoreCase( "none" );
         File fOut = new File( outFilename );

         if( fRptOut && fOut.exists() )
            logInfo( TAUtils.getNLSValue("ta.errmsg.OutputFile", "Output file") + ": " + outFilename );

         if( getArg( "StreamOut" ) == null &&
             getArg( "reportType" ).equalsIgnoreCase( "html" )
           )

         { // if writing streamout or the reporttype is text,
           //     then do not pop up browser

            if( osName.indexOf("Windows") != -1 )
            {
               String cmd[] = 
               {
                  "cmd.exe",
                  "/c",
                  outFilename
               };

               try
               {
                  logInfo( "attempting to launch browser..." );
                  p = Runtime.getRuntime().exec (cmd);

               }
               catch( IOException ioe )
               {
                  System.err.println
                  (
                      TAUtils.getNLSValue
                      (
                         "ta.errmsg.CannotStartBrowser",
                         "Cannot start browser"
                      )  + "."
                  );
               }

               (new TAReaderThread( p.getInputStream(),
                                    p.getErrorStream(),
                                    System.out )
               ).start();

            }
            else
            {
               String cmd[] = 
               {
                  "netscape",
                  outFilename
               };

               try
               {
                  logInfo( "attempting to launch browser..." );
                  p = Runtime.getRuntime().exec (cmd);

                  (new TAReaderThread( p.getInputStream(),
                                       p.getErrorStream(),
                                       System.out )
                  ).start();

                  try
                  {
                     p.waitFor();
                  }
                  catch( InterruptedException ie )
                  {
                  }
               }
               catch( IOException ioe )
               {
                  System.err.println
                  (
                      TAUtils.getNLSValue
                      (
                          "ta.errmsg.CantStartNetscape",
                          "Netscape could not be started"
                      )
                  );
               }

            }
         }
      }

	  return true;
   }

   protected void parseAndAnalyze( String javaExe, Vector env, String myClasspath, String myPath, String outFilename )
   {
	  String[] args =
      {
         "logLevel="    + getArg( "loglevel" ),
         "dumpIn="      + getArg( "dumpOut" ),
         "reportType="  + getArg( "reportType" ),
         "reportOut="   + outFilename,
         "analyze="     + ( getArg( "analyze" ) == null ? "all" : getArg( "analyze" )),
         (getArg( "StreamOut" ) == null ? "" : "StreamOut="+getArg( "StreamOut" ))
      };

	  (new DumpParser( cmdLine )).doIt( args );
   }

   protected boolean getThreadDump( String javaExe, String wasHome, Vector env, String myClasspath, String myPath )
      throws TaTimedOutException
   {
      Runtime r = Runtime.getRuntime();

      env.add( "PATH="  + _adminPath + System.getProperty( "path.separator" ) + myPath );

      String cmdLine[] = 
      {
         javaExe,
         "-classpath",
         //_adminClasspath + System.getProperty( "path.separator" ) + myClasspath,
         myClasspath,
         "com.ibm.ws.performance.threadanalyzer.getthreaddump.GetThreadDump",
         "loglevel="   + getArg( "loglevel" ),
         "dumpWait="   + getArg( "dumpWait" ),
         "servername=" + getArg( "servername" ),
         "was_home="   + wasHome,
         "dumpOut="    + getArg( "dumpOut" ),
         "dumpType="   + getArg( "dumpType" )
      };

      Process p = null;

      TAReaderThread rThd = null;
      try
      {
         String envp[] = new String[ env.size() ];
         for( int i = 0; i < env.size(); ++i )
         {
            envp[ i ] = (String)env.elementAt( i );
            //System.out.println( envp[i] );
         }

         //System.out.println( "Executing: " + cmdLine[0] );
		 /*
         p = r.exec( cmdLine, envp );

         InputStream out = p.getInputStream();
         InputStream err = p.getErrorStream();
         rThd = new TAReaderThread( out, err, null );
         rThd.start();
		 */

//B		 this.getDumpInstance = new GetThreadDump();
		 String[] getDumpArgs = {

			 "loglevel="   + getArg( "loglevel" ),
			 "dumpWait="   + getArg( "dumpWait" ),
			 "servername=" + getArg( "servername" ),
			 "was_home="   + wasHome,
			 "dumpOut="    + getArg( "dumpOut" ),
			 "dumpType="   + getArg( "dumpType" )
		 };

//B		 if( ! getDumpInstance.doIt( getDumpArgs ) )
//B			 return false;


      }
//B   catch( TaTimedOutException ttoe )
//B   {
//B       throw ttoe;
//B   }
      catch( Exception e )
      {
		  /*
         System.err.println( TAUtils.getNLSValue("ta.errmsg.CannotExecute", "Cannot execute") + " " + cmdLine[ 0 ] );
         System.err.println( e.getMessage() );
         System.exit( 1 );
		 */
		  e.printStackTrace();
      }

      //System.out.println( "Waiting" );

	  /*
      try
      {
//         p.waitFor(); 
//		 System.err.println( "GetThreadDump process returned" );
         // wait a few seconds for all child output
         Thread.sleep( 3000 ); 
      }
      catch( InterruptedException ie )
      {
         // nada
      }
	  */

	  // method succeeded
	  return true;
   }

   protected static void loadWasProps()
   {
	  if( _edition == null || _edition.equalsIgnoreCase("BASE")  )
		  return;

      if( _edition.equalsIgnoreCase( "AEs" ) )
      {
         _adminClasspath = "";
         _adminPath = "";
      }
      else
      {
         _adminClasspath = getAdminProperty( "com.ibm.ejs.sm.adminserver.classpath" );
         _adminPath      = getAdminProperty( "com.ibm.ejs.sm.util.process.Nanny.path" );
      }
   }

   protected static String getWasJavaExe()
   {
      String javaExe = null;
      if( _edition.equalsIgnoreCase( "AEs" ) || _edition.equalsIgnoreCase( "BASE" ) )
      {
         javaExe = getArg( "WAS_HOME" ) + "/java/jre/bin/java";
      }
      else
      {
         javaExe = getAdminProperty( "com.ibm.ws.jdkexe.path" );
         if( javaExe == null )
         {
            javaExe = getAdminProperty( "com.ibm.ws.jdk.path" );
            if( javaExe != null )
               javaExe += "/bin/java";
         }
      }
      File f = new File( javaExe );
      javaExe = f.getAbsolutePath();
      return javaExe;

   }

   public static void traverse( Node root, Node cur, String searchNode, String searchKey )
   {
      if( cur == root ) return;
      if( root == null )
         root = cur;
      //String nodeName = cur.
      for( Node n = cur.getFirstChild(); n != null; n = n.getNextSibling() )
      {

         String nodeName = n.getNodeName();

         //System.out.println( "Subelement " + nodeName );
         if( nodeName.equalsIgnoreCase( "edition" ) && searchNode.equals( "edition" ) )
         {
            logDebug( "!!!!" + "edition" + "!!!!" );
            traverse( root, cur, "value", "" );
            return;
         }
         if( nodeName.equalsIgnoreCase( "value" ) && searchNode.equals( "value" ) )
         {
            logDebug( "!!!!" + "value" + "!!!!" );
			logDebug( "nodeName = " + nodeName );
            NodeList nl = cur.getChildNodes();
            logDebug( "children = " + nl.getLength() );
            for( int i = 0; i < nl.getLength(); ++i )
            {
               String nodeNm = nl.item(i).getNodeName();
			   logDebug( "nodeNm[" + i + "] = " + nodeNm );
               if( nodeNm.equals( "value" ) )
               {
                  _edition = ((CharacterData)nl.item(i).getFirstChild()).getData();
               }
            }
            return;
         }

         if( nodeName.equalsIgnoreCase( "servers" ) && searchNode.equals( "servers" ) )
         {
            logDebug( "!!!!" + "servers" + "!!!!" );
            NamedNodeMap nm = n.getAttributes();
            logDebug( ":=> " + nm.getNamedItem( "name" ) );
            if( nm.getNamedItem( "name" ).getNodeValue().equalsIgnoreCase( searchKey ) )
               traverse( root, n, "ioRedirect", "" );
            return;

         }

         if( nodeName.equalsIgnoreCase( "pathMap" ) && searchNode.equals( "pathMap" ) )
         {
            logDebug( "!!!!" + "pathMap" + "!!!!" );
            NodeList l = n.getChildNodes();

            for( int i = 0; i < l.getLength(); ++i )
            {
               NamedNodeMap  nm = l.item( i ).getAttributes();
               if( nm != null )
               {
                  Node item = nm.getNamedItem( "symbolicName" );
                  if( item != null )
                  {
                     String symName = item.getNodeValue();
                     String path = nm.getNamedItem( "path" ).getNodeValue();
                     logDebug( symName + "=" + path );
                     _pathMap.put( symName, path );
                  }
               }
            }
            logDebug( "---Translated paths---" );
            Enumeration enum = _pathMap.keys();
            String pathKey = null;
            for( ; enum.hasMoreElements(); )
            {
               pathKey = (String)enum.nextElement();
               String path = _pathMap.getProperty( pathKey );
               path = replacePathVar( _pathMap ,path );
               File f = new File( path );
               String cpath = null;
               try
               {
                  cpath = f.getCanonicalPath();
               }
               catch( Throwable t )
               {
                  cpath = "?????";
               }
               logDebug( pathKey + "=" + cpath );
            }
            logDebug( "------" );
         }

         traverse( root, n, searchNode, searchKey );

      }
   }


   public static String replacePathVar( Properties _pathMap, String path )
   {
      String repVar = null;

      int idx1 = -1;
      while( ( idx1 = path.indexOf( "${" )) != -1 )
      {
         int idx2 = path.indexOf( "}" );
         if( idx2 != -1 )
         {
            repVar = path.substring( idx1+2, idx2 );
            String repVal = _pathMap.getProperty( repVar );
            logDebug( repVar + " is " + repVal );
            String tmpPath = null;
            if( idx1 > 0 )
            {
               tmpPath = path.substring( 0, idx1 );
               tmpPath += repVal;
            }
            else tmpPath = repVal;
            //tmpPath += "/";
            tmpPath += path.substring( idx2+1 );
            path = tmpPath;
         }
      }
      return path;
   }

   public static void getProductVersion( String xmlName )
   throws FileNotFoundException
   {
      //NonValidatingTXDOMParser parser = new NonValidatingTXDOMParser( );
      DocumentBuilderFactory xmlDbf = DocumentBuilderFactory.newInstance();
      Document inDoc= null;
      try
      {
         File xmlFile = new File( xmlName );

         if( ! xmlFile.exists() )
         {
            logDebug( "[ThreadAnalyzer] " + TAUtils.getNLSValue("ta.errmsg.FileDoesntExist", "File doesn't exist") + ": " + xmlFile );
			throw new FileNotFoundException();
         }
         xmlDbf.setValidating( false );
         DocumentBuilder xmlDb = xmlDbf.newDocumentBuilder();
         URL url = xmlFile.toURL();

         inDoc = xmlDb.parse( url.toString() );
      }
	  catch( FileNotFoundException fnfe )
	  {
		 throw fnfe;
	  }
      catch( Exception e )
      {
         logDebug( TAUtils.getNLSValue("ta.errmsg.XmlParseError", "XML parse error or XML input file not found") + ".  --" + e.getMessage() );
		 e.printStackTrace();
      }

      //TXDocument inDoc = (TXDocument)parser.getDocument();

      Element rootElem = inDoc.getDocumentElement();
      if( rootElem == null )
      {
         logError( TAUtils.getNLSValue("ta.errmsg.CantReadXmlConfig", "Unable to read configuration xml document") + "." );
      }

      NodeList list = null;

      list = rootElem.getElementsByTagName("websphere");

      traverse( null, rootElem, "edition", "" );
      traverse( null, rootElem, "version", "" );

   }

   protected static void logDebug( String sMsg )
   {
      if( _logLevel >= DEBUG )
         System.err.println( "DEBUG: " + sMsg );
   }

   protected static void logError( String sMsg )
   {
      System.err.println( TAUtils.getNLSValue("ta.button.Error", "ERROR") + ": " + sMsg );
   }

   protected static void logInfo( String sMsg )
   {
      if( _logLevel >= INFO )
          System.err.println( "INFO: " + sMsg );
   }

   protected static String getAdminProperty( String property )
   {
      if( _adminProperties == null )
      {
         String wasHome = getArg( "was_home" );
         String adminConfig = wasHome + "/bin/admin.config";
         _adminProperties = new Properties();
         try
         {
            _adminProperties.load( new FileInputStream( adminConfig ));
         }
         catch( IOException e )
         {
            System.err.println( TAUtils.getNLSValue("ta.errmsg.CannotLoad", "Cannot load") + " " + adminConfig );
         }

      }
      String sRet = (String)_adminProperties.getProperty( property );
      //System.out.println( sRet );
      return sRet;
   }

   protected static void syntax()
   {
      System.out.println( "ThreadAnalyzer");
      System.out.println( "    " + TAUtils.getNLSValue("ta.string.syntax", "syntax") + ":");
      System.out.println( "       { was_home=path to WebSphere (default from environment) }");
      System.out.println( "       { serverName={servername | admin} }");
      System.out.println( "       [ soapPort=portNumber (default is 8880) ]");
      System.out.println( "       [ dumpOut=filename ] (default is temporary file)");
      System.out.println( "       [ dumpWait=waitSeconds ] (time to wait for threaddump to complete) ");
      System.out.println( "       [ reportType={ TEXT | HTML | NONE } ( default is HTML ) ] ");
      System.out.println( "       [ logLevel={ERROR | DETAIL | DEBUG} ] (default:DETAIL)");
      //System.out.println( "       [ logLevel={ERROR | WARN | INFO | DETAIL | DEBUG} ] (default:DETAIL)");
      //streamin is undoc'd System.out.println( "   { streamIn=filename | dumpIn=filename }";
      System.out.println( "       [ dumpIn=filename ]");
      System.out.println( "       [ tmpDir={ dirname | SYSTEM } (default: SYSTEM) ]");
      //System.out.println( "   [ streamOut=filename ] ";
      //System.out.println( "   [ detailXML=filename (defaults to ./threadanalyzerdetail.XML)]";
      System.out.println( "       [ reportOut={ DEFAULT | filename } ] (default is [dumpOut].html) ");
      //System.out.println( "       [ dumpType={ old | new } ]";
      System.out.println( "       [ dbDriver={JDBC driver class name} ]");
      System.out.println( "       [ dbURL={JDBC server/database URL} ]");
      System.out.println( );
   }

   public static String getArg( String argName )
   {
      String sRet = null;
      Arg arg = (Arg)_args.get( argName.toUpperCase() );
      if( arg != null )
         sRet = arg.get();
      else
      {
         System.err.println( TAUtils.getNLSValue("ta.errmsg.CantFind", "can't find") + ": " + argName.toUpperCase() );
      }
      return sRet;
   }

   public static void putArg( String argName, String argVal )
   {
      _args.put( argName.toUpperCase(), new Arg( argVal ));
   }

   protected static void parseArgs( String args[] )
   {
      for( int i = 0; i < _validArgNames.length; ++i )
      {
         //System.out.println( "Put: " + _validArgNames[ i ] );
         String sArg = null;

         if( _validArgNames[ i ].equals( "dumpWait" ) )
            sArg = "45";

         if( _validArgNames[ i ].equals( "detailXML" ) )
            sArg = "./threadanalyzerdetail.xml";

         if( _validArgNames[ i ].equals( "reportOut" ) )
            sArg = "default";

         if( _validArgNames[ i ].equals( "reportType" ) )
            sArg = "html";

         if( _validArgNames[ i ].equals( "logLevel" ) )
            sArg = "detail";

         if( _validArgNames[ i ].equals( "analyze" ) )
            sArg = "all";

         if( _validArgNames[ i ].equals( "tmpDir" ) )
            sArg = "SYSTEM";

         if( _validArgNames[ i ].equals( "dumpType" ) )
            sArg = "old";

         if( _validArgNames[ i ].equals( "soapPort" ) )
            sArg = "8880";

         _args.put( _validArgNames[ i ].toUpperCase(), new Arg( sArg ) );
      }

      Enumeration enum = null;

      String key = null;

      for( int i = 0; i < args.length; ++i )
      {
         int idx = args[ i ].indexOf( "=" );
         if( idx > -1 )
         {
            key = args[ i ].substring( 0, idx );
            if( _args.get( key.toUpperCase() ) != null )
            {
               String value = null;
               idx = args[i].toUpperCase().indexOf( key.toUpperCase() + "=" );
               if( idx == -1 )
                  syntax();
               idx = args[i].indexOf( "=" );
               value = args[i].substring( idx+1 );
               if( value.length() <= 0 )
                  syntax();
               if( key.equalsIgnoreCase( "logLevel" ) )
               {
                  if( value.equalsIgnoreCase( "ERROR" ) )
                     _logLevel = ERROR;
                  else if( value.equalsIgnoreCase( "WARN" ) )
                     _logLevel = WARNING;
                  else if( value.equalsIgnoreCase( "INFO" ) )
                     _logLevel = INFO;
                  else if( value.equalsIgnoreCase( "DETAIL" ) )
                     _logLevel = DETAIL;
                  else if( value.equalsIgnoreCase( "DEBUG" ) )
                     _logLevel = DEBUG;
                  else
                     syntax();
               }
//               System.out.println( "Arg - " + key + " = " + value );
               _args.put( key.toUpperCase(), new Arg( value ) );
            }
            else
            {
               System.out.println( TAUtils.getNLSValue("ta.errmsg.InvalidArg", "Invalid argument") + ": " + key );
            }
         }
      }
      if( getArg( "servername" ) == null && getArg( "dumpIn" ) == null )
      {
         System.err.println( TAUtils.getNLSValue("ta.errmsg.MustSpecifyServName", "serverName or dumpIn must be specified") );
         syntax();
         System.exit( 1 );
      }
      String wasHome = getArg( "WAS_HOME" );
      if( wasHome == null )
         wasHome = System.getProperty( "WAS_HOME" );;
      if( wasHome != null )
      {
         _args.put( "WAS_HOME", new Arg( wasHome ) );
      }
   }

   protected static Hashtable _args   = new Hashtable();
   protected static String _validArgNames[] =
   {
      "analyze",
      "serverName",
      "was_home",
      "logLevel",
      "dumpOut",
      "dumpWait",
      "streamIn",
      "streamOut",
      "dumpIn",
      "detailXML",
      "reportOut",
      "reportType",
      "tmpDir",
      "dbDriver",
      "dbURL",
      "dumpType",
      "soapPort"
   };

   protected static Properties _pathMap = new Properties();
   protected static String _edition = null;
   public static final int DEBUG   = 4;
   public static final int DETAIL  = 3;
   public static final int INFO    = 2;
   public static final int WARNING = 1;
   public static final int ERROR   = 0;
   protected static int _logLevel         = INFO;
   protected static String _adminClasspath = null;
   protected static String _adminPath     = null;
   protected static Properties _adminProperties = null;

//B   public GetThreadDump getDumpInstance = null;
   private static DummyDialog myDummyDialog = null;
   private static Process browserProcess = null;
}

class DummyDialog extends javax.swing.JTextArea
{
    public void append (String s)
    {
        // just send to stdout
        System.out.print (s);
    }
}

class Arg
{
   public String _arg;
   public Arg( String val )
   {
      _arg = val;
   }
   public String get()
   {
      return _arg;
   }
}

class TAReaderThread extends Thread
{
   public TAReaderThread( InputStream out, InputStream err, OutputStream os )
   {
      _out = out;
      _err = err;
      _os = os;
	  _quit = false;
   }

   public void run()
   {
	  //System.err.println( "Starting ReaderThread..." );
      BufferedReader out = new BufferedReader( new InputStreamReader( _out ));
      BufferedReader err = new BufferedReader( new InputStreamReader( _err ));
      while( ! _quit )
      {
         String strOut = null;
         try
         {
            if( out.ready() )
            {
               if( _os == null )
               {
                  strOut = out.readLine();
                  System.out.println( strOut != null ? strOut : "" );
               }
               else
               {
                  while( out.ready() )
                  {
                     int inp = _out.read();
                     if( inp != -1 )
                        _os.write( inp );
                  }
                  _os.write( '\r' );
                  _os.write( '\n' );
               }
            }
            if( err.ready() )
            {
               strOut = err.readLine();

               System.err.println( strOut != null ? strOut : "" );
            }
            Thread.yield( ); // yield to other threads
         }
         catch( Exception e )
         {
            e.printStackTrace();
            break;
         }
      }

	  System.out.println( "Exiting ReaderThread..." );
   }

   public void setQuitFlag()
   {
	   _quit = true;
   }

   InputStream _err = null;
   InputStream _out = null;
   OutputStream _os = null;
   boolean _quit    = false;
}


