package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;

public class AgentImpl extends ConfigElementImpl implements Agent {

	public AgentImpl(CoreDocumentImpl doc) {
		super(doc, TAG);
	}

	public Option addOption() {
		OptionImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new OptionImpl(ownerDocument);
			appendChild(newElem);
		}
		return newElem;
	}

	public void setDataChannelSize(String value) {
		setAttribute(ConfigUtility.getString("Config.Agent.DataChannelSize.Tag"), value);
	}

	public void setName(String value) {
		setAttribute(ConfigUtility.getString("Config.Agent.Name.Tag"), value);
	}

	public void setType(String value) {
		setAttribute(ConfigUtility.getString("Config.Agent.Type.Tag"), value);
	}

	public void setClient(String value) {
		setAttribute(ConfigUtility.getString("Config.Agent.Client.Tag"), value);
	}

}
