package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;

public class VariableImpl extends ConfigElementImpl implements Variable {

	public VariableImpl(CoreDocumentImpl doc) {
		super(doc, TAG);
	}

	public void setName(String value) {
		setAttribute(ConfigUtility.getString("Config.Variable.Name.Tag"), value);
	}

	public String getName() {
		return getAttribute(ConfigUtility.getString("Config.Variable.Name.Tag"));
	}

	public void setValue(String value) {
		setAttribute(ConfigUtility.getString("Config.Variable.Value.Tag"), value);
	}

	public String getValue() {
		return getAttribute(ConfigUtility.getString("Config.Variable.Value.Tag"));
	}

	public void setPosition(String value) {
		setAttribute(ConfigUtility.getString("Config.Variable.Position.Tag"), value);
	}

	public String getPosition() {
		return getAttribute(ConfigUtility.getString("Config.Variable.Position.Tag"));
	}

	public void setConfiguration(String value) {
		// Do nothing
	}

}
